/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.io.PrintStream;
import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMemberInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.InnerClassesInfoVisitor;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class ClassFilePrinter
implements ClassFileVisitor,
CpInfoVisitor,
MemberInfoVisitor,
AttrInfoVisitor,
ExceptionInfoVisitor,
InnerClassesInfoVisitor,
AnnotationVisitor,
ElementValueVisitor,
InstructionVisitor {
    private static final String INDENTATION = "  ";
    private PrintStream ps;
    private int indentation;

    public ClassFilePrinter() {
        this(System.out);
    }

    public ClassFilePrinter(PrintStream printStream) {
        this.ps = printStream;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.println("_____________________________________________________________________");
        this.println(this.visitorInfo(programClassFile) + " CLASS: " + programClassFile.getName());
        this.println("Minor version: " + Integer.toHexString(programClassFile.u2minorVersion));
        this.println("Major version: " + Integer.toHexString(programClassFile.u2majorVersion));
        this.println("Access:        " + ClassUtil.externalClassAccessFlags(programClassFile.u2accessFlags) + "(" + Integer.toHexString(programClassFile.u2accessFlags) + ")");
        this.println("Superclass:    " + programClassFile.getSuperName());
        this.println();
        this.println("Interfaces (count = " + programClassFile.u2interfacesCount + "):");
        this.indent();
        for (int i = 0; i < programClassFile.u2interfacesCount; ++i) {
            this.println("+ " + programClassFile.getCpClassNameString(programClassFile.u2interfaces[i]));
        }
        this.outdent();
        this.println();
        this.println("Constant Pool (count = " + programClassFile.u2constantPoolCount + "):");
        this.indent();
        programClassFile.constantPoolEntriesAccept(this);
        this.outdent();
        this.println();
        this.println("Fields (count = " + programClassFile.u2fieldsCount + "):");
        this.indent();
        programClassFile.fieldsAccept(this);
        this.outdent();
        this.println();
        this.println("Methods (count = " + programClassFile.u2methodsCount + "):");
        this.indent();
        programClassFile.methodsAccept(this);
        this.outdent();
        this.println();
        this.println("Class file attributes (count = " + programClassFile.u2attributesCount + "):");
        this.indent();
        programClassFile.attributesAccept(this);
        this.outdent();
        this.println();
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        this.println("_____________________________________________________________________");
        this.println(this.visitorInfo(libraryClassFile) + " LIBRARY CLASS: " + libraryClassFile.getName());
        this.println("Access:     " + ClassUtil.externalClassAccessFlags(libraryClassFile.u2accessFlags) + "(" + Integer.toHexString(libraryClassFile.u2accessFlags) + ")");
        this.println("Superclass: " + libraryClassFile.getSuperName());
        this.println();
        this.println("Interfaces (count = " + libraryClassFile.interfaceClasses.length + "):");
        for (int i = 0; i < libraryClassFile.interfaceClasses.length; ++i) {
            this.println("  + " + libraryClassFile.interfaceClasses[i].getName());
        }
        this.println("Fields (count = " + libraryClassFile.fields.length + "):");
        libraryClassFile.fieldsAccept(this);
        this.println("Methods (count = " + libraryClassFile.methods.length + "):");
        libraryClassFile.methodsAccept(this);
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        this.println(this.visitorInfo(classCpInfo) + " Class [" + classFile.getCpString(classCpInfo.u2nameIndex) + "]");
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
        this.println(this.visitorInfo(doubleCpInfo) + " Double [" + Double.longBitsToDouble((long)doubleCpInfo.u4highBytes << 32 | (long)doubleCpInfo.u4lowBytes) + "]");
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        this.println(this.visitorInfo(fieldrefCpInfo) + " Fieldref [" + classFile.getCpClassNameString(fieldrefCpInfo.u2classIndex) + "." + classFile.getCpNameString(fieldrefCpInfo.u2nameAndTypeIndex) + " " + classFile.getCpTypeString(fieldrefCpInfo.u2nameAndTypeIndex) + "]");
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
        this.println(this.visitorInfo(floatCpInfo) + " Float [" + Float.intBitsToFloat(floatCpInfo.u4bytes) + "]");
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
        this.println(this.visitorInfo(integerCpInfo) + " Integer [" + integerCpInfo.u4bytes + "]");
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.println(this.visitorInfo(interfaceMethodrefCpInfo) + " InterfaceMethodref [" + classFile.getCpClassNameString(interfaceMethodrefCpInfo.u2classIndex) + "." + classFile.getCpNameString(interfaceMethodrefCpInfo.u2nameAndTypeIndex) + " " + classFile.getCpTypeString(interfaceMethodrefCpInfo.u2nameAndTypeIndex) + "]");
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
        this.println(this.visitorInfo(longCpInfo) + " Long [" + ((long)longCpInfo.u4highBytes << 32 | (long)longCpInfo.u4lowBytes) + "]");
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.println(this.visitorInfo(methodrefCpInfo) + " Methodref [" + classFile.getCpClassNameString(methodrefCpInfo.u2classIndex) + "." + classFile.getCpNameString(methodrefCpInfo.u2nameAndTypeIndex) + " " + classFile.getCpTypeString(methodrefCpInfo.u2nameAndTypeIndex) + "]");
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
        this.println(this.visitorInfo(nameAndTypeCpInfo) + " NameAndType [" + classFile.getCpString(nameAndTypeCpInfo.u2nameIndex) + " " + classFile.getCpString(nameAndTypeCpInfo.u2descriptorIndex) + "]");
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        this.println(this.visitorInfo(stringCpInfo) + " String [" + classFile.getCpString(stringCpInfo.u2stringIndex) + "]");
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
        this.println(this.visitorInfo(utf8CpInfo) + " Utf8 [" + utf8CpInfo.getString() + "]");
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        this.println(this.visitorInfo(programMemberInfo) + " " + programClassFile.getCpString(programMemberInfo.u2nameIndex) + " " + programClassFile.getCpString(programMemberInfo.u2descriptorIndex));
        if (programMemberInfo.u2attributesCount > 0) {
            this.indent();
            this.println("Class member attributes (count = " + programMemberInfo.u2attributesCount + "):");
            programMemberInfo.attributesAccept(programClassFile, this);
            this.outdent();
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.visitLibraryMemberInfo(libraryClassFile, libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.visitLibraryMemberInfo(libraryClassFile, libraryMethodInfo);
    }

    private void visitLibraryMemberInfo(LibraryClassFile libraryClassFile, LibraryMemberInfo libraryMemberInfo) {
        this.println(this.visitorInfo(libraryMemberInfo) + " " + libraryMemberInfo.getName(libraryClassFile) + " " + libraryMemberInfo.getDescriptor(libraryClassFile));
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
        this.println(this.visitorInfo(unknownAttrInfo) + " Unknown attribute (" + classFile.getCpString(unknownAttrInfo.u2attrNameIndex) + ")");
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        this.println(this.visitorInfo(innerClassesAttrInfo) + " Inner classes attribute (count = " + innerClassesAttrInfo.u2numberOfClasses + ")");
        this.indent();
        innerClassesAttrInfo.innerClassEntriesAccept(classFile, this);
        this.outdent();
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        this.println(this.visitorInfo(enclosingMethodAttrInfo) + " Enclosing method attribute [" + classFile.getCpClassNameString(enclosingMethodAttrInfo.u2classIndex) + (enclosingMethodAttrInfo.u2nameAndTypeIndex == 0 ? "" : "." + classFile.getCpNameString(enclosingMethodAttrInfo.u2nameAndTypeIndex) + " " + classFile.getCpTypeString(enclosingMethodAttrInfo.u2nameAndTypeIndex)) + "]");
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
        this.println(this.visitorInfo(constantValueAttrInfo) + " Constant value attribute:");
        classFile.constantPoolEntryAccept(constantValueAttrInfo.u2constantValueIndex, this);
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
        this.println(this.visitorInfo(exceptionsAttrInfo) + " Exceptions attribute (count = " + exceptionsAttrInfo.u2numberOfExceptions + ")");
        this.indent();
        exceptionsAttrInfo.exceptionEntriesAccept((ProgramClassFile)classFile, this);
        this.outdent();
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        this.println(this.visitorInfo(codeAttrInfo) + " Code attribute instructions (code length = " + codeAttrInfo.u4codeLength + ", locals = " + codeAttrInfo.u2maxLocals + ", stack = " + codeAttrInfo.u2maxStack + "):");
        this.indent();
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        this.println("Code attribute exceptions (count = " + codeAttrInfo.u2exceptionTableLength + "):");
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
        this.println("Code attribute attributes (attribute count = " + codeAttrInfo.u2attributesCount + "):");
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
        this.outdent();
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        this.println(this.visitorInfo(lineNumberTableAttrInfo) + " Line number table attribute (count = " + lineNumberTableAttrInfo.u2lineNumberTableLength + ")");
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        this.println(this.visitorInfo(localVariableTableAttrInfo) + " Local variable table attribute (count = " + localVariableTableAttrInfo.u2localVariableTableLength + ")");
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        this.println(this.visitorInfo(localVariableTypeTableAttrInfo) + " Local variable type table attribute (count = " + localVariableTypeTableAttrInfo.u2localVariableTypeTableLength + ")");
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        this.println(this.visitorInfo(sourceFileAttrInfo) + " Source file attribute:");
        this.indent();
        classFile.constantPoolEntryAccept(sourceFileAttrInfo.u2sourceFileIndex, this);
        this.outdent();
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        this.println(this.visitorInfo(sourceDirAttrInfo) + " Source dir attribute:");
        this.indent();
        classFile.constantPoolEntryAccept(sourceDirAttrInfo.u2sourceDirIndex, this);
        this.outdent();
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
        this.println(this.visitorInfo(deprecatedAttrInfo) + " Deprecated attribute");
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
        this.println(this.visitorInfo(syntheticAttrInfo) + " Synthetic attribute");
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        this.println(this.visitorInfo(signatureAttrInfo) + " Signature attribute:");
        this.indent();
        classFile.constantPoolEntryAccept(signatureAttrInfo.u2signatureIndex, this);
        this.outdent();
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        this.println(this.visitorInfo(runtimeVisibleAnnotationsAttrInfo) + " Runtime visible annotation attribute:");
        this.indent();
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
        this.outdent();
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        this.println(this.visitorInfo(runtimeInvisibleAnnotationsAttrInfo) + " Runtime invisible annotation attribute:");
        this.indent();
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
        this.outdent();
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        this.println(this.visitorInfo(runtimeVisibleParameterAnnotationsAttrInfo) + " Runtime visible parameter annotation attribute:");
        this.indent();
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
        this.outdent();
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        this.println(this.visitorInfo(runtimeInvisibleParameterAnnotationsAttrInfo) + " Runtime invisible parameter annotation attribute:");
        this.indent();
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
        this.outdent();
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        this.println(this.visitorInfo(annotationDefaultAttrInfo) + " Annotation default attribute:");
        this.indent();
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
        this.outdent();
    }

    public void visitInnerClassesInfo(ClassFile classFile, InnerClassesInfo innerClassesInfo) {
        this.println(this.visitorInfo(innerClassesInfo) + " InnerClassesInfo:");
        this.indent();
        if (innerClassesInfo.u2innerClassInfoIndex != 0) {
            classFile.constantPoolEntryAccept(innerClassesInfo.u2innerClassInfoIndex, this);
        }
        if (innerClassesInfo.u2outerClassInfoIndex != 0) {
            classFile.constantPoolEntryAccept(innerClassesInfo.u2outerClassInfoIndex, this);
        }
        if (innerClassesInfo.u2innerNameIndex != 0) {
            classFile.constantPoolEntryAccept(innerClassesInfo.u2innerNameIndex, this);
        }
        this.outdent();
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        this.println(this.visitorInfo(annotation) + " Annotation [" + classFile.getCpString(annotation.u2typeIndex) + "]:");
        this.indent();
        annotation.elementValuesAccept(classFile, this);
        this.outdent();
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
        this.println(this.visitorInfo(constantElementValue) + " Constant element value [" + (constantElementValue.u2elementName == 0 ? "(default)" : classFile.getCpString(constantElementValue.u2elementName)) + "]");
        this.indent();
        classFile.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
        this.outdent();
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.println(this.visitorInfo(enumConstantElementValue) + " Enum constant element value [" + (enumConstantElementValue.u2elementName == 0 ? "(default)" : classFile.getCpString(enumConstantElementValue.u2elementName)) + ", " + classFile.getCpString(enumConstantElementValue.u2typeNameIndex) + ", " + classFile.getCpString(enumConstantElementValue.u2constantNameIndex) + "]");
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        this.println(this.visitorInfo(classElementValue) + " Class element value [" + (classElementValue.u2elementName == 0 ? "(default)" : classFile.getCpString(classElementValue.u2elementName)) + ", " + classFile.getCpString(classElementValue.u2classInfoIndex) + "]");
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.println(this.visitorInfo(annotationElementValue) + " Annotation element value [" + (annotationElementValue.u2elementName == 0 ? "(default)" : classFile.getCpString(annotationElementValue.u2elementName)) + "]:");
        this.indent();
        annotationElementValue.annotationAccept(classFile, this);
        this.outdent();
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.println(this.visitorInfo(arrayElementValue) + " Array element value [" + (arrayElementValue.u2elementName == 0 ? "(default)" : classFile.getCpString(arrayElementValue.u2elementName)) + "]:");
        this.indent();
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
        this.outdent();
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        this.println(InstructionFactory.create(codeAttrInfo.code, n).toString(n));
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        this.println(InstructionFactory.create(codeAttrInfo.code, n).toString(n));
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        this.println(InstructionFactory.create(codeAttrInfo.code, n).toString(n));
        this.indent();
        classFile.constantPoolEntryAccept(cpInstruction.cpIndex, this);
        this.outdent();
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        this.println(InstructionFactory.create(codeAttrInfo.code, n).toString(n));
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        this.println(InstructionFactory.create(codeAttrInfo.code, n).toString(n));
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.println(InstructionFactory.create(codeAttrInfo.code, n).toString(n));
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        this.println(this.visitorInfo(exceptionInfo) + " ExceptionInfo:");
        if (exceptionInfo.u2catchType != 0) {
            classFile.constantPoolEntryAccept(exceptionInfo.u2catchType, this);
        }
    }

    private void indent() {
        ++this.indentation;
    }

    private void outdent() {
        --this.indentation;
    }

    private void println() {
        this.ps.println();
    }

    private void println(String string) {
        for (int i = 0; i < this.indentation; ++i) {
            this.ps.print(INDENTATION);
        }
        this.ps.println(string);
    }

    private String visitorInfo(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == null ? "-" : "+";
    }
}

