/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MemberInfoClassFileAccessFilter
implements MemberInfoVisitor {
    private ClassFile referencingClassFile;
    private MemberInfoVisitor memberInfoVisitor;

    public MemberInfoClassFileAccessFilter(ClassFile classFile, MemberInfoVisitor memberInfoVisitor) {
        this.referencingClassFile = classFile;
        this.memberInfoVisitor = memberInfoVisitor;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (this.accepted(programClassFile, programFieldInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitProgramFieldInfo(programClassFile, programFieldInfo);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (this.accepted(programClassFile, programMethodInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        if (this.accepted(libraryClassFile, libraryFieldInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitLibraryFieldInfo(libraryClassFile, libraryFieldInfo);
        }
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (this.accepted(libraryClassFile, libraryMethodInfo.getAccessFlags())) {
            this.memberInfoVisitor.visitLibraryMethodInfo(libraryClassFile, libraryMethodInfo);
        }
    }

    private boolean accepted(ClassFile classFile, int n) {
        int n2 = AccessUtil.accessLevel(n);
        return n2 >= 3 || n2 >= 0 && this.referencingClassFile.equals(classFile) || n2 >= 1 && ClassUtil.internalPackageName(this.referencingClassFile.getName()).equals(ClassUtil.internalPackageName(classFile.getName())) || n2 >= 2 && (this.referencingClassFile.extends_(classFile) || this.referencingClassFile.implements_(classFile));
    }
}

