/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter12;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;

public class CmdLineClientAdapterFactory
extends SVNClientAdapterFactory {
    public static final String COMMANDLINE_CLIENT = "commandline";
    private static boolean is13ClientAvailable = false;
    private String subversionPath;

    private CmdLineClientAdapterFactory(String subversionPath) {
        this.subversionPath = subversionPath;
    }

    protected ISVNClientAdapter createSVNClientImpl() {
        if (is13ClientAvailable) {
            return new CmdLineClientAdapter(this.subversionPath, new CmdLineNotificationHandler());
        }
        return new CmdLineClientAdapter12(this.subversionPath, new CmdLineNotificationHandler());
    }

    protected String getClientType() {
        return COMMANDLINE_CLIENT;
    }

    public static void setup() throws SVNClientException {
        CmdLineClientAdapterFactory.setup(null, false);
    }

    public static void setup13(String subversionPath) throws SVNClientException {
        CmdLineClientAdapterFactory.setup(subversionPath, true);
    }

    private static void setup(String subversionPath, boolean setup13) throws SVNClientException {
        if (subversionPath == null) {
            subversionPath = "";
        } else if (subversionPath.length() > 0 && !subversionPath.endsWith(File.separator)) {
            subversionPath = subversionPath + File.separator;
        }
        is13ClientAvailable = CmdLineClientAdapter.isAvailable(subversionPath);
        if (!(is13ClientAvailable || !setup13 && CmdLineClientAdapter12.isAvailable(subversionPath))) {
            throw new SVNClientException("Command line client adapter is not available");
        }
        SVNClientAdapterFactory.registerAdapterFactory(new CmdLineClientAdapterFactory(subversionPath), true);
    }
}

