/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline.parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotify;
import org.tigris.subversion.svnclientadapter.commandline.parser.SvnActionRE;

public class SvnOutputParser {
    private static final Logger log = Logger.getLogger(SvnOutputParser.class.getName());
    private static final String NEWLINE = "\n\r";
    private SvnActionRE[] svnActionsRE = new SvnActionRE[]{new SvnActionRE("Skipped missing target: '(.+)'", 7, 3, new String[]{"path"}), new SvnActionRE("Skipped '(.+)'", 7, "path"), new SvnActionRE("D    ([^ ].+)", 8, "path"), new SvnActionRE("A    ([^ ].+)", 9, "path"), new SvnActionRE("Restored '(.+)'", 3, "path"), new SvnActionRE("Reverted '(.+)'", 4, "path"), new SvnActionRE("Failed to revert '(.+)' -- try updating instead\\.", 5, "path"), new SvnActionRE("Resolved conflicted state of '(.+)'", 6, "path"), new SvnActionRE("A  \\(bin\\)  ([^ ].+)", 0, "path"), new SvnActionRE("A         ([^ ].+)", 0, "path"), new SvnActionRE("D         ([^ ].+)", 2, "path"), new SvnActionRE("([CGU ])([CGU ])   (.+)", 10, new String[]{"contentState", "propState", "path"}), new SvnActionRE("Fetching external item into '(.+)'", 12, "path"), new SvnActionRE("Exported external at revision (\\d+)\\.", 11, "revision"), new SvnActionRE("Exported revision (\\d+)\\.", 11, "revision"), new SvnActionRE("Checked out external at revision (\\d+)\\.", 11, "revision"), new SvnActionRE("Checked out revision (\\d+)\\.", 11, "revision"), new SvnActionRE("Updated external to revision (\\d+)\\.", 11, "revision"), new SvnActionRE("Updated to revision (\\d+)\\.", 11, "revision"), new SvnActionRE("External at revision (\\d+)\\.", 11, "revision"), new SvnActionRE("At revision (\\d+)\\.", 11, "revision"), new SvnActionRE("External export complete\\.", 11, 0, 0), new SvnActionRE("Export complete\\.", 11, 0, 0), new SvnActionRE("External checkout complete\\.", 11, 0, 0), new SvnActionRE("Checkout complete\\.", 11, 0, 0), new SvnActionRE("External update complete\\.", 11, 0, 0), new SvnActionRE("Update complete\\.", 11, 0, 0), new SvnActionRE("Performing status on external item at '(.+)'", 14, "path"), new SvnActionRE("Status against revision:  *(\\d+)", 13, "revision"), new SvnActionRE("Sending        (.+)", 15, "path"), new SvnActionRE("Adding  \\(bin\\)  (.+)", 16, "path"), new SvnActionRE("Adding         (.+)", 16, "path"), new SvnActionRE("Deleting       (.+)", 17, "path"), new SvnActionRE("Replacing      (.+)", 18, "path"), new SvnActionRE("Transmitting file data \\.*", 19), new SvnActionRE("'(.+)' locked by user.*", 21), new SvnActionRE("'(.+)' unlocked.*", 22), new SvnActionRE("Committed revision (\\d+)\\.", -1, "revision")};
    private List listeners = new LinkedList();

    public void addListener(CmdLineNotify listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CmdLineNotify listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String svnOutput) {
        StringTokenizer st = new StringTokenizer(svnOutput, NEWLINE);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            SvnOutputParser svnOutputParser = this;
            synchronized (svnOutputParser) {
                SvnActionRE svnActionRE = this.getMatchingSvnActionRE(line);
                if (svnActionRE != null) {
                    this.notifyListeners(svnActionRE);
                } else {
                    log.warning("Can't find a svn action for svn output line : " + line);
                }
            }
        }
    }

    private SvnActionRE getMatchingSvnActionRE(String line) {
        SvnActionRE result = null;
        for (int i = 0; i < this.svnActionsRE.length; ++i) {
            if (!this.svnActionsRE[i].match(line)) continue;
            if (result != null) {
                log.severe("Multiple regular expressions match : " + line);
                continue;
            }
            result = this.svnActionsRE[i];
        }
        return result;
    }

    private void notifyListeners(SvnActionRE svnActionRE) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            CmdLineNotify listener = (CmdLineNotify)it.next();
            listener.onNotify(svnActionRE.getPath(), svnActionRE.getAction(), SVNNodeKind.UNKNOWN.toInt(), null, svnActionRE.getContentState(), svnActionRE.getPropStatus(), svnActionRE.getRevision());
        }
    }
}

