/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime;

import com.sun.encoder.runtime.ReaderInputStream;
import com.sun.encoder.runtime.provider.Base64Coder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class WriterOutputStream
extends OutputStream {
    private static final int DEFAULT_BUF_SIZE = 2048;
    private final int mBufferSize;
    private final Writer mWriter;
    private final CharsetDecoder mCharsetDecoder;
    private final boolean mIsBase64;
    private ByteBuffer mByteBuf;
    private CharBuffer mCharBuf;
    private byte[] mOneByte = new byte[1];

    public WriterOutputStream(Writer writer, String encoding) throws UnsupportedEncodingException {
        this(writer, encoding, 2048);
    }

    public WriterOutputStream(Writer writer, String encoding, int bufferSize) throws UnsupportedEncodingException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Illegal buffer size: " + bufferSize);
        }
        this.mIsBase64 = "base64".equals(encoding);
        this.mBufferSize = bufferSize;
        this.mWriter = writer;
        this.mCharsetDecoder = this.mIsBase64 ? null : Charset.forName(encoding).newDecoder();
        this.mByteBuf = ByteBuffer.allocate(this.mBufferSize + 128);
        this.mByteBuf.flip();
        this.mCharBuf = CharBuffer.allocate(this.mByteBuf.capacity() * 4 / 3 + 4);
    }

    public void close() throws IOException {
        this.flushToWriter(true);
        this.mWriter.flush();
        this.mWriter.close();
    }

    public void flush() throws IOException {
        this.flushToWriter(false);
        this.mWriter.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= this.mBufferSize) {
            this.writeInternal(b, off, len);
            return;
        }
        int count = len / this.mBufferSize;
        for (int i = 0; i < count; ++i) {
            this.writeInternal(b, off + i * this.mBufferSize, this.mBufferSize);
        }
        this.writeInternal(b, off + count * this.mBufferSize, len - count * this.mBufferSize);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.mOneByte[0] = (byte)(b & 0xFF);
        this.write(this.mOneByte);
    }

    public void flushToWriter(boolean done) throws IOException {
        if (!this.mByteBuf.hasRemaining()) {
            return;
        }
        this.mCharBuf.limit(this.mCharBuf.capacity());
        this.mCharBuf.rewind();
        if (!this.mIsBase64) {
            if (this.mByteBuf.remaining() > this.mCharBuf.remaining()) {
                this.mCharBuf = CharBuffer.allocate(this.mByteBuf.remaining());
            }
            this.mCharsetDecoder.decode(this.mByteBuf, this.mCharBuf, done);
        } else {
            if (!done && this.mByteBuf.remaining() < 3) {
                return;
            }
            if (this.mByteBuf.remaining() * 4 / 3 > this.mCharBuf.remaining()) {
                this.mCharBuf = CharBuffer.allocate(this.mByteBuf.remaining() * 4 / 3 + 4);
            }
            if (done) {
                this.mCharBuf.put(Base64Coder.encodeToString(this.mByteBuf.array(), this.mByteBuf.arrayOffset() + this.mByteBuf.position(), this.mByteBuf.remaining()));
                this.mByteBuf.position(this.mByteBuf.limit());
            } else {
                int count = this.mByteBuf.remaining() / 3 * 3;
                if (count > 0) {
                    this.mCharBuf.put(Base64Coder.encodeToString(this.mByteBuf.array(), this.mByteBuf.arrayOffset() + this.mByteBuf.position(), count));
                    this.mByteBuf.position(this.mByteBuf.position() + count);
                }
            }
        }
        this.mCharBuf.flip();
        if (this.mCharBuf.hasRemaining()) {
            if (this.mCharBuf.hasArray()) {
                this.mWriter.write(this.mCharBuf.array(), this.mCharBuf.position() + this.mCharBuf.arrayOffset(), this.mCharBuf.remaining());
            } else {
                this.mWriter.write(this.mCharBuf.toString());
            }
        }
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        this.makeRoom(len);
        this.mByteBuf.mark();
        this.mByteBuf.position(this.mByteBuf.limit());
        this.mByteBuf.limit(this.mByteBuf.capacity());
        this.mByteBuf.put(b, off, len);
        this.mByteBuf.limit(this.mByteBuf.position());
        this.mByteBuf.reset();
        this.flushToWriter(false);
    }

    private void makeRoom(int required) {
        if (required <= this.mByteBuf.capacity() - this.mByteBuf.limit()) {
            return;
        }
        if (required <= this.mByteBuf.capacity() - this.mByteBuf.remaining()) {
            this.mByteBuf.compact();
            this.mByteBuf.flip();
            return;
        }
        ByteBuffer buf = this.mByteBuf;
        this.mByteBuf = ByteBuffer.allocate(buf.remaining() + required);
        this.mByteBuf.put(buf);
        this.mByteBuf.flip();
    }

    public static void main(String[] argv) {
        try {
            int read;
            Writer writer = new StringWriter();
            OutputStream out = new WriterOutputStream(writer, "UTF-8", 64);
            InputStream in = new FileInputStream("c:/temp/utf8.txt");
            byte[] buf = new byte[85];
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            in.close();
            out.close();
            String result = writer.toString();
            System.out.println(result);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream("c:/temp/utf8_r1.txt"), "UTF-8");
            writer.write(result);
            writer.close();
            Reader reader = new StringReader(result);
            in = new ReaderInputStream(reader, "UTF-8", 64);
            out = new FileOutputStream("c:/temp/utf8_r2.txt");
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            in.close();
            out.close();
            reader = new InputStreamReader((InputStream)new FileInputStream("c:/temp/base64.txt"), "ASCII");
            in = new ReaderInputStream(reader, "base64", 96);
            out = new FileOutputStream("c:/temp/base64_r1.html");
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            in.close();
            out.close();
            in = new FileInputStream("c:/temp/base64_r1.html");
            writer = new StringWriter();
            out = new WriterOutputStream(writer, "base64", 96);
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            in.close();
            out.close();
            result = writer.toString();
            System.out.println(result);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream("c:/temp/base64_r2.txt"), "ASCII");
            writer.write(result);
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

