/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import com.sun.encoder.runtime.CoderException;
import com.sun.encoder.runtime.provider.SharedCoder;

public class Utf16Coder
extends SharedCoder {
    private boolean mLittle = false;
    private boolean mValid = false;
    public static final int ORDER_MARK = 65519;

    public Utf16Coder(boolean little, boolean valid) {
        this.mLittle = little;
        this.mValid = valid;
    }

    public byte[] encode(String s, int min, int max) throws CoderException {
        if (s == null) {
            return null;
        }
        if (0 <= min && 0 <= max && max < min) {
            throw new IllegalArgumentException("max (" + max + ") < min (" + min + ")");
        }
        int len = s.length();
        int bytes = len * 2;
        int size = 0;
        if (bytes < min && ((bytes = min) & 1) != 0) {
            throw new CoderException("odd size: min=" + min);
        }
        if (0 <= max && max < bytes) {
            throw new CoderException("too big: " + bytes + ", max=" + max);
        }
        byte[] b = new byte[len * 2];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (this.mLittle) {
                b[size++] = (byte)(c & 0xFF);
                b[size++] = (byte)(c >> 8);
                continue;
            }
            b[size++] = (byte)(c >> 8);
            b[size++] = (byte)(c & 0xFF);
        }
        if (this.mLittle) {
            while (size < bytes) {
                b[size++] = 32;
                b[size++] = 0;
            }
        } else {
            while (size < bytes) {
                b[size++] = 0;
                b[size++] = 32;
            }
        }
        return b;
    }

    public String decode(byte[] b, int from, int length) throws CoderException {
        if (b == null) {
            return null;
        }
        if (from < 0 || b.length < from || length < 0 || b.length < from + length) {
            throw new CoderException("invalid size/from/length: " + b.length + "/" + from + "/" + length);
        }
        if ((length & 1) != 0) {
            throw new CoderException("odd length: " + length);
        }
        char[] c = new char[length / 2];
        int size = 0;
        int base = 0;
        int last = from + length;
        for (int i = from; i < last; i += 2) {
            int n = 0xFFFF & (this.mLittle ? b[i + 1] << 8 | b[i] & 0xFF : b[i] << 8 | b[i + 1] & 0xFF);
            if (n == 65519) {
                if (size > 0) {
                    throw new CoderException(i, "non-initial order mark");
                }
                base = 1;
            } else if (this.mValid && !Character.isDefined((char)n)) {
                throw new CoderException(i, "code = " + Utf16Coder.uname(n) + ", not valid Unicode");
            }
            c[size++] = (char)n;
        }
        return new String(c, base, c.length - base);
    }
}

