/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.DeploymentDialogOperator;
import org.netbeans.modules.visualweb.gravy.RaveWindowOperator;
import org.netbeans.modules.visualweb.gravy.Util;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.Toolbar;

public class MainWindowOperator
extends JFrameOperator {
    JButtonOperator deployButton;
    private static StatusTextTracer statusTextTracer = null;

    public MainWindowOperator() {
        super((JFrame)RaveWindowOperator.getDefaultRave().getSource());
        this.copyEnvironment((Operator)RaveWindowOperator.getDefaultRave());
    }

    public void saveAll() {
        new JButtonOperator((ContainerOperator)this, (ComponentChooser)new JComponentOperator.JComponentByTipFinder("Save All")).push();
    }

    public DeploymentDialogOperator deploy() {
        this.btDeploy().push();
        DeploymentDialogOperator dlg = null;
        long oldWaitTime = Util.getMainWindow().getTimeouts().getTimeout("DialogWaiter.WaitDialogTimeout");
        try {
            Util.getMainWindow().getTimeouts().setTimeout("DialogWaiter.WaitDialogTimeout", 100000L);
            dlg = new DeploymentDialogOperator();
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.getMainWindow().getTimeouts().setTimeout("DialogWaiter.WaitDialogTimeout", oldWaitTime);
        }
        return dlg;
    }

    public void deployProject() {
        DeploymentDialogOperator dlg = this.deploy();
        dlg.setAutoHide(false);
        dlg.waitCompleted();
        Util.wait(1000);
        dlg.close();
    }

    public JButtonOperator btDeploy() {
        if (this.deployButton == null) {
            this.deployButton = new JButtonOperator((ContainerOperator)this, (ComponentChooser)new JComponentOperator.JComponentByTipFinder(Bundle.getStringTrimmed("org.netbeans.modules.project.ui.actions.Bundle", "LBL_RunMainProjectAction_Name")));
            this.deployButton.getTimeouts().setTimeout("ComponentOperator.WaitStateTimeout", 60000L);
        }
        return this.deployButton;
    }

    public String getStatusText() {
        return StatusDisplayer.getDefault().getStatusText();
    }

    public void setStatusText(String newStatusText) {
        StatusDisplayer.getDefault().setStatusText(newStatusText);
    }

    public synchronized StatusTextTracer getStatusTextTracer() {
        if (statusTextTracer == null) {
            statusTextTracer = new StatusTextTracer();
        }
        return statusTextTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitStatusText(String text) {
        this.getStatusTextTracer().start();
        try {
            if (!this.getComparator().equals(this.getStatusText(), text)) {
                this.getStatusTextTracer().waitText(text);
            }
        }
        finally {
            this.getStatusTextTracer().stop();
        }
    }

    public ContainerOperator getToolbar(int index) {
        ToolbarChooser chooser = new ToolbarChooser();
        return new ContainerOperator((Container)MainWindowOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)chooser, (int)index));
    }

    public ContainerOperator getToolbar(String toolbarName) {
        ToolbarChooser chooser = new ToolbarChooser(toolbarName, this.getComparator());
        return new ContainerOperator((Container)MainWindowOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)chooser));
    }

    public int getToolbarCount() {
        ToolbarChooser chooser = new ToolbarChooser("Non sense name - @#$%^&*", this.getComparator());
        MainWindowOperator.findComponent((Container)((Container)this.getSource()), (ComponentChooser)chooser);
        return chooser.getCount();
    }

    public String getToolbarName(int index) {
        return ((Toolbar)this.getToolbar(index).getSource()).getDisplayName();
    }

    public JButtonOperator getToolbarButton(ContainerOperator toolbarOper, String buttonTooltip) {
        ToolbarButtonChooser chooser = new ToolbarButtonChooser(buttonTooltip, this.getComparator());
        return new JButtonOperator(JButtonOperator.waitJButton((Container)((Container)toolbarOper.getSource()), (ComponentChooser)chooser));
    }

    public JButtonOperator getToolbarButton(ContainerOperator toolbarOper, int index) {
        return new JButtonOperator(toolbarOper, index);
    }

    public void pushToolbarPopupMenu(String popupPath) {
        ContainerOperator contOper = this.getToolbar(0);
        contOper.clickForPopup(contOper.getWidth() - 1, contOper.getHeight() / 2);
        new JPopupMenuOperator().pushMenu(popupPath, "|");
    }

    public void pushToolbarPopupMenuNoBlock(String popupPath) {
        ContainerOperator contOper = this.getToolbar(0);
        contOper.clickForPopup(contOper.getWidth() - 1, contOper.getHeight() / 2);
        new JPopupMenuOperator().pushMenuNoBlock(popupPath, "|");
    }

    public void dragNDropToolbar(ContainerOperator toolbarOper, int x, int y) {
        ComponentChooser chooser = new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                if (comp instanceof JPanel) {
                    String className = comp.getClass().getName();
                    return className.equals("org.openide.awt.Toolbar$ToolbarBump") || className.equals("org.openide.awt.Toolbar$ToolbarGrip");
                }
                return false;
            }

            public String getDescription() {
                return "org.openide.awt.Toolbar$ToolbarBump or org.openide.awt.Toolbar$ToolbarGrip";
            }
        };
        Component comp = MainWindowOperator.findComponent((Container)((Container)toolbarOper.getSource()), (ComponentChooser)chooser);
        new ComponentOperator(comp).dragNDrop(comp.getWidth() / 2, comp.getHeight() / 2, x, y);
    }

    private static class ToolbarButtonChooser
    implements ComponentChooser {
        private String buttonTooltip;
        private Operator.StringComparator comparator;

        public ToolbarButtonChooser(String buttonTooltip, Operator.StringComparator comparator) {
            this.buttonTooltip = buttonTooltip;
            this.comparator = comparator;
        }

        public boolean checkComponent(Component comp) {
            return this.comparator.equals(((JComponent)comp).getToolTipText(), this.buttonTooltip);
        }

        public String getDescription() {
            return "Toolbar button with tooltip \"" + this.buttonTooltip + "\".";
        }
    }

    private static class ToolbarChooser
    implements ComponentChooser {
        private String toolbarName;
        private Operator.StringComparator comparator;
        private int count = 0;

        public ToolbarChooser(String toolbarName, Operator.StringComparator comparator) {
            this.toolbarName = toolbarName;
            this.comparator = comparator;
        }

        public ToolbarChooser() {
            this.comparator = null;
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof Toolbar) {
                ++this.count;
                if (this.comparator != null) {
                    return this.comparator.equals(((Toolbar)comp).getDisplayName(), this.toolbarName);
                }
                return true;
            }
            return false;
        }

        public String getDescription() {
            return "org.openide.awt.Toolbar";
        }

        public int getCount() {
            return this.count;
        }
    }

    public class StatusTextTracer
    implements ChangeListener {
        private ArrayList statusTextHistory = new ArrayList();

        public void start() {
            this.stop();
            this.clear();
            StatusDisplayer.getDefault().addChangeListener((ChangeListener)this);
        }

        public void stop() {
            StatusDisplayer.getDefault().removeChangeListener((ChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent evt) {
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                this.statusTextHistory.add(StatusDisplayer.getDefault().getStatusText());
                JemmyProperties.getCurrentOutput().printTrace("Status text changed to: \"" + StatusDisplayer.getDefault().getStatusText() + "\"");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                this.statusTextHistory.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(String text, boolean removeCompared) {
            Operator.StringComparator comparator = MainWindowOperator.this.getComparator();
            StatusTextTracer statusTextTracer = this;
            synchronized (statusTextTracer) {
                if (removeCompared) {
                    while (!this.statusTextHistory.isEmpty()) {
                        String status = (String)this.statusTextHistory.remove(0);
                        if (!comparator.equals(status, text)) continue;
                        return true;
                    }
                } else {
                    for (int i = 0; i < this.statusTextHistory.size(); ++i) {
                        if (!comparator.equals((String)this.statusTextHistory.get(i), text)) continue;
                        return true;
                    }
                }
                return false;
            }
        }

        public void waitText(String text) {
            this.waitText(text, false);
        }

        public void waitText(final String text, final boolean removeCompared) {
            try {
                new Waiter(new Waitable(){

                    public Object actionProduced(Object anObject) {
                        return StatusTextTracer.this.contains(text, removeCompared) ? Boolean.TRUE : null;
                    }

                    public String getDescription() {
                        return "Wait status text equals to " + text;
                    }
                }).waitAction(null);
            }
            catch (InterruptedException e) {
                throw new JemmyException("Interrupted.", (Throwable)e);
            }
        }

        public void finalize() {
            this.stop();
        }

        public ArrayList getStatusTextHistory() {
            return this.statusTextHistory;
        }

        public void printStatusTextHistory(PrintStream outputPrintStream) {
            for (int i = 0; i < this.statusTextHistory.size(); ++i) {
                outputPrintStream.println(this.statusTextHistory.get(i).toString());
            }
        }
    }
}

