/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties.editors;

import java.awt.Point;
import java.awt.Robot;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.modules.visualweb.gravy.NbDialogOperator;

public class FindEditorOperator
extends NbDialogOperator {
    private JLabelOperator _lblFindWhat;
    private JComboBoxOperator _cboFindWhat;
    public static final String ITEM_ = "";
    private JCheckBoxOperator _cbHighlightSearch;
    private JCheckBoxOperator _cbIncrementalSearch;
    private JCheckBoxOperator _cbMatchCase;
    private JCheckBoxOperator _cbSmartCase;
    private JCheckBoxOperator _cbMatchWholeWordsOnly;
    private JCheckBoxOperator _cbBackwardSearch;
    private JCheckBoxOperator _cbWrapSearch;
    private JButtonOperator _btFind;
    private JButtonOperator _btClose;
    private JButtonOperator _btHelp;

    public FindEditorOperator() {
        super(ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-title"));
    }

    public FindEditorOperator(JDialogOperator wrapper) {
        super((JDialog)wrapper.getSource());
    }

    public JLabelOperator lblFindWhat() {
        if (this._lblFindWhat == null) {
            this._lblFindWhat = new JLabelOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-what"));
        }
        return this._lblFindWhat;
    }

    public JComboBoxOperator cboFindWhat() {
        if (this._cboFindWhat == null) {
            this._cboFindWhat = new JComboBoxOperator((ContainerOperator)this);
        }
        return this._cboFindWhat;
    }

    public JCheckBoxOperator cbHighlightSearch() {
        if (this._cbHighlightSearch == null) {
            this._cbHighlightSearch = new JCheckBoxOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-highlight-search"));
        }
        return this._cbHighlightSearch;
    }

    public JCheckBoxOperator cbIncrementalSearch() {
        if (this._cbIncrementalSearch == null) {
            this._cbIncrementalSearch = new JCheckBoxOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-inc-search"));
        }
        return this._cbIncrementalSearch;
    }

    public JCheckBoxOperator cbMatchCase() {
        if (this._cbMatchCase == null) {
            this._cbMatchCase = new JCheckBoxOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-match-case"));
        }
        return this._cbMatchCase;
    }

    public JCheckBoxOperator cbSmartCase() {
        if (this._cbSmartCase == null) {
            this._cbSmartCase = new JCheckBoxOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-smart-case"));
        }
        return this._cbSmartCase;
    }

    public JCheckBoxOperator cbMatchWholeWordsOnly() {
        if (this._cbMatchWholeWordsOnly == null) {
            this._cbMatchWholeWordsOnly = new JCheckBoxOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-whole-words"));
        }
        return this._cbMatchWholeWordsOnly;
    }

    public JCheckBoxOperator cbBackwardSearch() {
        if (this._cbBackwardSearch == null) {
            this._cbBackwardSearch = new JCheckBoxOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-backward-search"));
        }
        return this._cbBackwardSearch;
    }

    public JCheckBoxOperator cbWrapSearch() {
        if (this._cbWrapSearch == null) {
            this._cbWrapSearch = new JCheckBoxOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-wrap-search"));
        }
        return this._cbWrapSearch;
    }

    public JButtonOperator btFind() {
        if (this._btFind == null) {
            this._btFind = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-button-find"));
        }
        return this._btFind;
    }

    public JButtonOperator btClose() {
        if (this._btClose == null) {
            this._btClose = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.netbeans.editor.Bundle").getString("find-button-cancel"));
        }
        return this._btClose;
    }

    public JButtonOperator btHelp() {
        if (this._btHelp == null) {
            this._btHelp = new JButtonOperator((ContainerOperator)this, ResourceBundle.getBundle("org.openide.explorer.propertysheet.Bundle").getString("CTL_Help"));
        }
        return this._btHelp;
    }

    public String getSelectedFindWhat() {
        return this.cboFindWhat().getSelectedItem().toString();
    }

    public void selectFindWhat(String item) {
        this.cboFindWhat().selectItem(item);
    }

    public void typeFindWhat(String text) {
        this.cboFindWhat().typeText(text);
    }

    public void checkHighlightSearch(boolean state) {
        if (this.cbHighlightSearch().isSelected() != state) {
            this.cbHighlightSearch().push();
        }
    }

    public void checkIncrementalSearch(boolean state) {
        if (this.cbIncrementalSearch().isSelected() != state) {
            this.cbIncrementalSearch().push();
        }
    }

    public void checkMatchCase(boolean state) {
        if (this.cbMatchCase().isSelected() != state) {
            this.cbMatchCase().push();
        }
    }

    public void checkSmartCase(boolean state) {
        if (this.cbSmartCase().isSelected() != state) {
            this.cbSmartCase().push();
        }
    }

    public void checkMatchWholeWordsOnly(boolean state) {
        if (this.cbMatchWholeWordsOnly().isSelected() != state) {
            this.cbMatchWholeWordsOnly().push();
        }
    }

    public void checkBackwardSearch(boolean state) {
        if (this.cbBackwardSearch().isSelected() != state) {
            this.cbBackwardSearch().push();
        }
    }

    public void checkWrapSearch(boolean state) {
        if (this.cbWrapSearch().isSelected() != state) {
            this.cbWrapSearch().push();
        }
    }

    public void checkAll(boolean state) {
        this.checkMatchCase(state);
        this.checkSmartCase(state);
        this.checkMatchWholeWordsOnly(state);
        this.checkHighlightSearch(state);
        this.checkIncrementalSearch(state);
        this.checkBackwardSearch(state);
        this.checkWrapSearch(state);
    }

    public void find() {
        this.btFind().pushNoBlock();
    }

    public void close() {
        this.btClose().push();
    }

    public void help() {
        this.btHelp().push();
    }

    public void verify() {
        this.lblFindWhat();
        this.cboFindWhat();
        this.cbHighlightSearch();
        this.cbIncrementalSearch();
        this.cbMatchCase();
        this.cbSmartCase();
        this.cbMatchWholeWordsOnly();
        this.cbBackwardSearch();
        this.cbWrapSearch();
        this.btFind();
        this.btClose();
        this.btHelp();
    }

    public static void find(String text) {
        FindEditorOperator op = new FindEditorOperator();
        op.typeFindWhat(text);
        op.find();
    }

    public static void find(String text, Robot robot) {
        FindEditorOperator op = new FindEditorOperator();
        robot.waitForIdle();
        Point p = op.cboFindWhat().getLocationOnScreen();
        int x = p.x + op.cboFindWhat().getWidth() / 2;
        int y = p.y + op.cboFindWhat().getHeight() / 2;
        robot.mouseMove(x, y);
        robot.mousePress(16);
        robot.delay(50);
        robot.mouseRelease(16);
        for (int i = 0; i < text.length(); ++i) {
            boolean upper;
            char c = text.charAt(i);
            if (Character.isUpperCase(c)) {
                upper = true;
            } else {
                upper = false;
                c = Character.toUpperCase(c);
            }
            if (upper) {
                robot.keyPress(16);
            }
            robot.keyPress(c);
            robot.delay(5);
            robot.keyRelease(c);
            robot.delay(5);
            if (!upper) continue;
            robot.keyRelease(16);
        }
        p = op.btFind().getLocationOnScreen();
        x = p.x + op.btFind().getWidth() / 2;
        y = p.y + op.btFind().getHeight() / 2;
        robot.mouseMove(x, y);
        robot.mousePress(16);
        robot.delay(50);
        robot.mouseRelease(16);
        robot.delay(50);
        robot.waitForIdle();
    }

    public static void main(String[] args) {
        System.out.println("Find verification finished.");
        try {
            Robot robot = new Robot();
            System.out.println("Start delay.");
            robot.delay(2000);
            System.out.println("Delayed");
            robot.waitForIdle();
            robot.keyPress(17);
            robot.delay(1);
            robot.keyPress(70);
            robot.delay(20);
            robot.keyRelease(70);
            robot.delay(1);
            robot.keyRelease(17);
            System.out.println("1");
            robot.waitForIdle();
            System.out.println("2");
            FindEditorOperator.find("aaa", robot);
            System.out.println("3");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

