/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection.jca;

import it.imolinfo.jbi4cics.jbi.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.resource.cci.Record;
import javax.resource.cci.Streamable;

public class CommareaRecord
implements Streamable,
Record {
    private static final long serialVersionUID = -4083607545259706340L;
    private String recordName;
    private String recordShortDescription;
    private byte[] commarea;
    private static final Messages MESSAGES = Messages.getMessages(CommareaRecord.class);

    public int getCommareaLength() {
        return this.commarea.length;
    }

    public void setCommareaLength(int commareaLength) {
        this.commarea = new byte[commareaLength];
    }

    public void read(InputStream is) throws IOException {
        int byteRead = is.read(this.commarea);
        if (byteRead != this.commarea.length) {
            throw new IOException(MESSAGES.getString("CIC000301_IO_exception", byteRead, this.commarea.length));
        }
    }

    public void write(OutputStream os) throws IOException {
        os.write(this.commarea);
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String arg0) {
        this.recordName = arg0;
    }

    public void setRecordShortDescription(String arg0) {
        this.recordShortDescription = arg0;
    }

    public String getRecordShortDescription() {
        return this.recordShortDescription;
    }

    public byte[] getCommarea() {
        return this.commarea;
    }

    public void setCommarea(byte[] commarea) {
        this.commarea = commarea;
    }

    public Object clone() {
        CommareaRecord cloned = new CommareaRecord();
        cloned.setRecordName(this.recordName);
        cloned.setRecordShortDescription(this.recordShortDescription);
        byte[] buffer = new byte[this.commarea.length];
        System.arraycopy(this.commarea, 0, buffer, 0, this.commarea.length);
        cloned.setCommarea(buffer);
        return cloned;
    }
}

