/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi.wsdl;

import com.ibm.wsdl.util.xml.DOMUtils;
import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsBinding;
import java.io.PrintWriter;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;

public class Jbi4CicsBindingSerializer
implements ExtensionSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CicsBindingSerializer.class);
    private static final Messages MESSAGES = Messages.getMessages(Jbi4CicsBindingSerializer.class);

    Jbi4CicsBindingSerializer() {
    }

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter writer, Definition def, ExtensionRegistry extReg) throws WSDLException {
        String prefix = null;
        try {
            prefix = DOMUtils.getPrefix((String)"uri://schemas.imola.it/jbi/wsdl-extensions/cics/", (Definition)def);
        }
        catch (WSDLException e) {
            LOG.warn("CIC001300_Jbi4cics_namespace_not_found", new Object[]{"uri://schemas.imola.it/jbi/wsdl-extensions/cics/"}, e);
        }
        if (prefix == null) {
            prefix = "imolacics";
            def.addNamespace("imolacics", "uri://schemas.imola.it/jbi/wsdl-extensions/cics/");
        }
        prefix = prefix.concat(":");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Prefix found: " + prefix);
        }
        if (extension instanceof Jbi4CicsBinding) {
            Jbi4CicsBinding binding = (Jbi4CicsBinding)extension;
            this.doMarshall(binding, writer, prefix);
        } else {
            LOG.warn("CIC001308_Invalid_extension_element", "binding");
        }
    }

    private void doMarshall(Jbi4CicsBinding binding, PrintWriter writer, String prefix) throws WSDLException {
        Boolean sameCopyCobol = binding.getSameCopyCobol();
        writer.print("<" + prefix + "binding");
        String string = binding.getServicePackageName();
        if (string == null) {
            throw Jbi4CicsBindingSerializer.createWSDLException("CIC001310_Invalid_service_package_name");
        }
        DOMUtils.printAttribute((String)"servicePackageName", (String)string, (PrintWriter)writer);
        string = binding.getCodePage();
        if (string == null) {
            throw Jbi4CicsBindingSerializer.createWSDLException("CIC001311_Invalid_code_page");
        }
        DOMUtils.printAttribute((String)"codePage", (String)string, (PrintWriter)writer);
        if (sameCopyCobol != null) {
            DOMUtils.printAttribute((String)"sameCopyCobol", (String)sameCopyCobol.toString(), (PrintWriter)writer);
        }
        writer.print(">\n");
        string = binding.getCopyCobol();
        if (string == null) {
            throw Jbi4CicsBindingSerializer.createWSDLException("CIC001312_Invalid_copy_cobol");
        }
        writer.print("<" + prefix + "copyCobol" + ">" + DOMUtils.cleanString((String)string) + "</" + prefix + "copyCobol" + ">\n");
        string = binding.getOutputCopyCobol();
        if (string == null || string.trim().length() == 0) {
            if (Boolean.FALSE.equals(sameCopyCobol)) {
                throw Jbi4CicsBindingSerializer.createWSDLException("CIC001313_Invalid_copy_cobol");
            }
        } else {
            writer.print("<" + prefix + "outputCopyCobol" + ">" + DOMUtils.cleanString((String)string) + "</" + prefix + "outputCopyCobol" + ">\n");
        }
        writer.print("</" + prefix + "binding" + ">\n");
    }

    private static WSDLException createWSDLException(String msgKey) {
        LOG.error(msgKey);
        return new WSDLException("INVALID_WSDL", MESSAGES.getString(msgKey, new Object[0]));
    }
}

