/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.wireio;

import java.net.Socket;
import org.netbeans.lib.profiler.tests.jfluid.wireio.CommonWireIOTestCase;
import org.netbeans.lib.profiler.wireprotocol.AsyncMessageCommand;
import org.netbeans.lib.profiler.wireprotocol.CalibrationDataResponse;
import org.netbeans.lib.profiler.wireprotocol.ClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.DefiningLoaderResponse;
import org.netbeans.lib.profiler.wireprotocol.DumpResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;
import org.netbeans.lib.profiler.wireprotocol.GetDefiningClassLoaderCommand;
import org.netbeans.lib.profiler.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.netbeans.lib.profiler.wireprotocol.InitiateInstrumentationCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodInvokedFirstTimeCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.SetChangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;
import org.netbeans.lib.profiler.wireprotocol.WireIO;

public class BasicTest
extends CommonWireIOTestCase {
    public BasicTest(String name) {
        super(name);
    }

    public void testComplexCommands() {
        CommonWireIOTestCase.LoggingThread t = new CommonWireIOTestCase.LoggingThread(this);
        t.start();
        try {
            while (!t.isPrepared()) {
                Thread.sleep(1000L);
            }
            Socket clientSocket = new Socket("localhost", PORT);
            WireIO wireIO = this.createWireIOClient(clientSocket);
            AsyncMessageCommand cmd = new AsyncMessageCommand(true, "async message text");
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new ClassLoadedCommand("java.lang.String", new int[3], new byte[0], true);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new RootClassLoadedCommand(new String[]{"java.lang.String"}, new int[1], new byte[1][0], 1, new int[1], "file name");
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new SetUnchangeableInstrParamsCommand(true, false, 0, 1024);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new MethodInvokedFirstTimeCommand(0);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new GetMethodNamesForJMethodIdsCommand(new int[]{1});
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new MethodLoadedCommand("java.lang.String", 7, "toString()", "");
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new EventBufferDumpedCommand(1024);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new SetChangeableInstrParamsCommand(32, 10, 5, 10, true, true, true);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new InitiateInstrumentationCommand(0, "java.lang.String", false);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new InstrumentMethodGroupCommand(0, new String[]{"java.lang.String"}, new int[1], new byte[1][0], new boolean[1], 0);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            cmd = new GetDefiningClassLoaderCommand("java.lang.String", 1);
            this.log("sending command " + cmd);
            wireIO.sendComplexCommand((Command)cmd);
            clientSocket.close();
            this.log("wait for thread");
            for (long tm = 0L; tm < 20000L && t.isRunning(); tm += 1000L) {
                Thread.sleep(1000L);
            }
            t.setRunning(false);
            this.log("finished.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BasicTest.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    public void testComplexResponse() {
        CommonWireIOTestCase.LoggingThread t = new CommonWireIOTestCase.LoggingThread(this);
        t.start();
        try {
            while (!t.isPrepared()) {
                Thread.sleep(1000L);
            }
            Socket clientSocket = new Socket("localhost", PORT);
            WireIO wireIO = this.createWireIOClient(clientSocket);
            CodeRegionCPUResultsResponse resp = new CodeRegionCPUResultsResponse(new long[]{10L, 20L, 30L});
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new ThreadLivenessStatusResponse("status".getBytes());
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new DumpResultsResponse(true, 200508181215L);
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new InstrumentMethodGroupResponse(new String[]{"java.lang.String"}, new int[1], new byte[1][0], new boolean[1], 0);
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new MethodNamesResponse(new byte[0], new int[0]);
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new DefiningLoaderResponse(1);
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new CalibrationDataResponse(new double[]{12.4}, new double[]{10.4}, new double[]{13.54}, new long[]{3L, 10L});
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new InternalStatsResponse();
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new ObjectAllocationResultsResponse(new int[]{20}, 1);
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            resp = new MonitoredNumbersResponse(new long[]{20L});
            this.log("send response " + resp);
            wireIO.sendComplexResponse((Response)resp);
            clientSocket.close();
            this.log("wait for thread");
            for (long tm = 0L; tm < 20000L && t.isRunning(); tm += 1000L) {
                Thread.sleep(1000L);
            }
            t.setRunning(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BasicTest.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    public void testSimpleCommands() {
        CommonWireIOTestCase.LoggingThread t = new CommonWireIOTestCase.LoggingThread(this);
        t.start();
        try {
            while (!t.isPrepared()) {
                Thread.sleep(1000L);
            }
            Socket clientSocket = new Socket("localhost", PORT);
            WireIO wireIO = this.createWireIOClient(clientSocket);
            for (int cmd = 1; cmd < 40; ++cmd) {
                wireIO.sendSimpleCommand(cmd);
                this.log("send command " + cmd);
            }
            clientSocket.close();
            this.log("wait for thread");
            for (long tm = 0L; tm < 20000L && t.isRunning(); tm += 1000L) {
                Thread.sleep(1000L);
            }
            t.setRunning(false);
            this.log("finished.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BasicTest.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    public void testSimpleResponse() {
        CommonWireIOTestCase.LoggingThread t = new CommonWireIOTestCase.LoggingThread(this);
        t.start();
        try {
            while (!t.isPrepared()) {
                Thread.sleep(1000L);
            }
            Socket clientSocket = new Socket("localhost", PORT);
            WireIO wireIO = this.createWireIOClient(clientSocket);
            wireIO.sendSimpleResponse(true, "Error message.");
            this.log("response send");
            clientSocket.close();
            this.log("wait for thread");
            for (long tm = 0L; tm < 20000L && t.isRunning(); tm += 1000L) {
                Thread.sleep(1000L);
            }
            t.setRunning(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BasicTest.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    public void testUnknownSimpleCommand() {
        CommonWireIOTestCase.LoggingThread t = new CommonWireIOTestCase.LoggingThread(this);
        t.start();
        try {
            while (!t.isPrepared()) {
                Thread.sleep(1000L);
            }
            Socket clientSocket = new Socket("localhost", PORT);
            WireIO wireIO = this.createWireIOClient(clientSocket);
            int cmd = 0;
            wireIO.sendSimpleCommand(cmd);
            this.log("send command " + cmd);
            clientSocket.close();
            this.log("wait for thread");
            for (long tm = 0L; tm < 20000L && t.isRunning(); tm += 1000L) {
                Thread.sleep(1000L);
            }
            t.setRunning(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BasicTest.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }
}

