/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class ZoomToFitControl
extends ControlAdapter {
    private long m_duration = 2000L;
    private int m_margin = 50;
    private int m_button = 4;
    private boolean m_zoomOverItem = true;
    private String m_group = Visualization.ALL_ITEMS;

    public ZoomToFitControl() {
    }

    public ZoomToFitControl(String group) {
        this.m_group = group;
    }

    public ZoomToFitControl(int button) {
        this.m_button = button;
    }

    public ZoomToFitControl(String group, int button) {
        this.m_group = group;
        this.m_button = button;
    }

    public ZoomToFitControl(String group, int margin, long duration, int button) {
        this.m_group = group;
        this.m_margin = margin;
        this.m_duration = duration;
        this.m_button = button;
    }

    public void itemClicked(VisualItem item, MouseEvent e) {
        if (this.m_zoomOverItem) {
            this.mouseClicked(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.m_button)) {
            Display display = (Display)e.getComponent();
            Visualization vis = display.getVisualization();
            Rectangle2D bounds = vis.getBounds(this.m_group);
            GraphicsLib.expand(bounds, (double)this.m_margin / display.getScale());
            DisplayLib.fitViewToBounds(display, bounds, this.m_duration);
        }
    }

    public boolean isZoomOverItem() {
        return this.m_zoomOverItem;
    }

    public void setZoomOverItem(boolean zoomOverItem) {
        this.m_zoomOverItem = zoomOverItem;
    }
}

