/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.BitSet;
import java.util.Comparator;
import java.util.NoSuchElementException;
import prefuse.util.collections.BooleanIntSortedMap;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.LiteralIterator;

public class BooleanIntBitSetMap
implements BooleanIntSortedMap {
    private BitSet m_true = new BitSet();
    private BitSet m_false = new BitSet();

    public boolean firstKey() {
        return false;
    }

    public boolean lastKey() {
        return true;
    }

    public boolean containsKey(boolean key) {
        BitSet set = key ? this.m_true : this.m_false;
        return set.cardinality() > 0;
    }

    public IntIterator valueRangeIterator(boolean fromKey, boolean fromInc, boolean toKey, boolean toInc) {
        if (!fromInc && !toInc) {
            return new BitSetIterator(null);
        }
        if (fromKey == toKey || !toInc) {
            return new BitSetIterator(fromKey ? this.m_true : this.m_false);
        }
        if (!fromInc) {
            return new BitSetIterator(toKey ? this.m_true : this.m_false);
        }
        return new BitSetIterator(fromKey ? this.m_true : this.m_false, toKey ? this.m_true : this.m_false);
    }

    public LiteralIterator keyIterator() {
        return new BitSetIterator(this.m_false, this.m_true);
    }

    public LiteralIterator keyRangeIterator(boolean fromKey, boolean fromInc, boolean toKey, boolean toInc) {
        if (!fromInc && !toInc) {
            return new BitSetIterator(null);
        }
        if (fromKey == toKey || !toInc) {
            return new BitSetIterator(fromKey ? this.m_true : this.m_false);
        }
        if (!fromInc) {
            return new BitSetIterator(toKey ? this.m_true : this.m_false);
        }
        return new BitSetIterator(fromKey ? this.m_true : this.m_false, toKey ? this.m_true : this.m_false);
    }

    public int get(boolean key) {
        BitSet set = key ? this.m_true : this.m_false;
        return set.nextSetBit(0);
    }

    public int remove(boolean key) {
        BitSet set = key ? this.m_true : this.m_false;
        int idx = set.length() - 1;
        set.clear(idx);
        return idx;
    }

    public int remove(boolean key, int value) {
        BitSet set;
        BitSet bitSet = set = key ? this.m_true : this.m_false;
        if (set.get(value)) {
            set.clear(value);
            return value;
        }
        return Integer.MIN_VALUE;
    }

    public int put(boolean key, int value) {
        BitSet set = key ? this.m_true : this.m_false;
        boolean ret = set.get(value);
        set.set(value);
        return ret ? value : Integer.MIN_VALUE;
    }

    public int getMinimum() {
        if (this.m_false.cardinality() > 0) {
            return this.m_false.nextSetBit(0);
        }
        if (this.m_true.cardinality() > 0) {
            return this.m_true.nextSetBit(0);
        }
        return Integer.MIN_VALUE;
    }

    public int getMaximum() {
        int idx = this.m_true.length() - 1;
        return idx > 0 ? idx : this.m_false.length() - 1;
    }

    public int getMedian() {
        int fsize = this.m_false.cardinality();
        int tsize = this.m_true.cardinality();
        if (fsize == 0 && tsize == 0) {
            return Integer.MIN_VALUE;
        }
        int med = (fsize + tsize) / 2;
        BitSet set = fsize > tsize ? this.m_false : this.m_true;
        int i = set.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            if (j == med) {
                return i;
            }
            i = set.nextSetBit(i + 1);
            ++j;
        }
        return Integer.MIN_VALUE;
    }

    public int getUniqueCount() {
        int count = 0;
        if (this.m_false.cardinality() > 0) {
            ++count;
        }
        if (this.m_true.cardinality() > 0) {
            ++count;
        }
        return count;
    }

    public boolean isAllowDuplicates() {
        return true;
    }

    public int size() {
        return this.m_true.cardinality() + this.m_false.cardinality();
    }

    public boolean isEmpty() {
        return this.m_true.isEmpty() && this.m_false.isEmpty();
    }

    public Comparator comparator() {
        return DefaultLiteralComparator.getInstance();
    }

    public void clear() {
        this.m_true.clear();
        this.m_false.clear();
    }

    public boolean containsValue(int value) {
        return this.m_false.get(value) || this.m_true.get(value);
    }

    public IntIterator valueIterator(boolean ascending) {
        if (!ascending) {
            return new BitSetIterator(this.m_true, this.m_false);
        }
        return new BitSetIterator(this.m_false, this.m_true);
    }

    public class BitSetIterator
    extends IntIterator {
        private BitSet m_cur;
        private BitSet m_next;
        private int m_val = -1;

        public BitSetIterator(BitSet set) {
            this(set, null);
        }

        public BitSetIterator(BitSet first, BitSet second) {
            this.m_cur = first;
            this.m_next = second;
            if (first == null) {
                this.m_val = -2;
            } else {
                this.m_val = -1;
                this.advance();
            }
        }

        private void advance() {
            int idx = this.m_cur.nextSetBit(this.m_val + 1);
            if (idx < 0) {
                if (this.m_next != null) {
                    this.m_cur = this.m_next;
                    this.m_next = null;
                    this.m_val = -1;
                    this.advance();
                } else {
                    this.m_val = -2;
                }
                return;
            }
            this.m_val = idx;
        }

        public int nextInt() {
            if (this.m_val < 0) {
                throw new NoSuchElementException();
            }
            int retval = this.m_val;
            this.advance();
            return retval;
        }

        public boolean nextBoolean() {
            if (this.m_cur == BooleanIntBitSetMap.this.m_true) {
                this.advance();
                return true;
            }
            if (this.m_cur == BooleanIntBitSetMap.this.m_false) {
                this.advance();
                return false;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.m_val >= 0;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

