/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class HttpService
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String ACCESS_LOG = "AccessLog";
    public static final String HTTP_LISTENER = "HttpListener";
    public static final String VIRTUAL_SERVER = "VirtualServer";
    public static final String REQUEST_PROCESSING = "RequestProcessing";
    public static final String KEEP_ALIVE = "KeepAlive";
    public static final String CONNECTION_POOL = "ConnectionPool";
    public static final String HTTP_PROTOCOL = "HttpProtocol";
    public static final String HTTP_FILE_CACHE = "HttpFileCache";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public HttpService() {
        this(1);
    }

    public HttpService(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(9);
        this.createProperty("access-log", ACCESS_LOG, 66064, AccessLog.class);
        this.createAttribute(ACCESS_LOG, "format", "Format", 1, null, "%client.name% %auth-user-name% %datetime% %request% %status% %response.length%");
        this.createAttribute(ACCESS_LOG, "rotation-policy", "RotationPolicy", 1, null, "time");
        this.createAttribute(ACCESS_LOG, "rotation-interval-in-minutes", "RotationIntervalInMinutes", 1, null, "1440");
        this.createAttribute(ACCESS_LOG, "rotation-suffix", "RotationSuffix", 1, null, "yyyyMMdd-HH'h'mm'm'ss's'");
        this.createAttribute(ACCESS_LOG, "rotation-enabled", "RotationEnabled", 1, null, "true");
        this.createProperty("http-listener", HTTP_LISTENER, 66112, HttpListener.class);
        this.createAttribute(HTTP_LISTENER, "id", "Id", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "address", "Address", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "port", "Port", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "external-port", "ExternalPort", 513, null, null);
        this.createAttribute(HTTP_LISTENER, "family", "Family", 1, null, "inet");
        this.createAttribute(HTTP_LISTENER, "blocking-enabled", "BlockingEnabled", 1, null, "false");
        this.createAttribute(HTTP_LISTENER, "acceptor-threads", "AcceptorThreads", 1, null, "1");
        this.createAttribute(HTTP_LISTENER, "security-enabled", "SecurityEnabled", 1, null, "false");
        this.createAttribute(HTTP_LISTENER, "default-virtual-server", "DefaultVirtualServer", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "server-name", "ServerName", 257, null, null);
        this.createAttribute(HTTP_LISTENER, "redirect-port", "RedirectPort", 513, null, null);
        this.createAttribute(HTTP_LISTENER, "xpowered-by", "XpoweredBy", 1, null, "true");
        this.createAttribute(HTTP_LISTENER, "enabled", "Enabled", 1, null, "true");
        this.createProperty("virtual-server", VIRTUAL_SERVER, 66112, VirtualServer.class);
        this.createAttribute(VIRTUAL_SERVER, "id", "Id", 257, null, null);
        this.createAttribute(VIRTUAL_SERVER, "http-listeners", "HttpListeners", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "default-web-module", "DefaultWebModule", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "hosts", "Hosts", 257, null, null);
        this.createAttribute(VIRTUAL_SERVER, "state", "State", 1, null, "on");
        this.createAttribute(VIRTUAL_SERVER, "docroot", "Docroot", 513, null, null);
        this.createAttribute(VIRTUAL_SERVER, "log-file", "LogFile", 1, null, "${com.sun.aas.instanceRoot}/logs/server.log");
        this.createProperty("request-processing", REQUEST_PROCESSING, 66064, RequestProcessing.class);
        this.createAttribute(REQUEST_PROCESSING, "thread-count", "ThreadCount", 1, null, "128");
        this.createAttribute(REQUEST_PROCESSING, "initial-thread-count", "InitialThreadCount", 1, null, "48");
        this.createAttribute(REQUEST_PROCESSING, "thread-increment", "ThreadIncrement", 1, null, "10");
        this.createAttribute(REQUEST_PROCESSING, "request-timeout-in-seconds", "RequestTimeoutInSeconds", 1, null, "30");
        this.createAttribute(REQUEST_PROCESSING, "header-buffer-length-in-bytes", "HeaderBufferLengthInBytes", 1, null, "4096");
        this.createProperty("keep-alive", KEEP_ALIVE, 66064, KeepAlive.class);
        this.createAttribute(KEEP_ALIVE, "thread-count", "ThreadCount", 1, null, "1");
        this.createAttribute(KEEP_ALIVE, "max-connections", "MaxConnections", 1, null, "256");
        this.createAttribute(KEEP_ALIVE, "timeout-in-seconds", "TimeoutInSeconds", 1, null, "30");
        this.createProperty("connection-pool", CONNECTION_POOL, 66064, ConnectionPool.class);
        this.createAttribute(CONNECTION_POOL, "queue-size-in-bytes", "QueueSizeInBytes", 1, null, "4096");
        this.createAttribute(CONNECTION_POOL, "max-pending-count", "MaxPendingCount", 1, null, "4096");
        this.createAttribute(CONNECTION_POOL, "receive-buffer-size-in-bytes", "ReceiveBufferSizeInBytes", 1, null, "4096");
        this.createAttribute(CONNECTION_POOL, "send-buffer-size-in-bytes", "SendBufferSizeInBytes", 1, null, "8192");
        this.createProperty("http-protocol", HTTP_PROTOCOL, 66064, HttpProtocol.class);
        this.createAttribute(HTTP_PROTOCOL, "version", "Version", 1, null, "HTTP/1.1");
        this.createAttribute(HTTP_PROTOCOL, "dns-lookup-enabled", "DnsLookupEnabled", 1, null, "false");
        this.createAttribute(HTTP_PROTOCOL, "forced-type", "ForcedType", 1, null, "text/html; charset=iso-8859-1");
        this.createAttribute(HTTP_PROTOCOL, "default-type", "DefaultType", 1, null, "text/html; charset=iso-8859-1");
        this.createAttribute(HTTP_PROTOCOL, "forced-response-type", "ForcedResponseType", 1, null, "AttributeDeprecated");
        this.createAttribute(HTTP_PROTOCOL, "default-response-type", "DefaultResponseType", 1, null, "AttributeDeprecated");
        this.createAttribute(HTTP_PROTOCOL, "ssl-enabled", "SslEnabled", 1, null, "true");
        this.createProperty("http-file-cache", HTTP_FILE_CACHE, 66064, HttpFileCache.class);
        this.createAttribute(HTTP_FILE_CACHE, "globally-enabled", "GloballyEnabled", 1, null, "true");
        this.createAttribute(HTTP_FILE_CACHE, "file-caching-enabled", "FileCachingEnabled", 1, null, "on");
        this.createAttribute(HTTP_FILE_CACHE, "max-age-in-seconds", "MaxAgeInSeconds", 1, null, "30");
        this.createAttribute(HTTP_FILE_CACHE, "medium-file-size-limit-in-bytes", "MediumFileSizeLimitInBytes", 1, null, "537600");
        this.createAttribute(HTTP_FILE_CACHE, "medium-file-space-in-bytes", "MediumFileSpaceInBytes", 1, null, "10485760");
        this.createAttribute(HTTP_FILE_CACHE, "small-file-size-limit-in-bytes", "SmallFileSizeLimitInBytes", 1, null, "2048");
        this.createAttribute(HTTP_FILE_CACHE, "small-file-space-in-bytes", "SmallFileSpaceInBytes", 1, null, "1048576");
        this.createAttribute(HTTP_FILE_CACHE, "file-transmission-enabled", "FileTransmissionEnabled", 1, null, "false");
        this.createAttribute(HTTP_FILE_CACHE, "max-files-count", "MaxFilesCount", 1, null, "1024");
        this.createAttribute(HTTP_FILE_CACHE, "hash-init-size", "HashInitSize", 1, null, "0");
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setAccessLog(AccessLog value) {
        this.setValue(ACCESS_LOG, value);
    }

    public AccessLog getAccessLog() {
        return (AccessLog)this.getValue(ACCESS_LOG);
    }

    public HttpListener getHttpListener(int index) {
        return (HttpListener)this.getValue(HTTP_LISTENER, index);
    }

    public void setHttpListener(HttpListener[] value) {
        this.setValue(HTTP_LISTENER, value);
    }

    public HttpListener[] getHttpListener() {
        return (HttpListener[])this.getValues(HTTP_LISTENER);
    }

    public int sizeHttpListener() {
        return this.size(HTTP_LISTENER);
    }

    public int addHttpListener(HttpListener value) throws ConfigException {
        return this.addHttpListener(value, true);
    }

    public int addHttpListener(HttpListener value, boolean overwrite) throws ConfigException {
        HttpListener old = this.getHttpListenerById(value.getId());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(HttpService.class).getString("cannotAddDuplicate", (Object)HTTP_LISTENER));
        }
        return this.addValue(HTTP_LISTENER, value, overwrite);
    }

    public int removeHttpListener(HttpListener value) {
        return this.removeValue(HTTP_LISTENER, value);
    }

    public int removeHttpListener(HttpListener value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(HTTP_LISTENER, value, overwrite);
    }

    public HttpListener getHttpListenerById(String id) {
        HttpListener[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getHttpListener()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"id")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public VirtualServer getVirtualServer(int index) {
        return (VirtualServer)this.getValue(VIRTUAL_SERVER, index);
    }

    public void setVirtualServer(VirtualServer[] value) {
        this.setValue(VIRTUAL_SERVER, value);
    }

    public VirtualServer[] getVirtualServer() {
        return (VirtualServer[])this.getValues(VIRTUAL_SERVER);
    }

    public int sizeVirtualServer() {
        return this.size(VIRTUAL_SERVER);
    }

    public int addVirtualServer(VirtualServer value) throws ConfigException {
        return this.addVirtualServer(value, true);
    }

    public int addVirtualServer(VirtualServer value, boolean overwrite) throws ConfigException {
        VirtualServer old = this.getVirtualServerById(value.getId());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(HttpService.class).getString("cannotAddDuplicate", (Object)VIRTUAL_SERVER));
        }
        return this.addValue(VIRTUAL_SERVER, value, overwrite);
    }

    public int removeVirtualServer(VirtualServer value) {
        return this.removeValue(VIRTUAL_SERVER, value);
    }

    public int removeVirtualServer(VirtualServer value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(VIRTUAL_SERVER, value, overwrite);
    }

    public VirtualServer getVirtualServerById(String id) {
        VirtualServer[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getVirtualServer()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"id")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setRequestProcessing(RequestProcessing value) {
        this.setValue(REQUEST_PROCESSING, value);
    }

    public RequestProcessing getRequestProcessing() {
        return (RequestProcessing)this.getValue(REQUEST_PROCESSING);
    }

    public void setKeepAlive(KeepAlive value) {
        this.setValue(KEEP_ALIVE, value);
    }

    public KeepAlive getKeepAlive() {
        return (KeepAlive)this.getValue(KEEP_ALIVE);
    }

    public void setConnectionPool(ConnectionPool value) {
        this.setValue(CONNECTION_POOL, value);
    }

    public ConnectionPool getConnectionPool() {
        return (ConnectionPool)this.getValue(CONNECTION_POOL);
    }

    public void setHttpProtocol(HttpProtocol value) {
        this.setValue(HTTP_PROTOCOL, value);
    }

    public HttpProtocol getHttpProtocol() {
        return (HttpProtocol)this.getValue(HTTP_PROTOCOL);
    }

    public void setHttpFileCache(HttpFileCache value) {
        this.setValue(HTTP_FILE_CACHE, value);
    }

    public HttpFileCache getHttpFileCache() {
        return (HttpFileCache)this.getValue(HTTP_FILE_CACHE);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(HttpService.class).getString("cannotAddDuplicate", (Object)ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public AccessLog newAccessLog() {
        return new AccessLog();
    }

    public HttpListener newHttpListener() {
        return new HttpListener();
    }

    public VirtualServer newVirtualServer() {
        return new VirtualServer();
    }

    public RequestProcessing newRequestProcessing() {
        return new RequestProcessing();
    }

    public KeepAlive newKeepAlive() {
        return new KeepAlive();
    }

    public ConnectionPool newConnectionPool() {
        return new ConnectionPool();
    }

    public HttpProtocol newHttpProtocol() {
        return new HttpProtocol();
    }

    public HttpFileCache newHttpFileCache() {
        return new HttpFileCache();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "http-service";
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        attr = attr.trim();
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        int i;
        str.append(indent);
        str.append(ACCESS_LOG);
        Object n = this.getAccessLog();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(ACCESS_LOG, 0, str, indent);
        str.append(indent);
        str.append("HttpListener[" + this.sizeHttpListener() + "]");
        for (i = 0; i < this.sizeHttpListener(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getHttpListener(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(HTTP_LISTENER, i, str, indent);
        }
        str.append(indent);
        str.append("VirtualServer[" + this.sizeVirtualServer() + "]");
        for (i = 0; i < this.sizeVirtualServer(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getVirtualServer(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(VIRTUAL_SERVER, i, str, indent);
        }
        str.append(indent);
        str.append(REQUEST_PROCESSING);
        n = this.getRequestProcessing();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(REQUEST_PROCESSING, 0, str, indent);
        str.append(indent);
        str.append(KEEP_ALIVE);
        n = this.getKeepAlive();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(KEEP_ALIVE, 0, str, indent);
        str.append(indent);
        str.append(CONNECTION_POOL);
        n = this.getConnectionPool();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(CONNECTION_POOL, 0, str, indent);
        str.append(indent);
        str.append(HTTP_PROTOCOL);
        n = this.getHttpProtocol();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(HTTP_PROTOCOL, 0, str, indent);
        str.append(indent);
        str.append(HTTP_FILE_CACHE);
        n = this.getHttpFileCache();
        if (n != null) {
            n.dump(str, indent + "\t");
        } else {
            str.append(indent + "\tnull");
        }
        this.dumpAttributes(HTTP_FILE_CACHE, 0, str, indent);
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("HttpService\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

