/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;

public class CocoPicture {
    private static final ErrorManager cErrorMgr = ErrorManager.getManager("STC.eWay.converter.COBOLCopybook." + CocoPicture.class.getName());
    private String mOriginalPicture;
    private String mPicture;
    private int mDecimalPos;
    private int mDecimalScalePos;
    private int mDataCategory;

    public CocoPicture(String picStr) throws IllegalArgumentException {
        if (picStr == null || picStr.length() == 0) {
            Message msg = MessageCatalog.getMessage("CCCB4123");
            String text = msg.toString();
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.mOriginalPicture = picStr;
        picStr = CocoPicture.normalizePicString(picStr);
        CocoPicture.validatePicString(picStr);
        this.mPicture = picStr.toUpperCase();
        this.computeCategory();
        this.computeDecimalPosition();
    }

    public String getPicture() {
        return this.mPicture;
    }

    public String getOriginalPicture() {
        return this.mOriginalPicture;
    }

    public int getDecimalPosition() {
        return this.mDecimalPos;
    }

    public int getDecimalScalingPositions() {
        return this.mDecimalScalePos;
    }

    public int getCategory() {
        return this.mDataCategory;
    }

    public int countDigits() {
        int digitCount = 0;
        for (int i = 0; i < this.mPicture.length(); ++i) {
            char ch = this.mPicture.charAt(i);
            if ("Z90".indexOf(ch) == -1) continue;
            ++digitCount;
        }
        return digitCount;
    }

    public boolean hasSign() {
        return this.mPicture.indexOf(83) != -1;
    }

    public boolean hasDecimalPoint() {
        for (int i = 0; i < this.mPicture.length(); ++i) {
            char ch = this.mPicture.charAt(i);
            if ("PV.".indexOf(ch) == -1) continue;
            return true;
        }
        return false;
    }

    private static void validatePicString(String str) throws IllegalArgumentException {
        int idxV2;
        boolean foundCR = (str = str.toUpperCase()).indexOf("CR") != -1;
        boolean foundDB = str.indexOf("DB") != -1;
        boolean foundPlus = str.indexOf("+") != -1;
        boolean foundMinus = str.indexOf("-") != -1;
        int cntFound = foundCR || foundDB ? 1 : 0;
        if ((cntFound += foundPlus || foundMinus ? 1 : 0) > 1) {
            Message msg = MessageCatalog.getMessage("CCCB4124");
            String text = msg.formatText(new Object[]{str});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        int idxV1 = str.indexOf("V");
        if (idxV1 != (idxV2 = str.lastIndexOf("V"))) {
            Message msg = MessageCatalog.getMessage("CCCB4125");
            String text = msg.formatText(new Object[]{str});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        int idxS = str.indexOf("S");
        if (idxS != -1 && idxS != 0) {
            Message msg = MessageCatalog.getMessage("CCCB4126");
            String text = msg.formatText(new Object[]{str});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        int idxP = str.indexOf("P");
        if (idxP != -1) {
            boolean foundStop = false;
            for (int i = idxP + 1; i < str.length(); ++i) {
                if (str.charAt(i) != 'P') {
                    foundStop = true;
                    continue;
                }
                if (!foundStop) continue;
                Message msg = MessageCatalog.getMessage("CCCB4127");
                String text = msg.formatText(new Object[]{str});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            idxP = str.lastIndexOf("P");
            int idxS2 = str.indexOf("S");
            if (idxS2 != -1 && idxP < idxS2) {
                Message msg = MessageCatalog.getMessage("CCCB4128");
                String text = msg.formatText(new Object[]{str});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            if (str.indexOf("P") != 0 && idxP < str.length() - 1) {
                Message msg = MessageCatalog.getMessage("CCCB4129");
                String text = msg.formatText(new Object[]{str});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
        }
        String msg = null;
        int pos = str.indexOf("CR");
        if (pos != -1 && pos != str.lastIndexOf("CR")) {
            Message err = MessageCatalog.getMessage("CCCB4130");
            msg = err.formatText(new Object[]{str});
        }
        if ((pos = str.indexOf("DB")) != -1 && pos != str.lastIndexOf("DB")) {
            Message err = MessageCatalog.getMessage("CCCB4131");
            msg = err.formatText(new Object[]{str});
        }
        if ((pos = str.indexOf("S")) != -1 && pos != str.lastIndexOf("S")) {
            Message err = MessageCatalog.getMessage("CCCB4132");
            msg = err.formatText(new Object[]{str});
        }
        if ((pos = str.indexOf("V")) != -1 && pos != str.lastIndexOf("V")) {
            Message err = MessageCatalog.getMessage("CCCB4124");
            msg = err.formatText(new Object[]{str});
        }
        if ((pos = str.indexOf("E")) != -1 && pos != str.lastIndexOf("E")) {
            Message err = MessageCatalog.getMessage("CCCB4133");
            msg = err.formatText(new Object[]{str});
        }
        if ((pos = str.indexOf(".")) != -1 && pos != str.lastIndexOf(".")) {
            Message err = MessageCatalog.getMessage("CCCB4134");
            msg = err.formatText(new Object[]{str});
        }
        if (msg != null) {
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, msg);
            throw new IllegalArgumentException(msg);
        }
        int pos2 = str.indexOf(69);
        if (pos2 != -1) {
            String exfloat = str.trim();
            pos2 = exfloat.indexOf(69);
            if (pos2 != exfloat.length() - 4) {
                Message msg2 = MessageCatalog.getMessage("CCCB4135");
                String text = msg2.formatText(new Object[]{str});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            boolean ok = true;
            int vCount = 0;
            int dotCount = 0;
            ok |= "+-".indexOf(exfloat.charAt(0)) != -1;
            ok |= "+-".indexOf(exfloat.charAt(pos2 + 1)) != -1;
            ok |= exfloat.charAt(pos2 + 2) == '9' && exfloat.charAt(pos2 + 3) == '9';
            for (int i = 1; i < pos2; ++i) {
                ok |= "9.V".indexOf(exfloat.charAt(i)) != -1;
                if (exfloat.charAt(i) == '.') {
                    ++dotCount;
                    continue;
                }
                if (exfloat.charAt(i) != 'V') continue;
                ++vCount;
            }
            if (!(ok |= dotCount + vCount < 2)) {
                Message msg3 = MessageCatalog.getMessage("CCCB4135");
                String text = msg3.formatText(new Object[]{str});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
        }
    }

    private static String normalizePicString(String pic) throws IllegalArgumentException {
        pic = CocoPicture.expandOccurence(pic);
        return pic;
    }

    private static String expandOccurence(String pic) throws IllegalArgumentException {
        int len = pic.length();
        int prevCh = -1;
        StringBuffer buffer = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = pic.charAt(i);
            if (ch == '(') {
                if (prevCh == -1) {
                    Message msg = MessageCatalog.getMessage("CCCB4136");
                    String text = msg.formatText(new Object[]{String.valueOf(ch), pic});
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                int rparenPos = pic.indexOf(41, i);
                if (rparenPos == -1) {
                    Message msg = MessageCatalog.getMessage("CCCB4137");
                    String text = msg.formatText(new Object[]{pic});
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                try {
                    int times = Integer.parseInt(pic.substring(i + 1, rparenPos));
                    --times;
                    i = rparenPos;
                    for (int j = 0; j < times; ++j) {
                        buffer.append((char)prevCh);
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(nfe.getLocalizedMessage());
                }
            }
            if (ch == ')') {
                Message msg = MessageCatalog.getMessage("CCCB4138");
                String text = msg.formatText(new Object[]{pic});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            prevCh = ch;
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private void computeDecimalPosition() {
        this.mDecimalPos = 0;
        this.mDecimalScalePos = 0;
        block0 : switch (this.mDataCategory) {
            case 7: {
                int ePos = this.mPicture.indexOf("E");
                int digitCnt = 0;
                for (int i = ePos - 1; i >= 0; --i) {
                    char ch = this.mPicture.charAt(i);
                    if (ch == '9') {
                        ++digitCnt;
                        continue;
                    }
                    if ("V.".indexOf(ch) == -1) continue;
                    this.mDecimalPos = digitCnt;
                    break block0;
                }
                break;
            }
            case 2: {
                boolean leftP;
                boolean haveV = this.mPicture.indexOf(86) != -1;
                boolean haveP = this.mPicture.indexOf(80) != -1;
                boolean bl = leftP = this.mPicture.lastIndexOf(80) != this.mPicture.length() - 1;
                if (haveV) {
                    int digitCnt = 0;
                    for (int i = this.mPicture.length() - 1; i >= 0; --i) {
                        char ch = this.mPicture.charAt(i);
                        if (ch == '9') {
                            ++digitCnt;
                            continue;
                        }
                        if (ch != 'V') continue;
                        this.mDecimalPos = digitCnt;
                        break block0;
                    }
                    break;
                }
                if (haveP) {
                    this.mDecimalScalePos = this.mPicture.lastIndexOf(80) - this.mPicture.indexOf(80) + 1;
                    this.mDecimalPos = !leftP ? 0 : this.mPicture.length() - (this.hasSign() ? 1 : 0);
                    break;
                }
                this.mDecimalPos = 0;
                break;
            }
            case 3: {
                boolean leftP;
                boolean haveDot = this.mPicture.indexOf(46) != -1;
                boolean haveV = this.mPicture.indexOf(86) != -1;
                boolean haveP = this.mPicture.indexOf(80) != -1;
                boolean bl = leftP = this.mPicture.lastIndexOf(80) != this.mPicture.length() - 1;
                if (haveV || haveDot) {
                    int digitCnt = 0;
                    for (int i = this.mPicture.length() - 1; i >= 0; --i) {
                        char ch = this.mPicture.charAt(i);
                        if ("90Z".indexOf(ch) != -1) {
                            ++digitCnt;
                            continue;
                        }
                        if (".V".indexOf(ch) == -1) continue;
                        this.mDecimalPos = digitCnt;
                        break block0;
                    }
                    break;
                }
                if (haveP) {
                    this.mDecimalScalePos = this.mPicture.lastIndexOf(80) - this.mPicture.indexOf(80) + 1;
                    this.mDecimalPos = !leftP ? 0 : this.mPicture.length() - (this.hasSign() ? 1 : 0);
                    break;
                }
                this.mDecimalPos = 0;
                break;
            }
            default: {
                this.mDecimalPos = 0;
            }
        }
    }

    private void computeCategory() {
        this.mDataCategory = this.checkAlphabetic() ? 1 : (this.checkNumeric() ? 2 : (this.checkAlphanumeric() ? 4 : (this.checkDbcs() ? 6 : (this.checkAlphanumericEdited() ? 5 : (this.checkExFloat() ? 7 : (this.checkNumericEdited() ? 3 : 0))))));
    }

    private boolean checkAlphabetic() {
        for (int i = 0; i < this.mPicture.length(); ++i) {
            if (this.mPicture.charAt(i) == 'A') continue;
            return false;
        }
        return true;
    }

    private boolean checkNumeric() {
        int digitCount = 0;
        for (int i = 0; i < this.mPicture.length(); ++i) {
            char ch = this.mPicture.charAt(i);
            if ("9PSV".indexOf(ch) == -1) {
                return false;
            }
            if (ch != '9') continue;
            ++digitCount;
        }
        return digitCount > 0;
    }

    private boolean checkAlphanumeric() {
        int countA = 0;
        int count9 = 0;
        int len = this.mPicture.length();
        for (int i = 0; i < len; ++i) {
            char ch = this.mPicture.charAt(i);
            if ("9XA".indexOf(ch) == -1) {
                return false;
            }
            if (ch == '9') {
                ++count9;
                continue;
            }
            if (ch != 'A') continue;
            ++countA;
        }
        return countA != len && count9 != len;
    }

    private boolean checkDbcs() {
        boolean hasG = false;
        boolean hasB = false;
        boolean hasN = false;
        for (int i = 0; i < this.mPicture.length(); ++i) {
            char ch = this.mPicture.charAt(i);
            if ("GBN".indexOf(ch) != -1) {
                switch (ch) {
                    case 'G': {
                        hasG = true;
                        break;
                    }
                    case 'B': {
                        hasB = true;
                        break;
                    }
                    case 'N': {
                        hasN = true;
                    }
                }
                continue;
            }
            return false;
        }
        return !hasN || !hasG && !hasB;
    }

    private boolean checkExFloat() {
        if (this.mPicture.length() < 4) {
            return false;
        }
        int mantissaEndPos = -1;
        int exponentEndPos = -1;
        int exponentDelimitPos = -1;
        for (int i = 0; i < this.mPicture.length(); ++i) {
            char ch = this.mPicture.charAt(i);
            if (ch == '+' || ch == '-') {
                if (i == 0) continue;
                if (mantissaEndPos == -1) {
                    return false;
                }
                if (i == mantissaEndPos + 2) continue;
                return false;
            }
            if (".V".indexOf(ch) != -1) {
                if (exponentDelimitPos != -1) {
                    return false;
                }
                mantissaEndPos = i;
                continue;
            }
            if (ch == 'E') {
                if (mantissaEndPos == -1) {
                    return false;
                }
                if (i != mantissaEndPos + 1) {
                    return false;
                }
                exponentDelimitPos = i;
                continue;
            }
            if (ch == '9') {
                if (exponentDelimitPos == -1) {
                    mantissaEndPos = i;
                    continue;
                }
                exponentEndPos = i;
                continue;
            }
            return false;
        }
        if (exponentEndPos == this.mPicture.length() - 1) {
            return this.mPicture.charAt(exponentEndPos) == '9' && this.mPicture.charAt(exponentEndPos - 1) == '9';
        }
        return false;
    }

    private boolean checkNumericEdited() {
        for (int i = 0; i < this.mPicture.length(); ++i) {
            if (this.mPicture.indexOf("CR") != -1 || this.mPicture.indexOf("DB") != -1 || "BPVZ90/,.+-*$".indexOf(this.mPicture.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean checkAlphanumericEdited() {
        boolean hasA_X = false;
        boolean hasB_0_Slant = false;
        for (int i = 0; i < this.mPicture.length(); ++i) {
            char ch = this.mPicture.charAt(i);
            if ("AX9B0/".indexOf(ch) != -1) {
                switch (ch) {
                    case 'A': 
                    case 'X': {
                        hasA_X = true;
                        break;
                    }
                    case '/': 
                    case '0': 
                    case 'B': {
                        hasB_0_Slant = true;
                    }
                }
                continue;
            }
            return false;
        }
        return hasA_X && hasB_0_Slant;
    }

    public static interface Category {
        public static final int ERR = 0;
        public static final int ALPHABETIC = 1;
        public static final int NUMERIC = 2;
        public static final int NUMERIC_EDITED = 3;
        public static final int ALPHANUMERIC = 4;
        public static final int ALPHANUMERIC_EDITED = 5;
        public static final int DBCS = 6;
        public static final int EX_FLOAT = 7;
    }
}

