/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.lodgingsupplier.pomessagebean;

import java.util.*;
import java.text.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

public class Invoice implements Serializable {

    protected String invoiceId;
    protected String opcPoId;
    protected String supplierId;
    protected String status;
    protected String hotelId;
    protected String hotelAddress;
    protected String cancelPolicy;

    // Constructor
    public Invoice() {}

    public Invoice(String invoiceId, String opcPoId, String supplier,
       String status, String hotelId, String hotelAddress,
       String cancelPolicy) {
  this.invoiceId = invoiceId;
  this.opcPoId = opcPoId;
  this.supplierId = supplier;
  this.status = status;
        this.hotelId = hotelId;
        this.hotelAddress = hotelAddress;
        this.cancelPolicy = cancelPolicy;
    }

    // getter methods
    public String getInvoiceId() {
  return invoiceId;
    }

    public String getOpcPoId() {
  return opcPoId;
    }

    public String getSupplierId() {
  return supplierId;
    }

    public String getStatus() {
  return status;
    }

    // setter methods
    public void setInvoiceId(String invoiceId) {
  this.invoiceId = invoiceId;
    }

    public void setOpcPoId(String id) {
  this.opcPoId = id;
    }

    public void setSupplierId(String id) {
  this.supplierId = id;
    }

    public void setStatus(String stat) {
  this.status = stat;
    }

    //XML serialization/deserialization methods
    public String toXML() throws ParserConfigurationException,
                                 TransformerConfigurationException,
                                 TransformerException,
                                 UnsupportedEncodingException {
  String inv = null;      

  //construct the DOM tree
  DocumentBuilderFactory docBuilderFactory = 
    DocumentBuilderFactory.newInstance();
  docBuilderFactory.setNamespaceAware(true);
  DocumentBuilder docBuilder = 
    docBuilderFactory.newDocumentBuilder();
  Document doc = docBuilder.newDocument();          
  Element  invElem = doc.createElement("Invoice");
  invElem.setAttribute("xmlns:xsi", 
           "http://www.w3.org/2001/XMLSchema-instance");
  invElem.setAttribute("xsi:schemaLocation",
         "http://java.sun.com/blueprints/ns/invoice " + 
         "http://java.sun.com/blueprints/schemas/invoice-lodging.xsd");
  invElem.setAttribute("xmlns", 
           "http://java.sun.com/blueprints/ns/invoice");
  doc.appendChild(invElem);
  Element elem = doc.createElement("ID");
  elem.appendChild(doc.createTextNode(invoiceId));
  invElem.appendChild(elem);
  elem = doc.createElement("OPCPoId");          
  elem.appendChild(doc.createTextNode(opcPoId));
  invElem.appendChild(elem);
  elem = doc.createElement("SupplierId");          
  elem.appendChild(doc.createTextNode(supplierId));
  invElem.appendChild(elem);
  elem = doc.createElement("status");          
  elem.appendChild(doc.createTextNode(status));
  invElem.appendChild(elem);
  elem = doc.createElement("HotelId");          
  elem.appendChild(doc.createTextNode(hotelId));
  invElem.appendChild(elem);
  elem = doc.createElement("HotelAddress");          
  elem.appendChild(doc.createTextNode(hotelAddress));
  invElem.appendChild(elem);
  elem = doc.createElement("CancelPolicy");          
  elem.appendChild(doc.createTextNode(cancelPolicy));
  invElem.appendChild(elem);                 
  //process the source tree
  ByteArrayOutputStream baStream = new ByteArrayOutputStream();
  Result res = new StreamResult(baStream);
  TransformerFactory transFactory = TransformerFactory.newInstance();
  Transformer transformer = transFactory.newTransformer();
  transformer.setOutputProperty(OutputKeys.METHOD, "xml");          
  transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
  transformer.setOutputProperty(OutputKeys.INDENT, "yes");
  transformer.transform(new DOMSource(doc), res);
  inv = baStream.toString("UTF-8");  
  return inv;   
    }
}
