/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.api;

import org.netbeans.modules.bpel.model.api.events.VetoException;

/**
 * This type is extended by other component types to allow elements and
 * attributes from other namespaces to be added.
 * <p>
 * Java class for tExtensibleElements complex type.
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 *
 * <pre>
 *  &lt;xsd:complexType name="tExtensibleElements">
 *       &lt;xsd:annotation>
 *           &lt;xsd:documentation>
 *               This type is extended by other component types to allow elements and attributes from
 *               other namespaces to be added at the modeled places.
 *           &lt;/xsd:documentation>
 *       &lt;/xsd:annotation>
 *       &lt;xsd:sequence>
 *           &lt;xsd:element ref="documentation" minOccurs="0" maxOccurs="unbounded"/>
 *           &lt;xsd:any namespace="##other" processContents="lax" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;/xsd:sequence>
 *       &lt;xsd:anyAttribute namespace="##other" processContents="lax"/>
 *   &lt;/xsd:complexType>
 * </pre>
 */
public interface ExtensibleElements extends BpelContainer {

    /**
     * @return Documentation cildren.
     */
    Documentation[] getDocumentations();

    /**
     * Returns <code>i</code>-th Documentation element.
     * 
     * @param i Index in Documentation children array.
     * @return <code>i</code>-th Documentation child.
     */
    Documentation getDocumentation( int i );

    /**
     * Removes <code>i</code>-th Documentation child.
     * 
     * @param i Index in children array.
     */
    void removeDocumentation( int i );

    /**
     * Set new <code>documentation</code> element to the <code>i</code>-th
     * position.
     * 
     * @param documentation New Documentation child
     * @param i Index in children array.
     */
    void setDocumentation( Documentation documentation, int i );

    /**
     * Insert new <code>documentation</code> element to the <code>i</code>
     * position.
     * 
     * @param documentation
     *            New Documentation child
     * @param i Index in children array.
     */
    void insertDocumentation( Documentation documentation, int i );

    /**
     * Set new Documentation array .
     * 
     * @param documentations New array.
     */
    void setDocumentations( Documentation[] documentations );

    /**
     * Adds new <code>documentation</code> in the end of children list.
     * 
     * @param documentation New documentation element.
     */
    void addDocumentation( Documentation documentation );

    /**
     * @return size of children Documentation elements.
     */
    int sizeOfDocumentations();

    /**
     *
     */
    String getDocumentation();

    /**
     *
     */
    void setDocumentation(String documentation) throws VetoException;
}
