/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.model.impl.services.InnerEventDispatcherAdapter;

/**
 * This special service dispatch ArrayUpdateEvent. The situation with this event
 * is complecated then other events. When one set array then new childrne array
 * may contains children that already exist in the same parent. In this case
 * such elements will be cloned and their copies will be set. In this case we
 * need to set old content to new element. ( cookies , the same id's ).
 * 
 * @author ads
 */
public class ArraySetterService extends InnerEventDispatcherAdapter {

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.xam.spi.InnerEventDispatcher#isApplicable(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public boolean isApplicable( ChangeEvent event ) {
        return event.getClass().equals(ArrayUpdateEvent.class);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.xam.spi.InnerEventDispatcher#postDispatch(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public void postDispatch( ChangeEvent event ) {
        ArrayUpdateEvent<? extends BpelEntity> arrayEvent = 
            (ArrayUpdateEvent<? extends BpelEntity>) event;
        BpelEntity[] old = arrayEvent.getOldArray();
        for (BpelEntity entity : old) {
            Object obj = entity.getCookie(BpelContainerImpl.CopyKey.class);
            if (obj != null) {
                // need to set cookie , id's from old to new "obj" entity
                assert obj instanceof BpelEntity;
                copyContent(entity, (BpelEntity) obj);
            }
        }
    }

    @SuppressWarnings("unchecked") // NOI18N
    private void copyContent( BpelEntity orig, BpelEntity copy )
    {

        // set the same uid after copy.
        UniqueId id = orig.getUID();
        ((BpelEntityImpl) copy).setUID(id);

        // clone hashmap , remove internalally used key CopyKey.class and set to
        // new element.
        Map<Object, Object> map = ((BpelEntityImpl) orig).getCookies();
        assert map instanceof HashMap;
        map = (Map) ((HashMap<Object, Object>) map).clone();
        map.remove(BpelContainerImpl.CopyKey.class);
        ((BpelEntityImpl) copy).setCookies(map);

        // recursively proceed with children.
        BpelEntity component = (BpelEntity) orig;
        if (component.getChildren().size() > 0) {
            int i = 0;
            List<BpelEntity> copyChildren = ((BpelEntity) copy).getChildren();
            BpelEntity[] childOfCopy = copyChildren
                    .toArray(new BpelEntity[copyChildren.size()]);
            for (BpelEntity child : component.getChildren()) {
                copyContent(child, childOfCopy[i]);
                i++;
            }
        }
    }
}
