/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.impl;

import java.util.List;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.support.BpelModelVisitor;
import org.netbeans.modules.bpel.model.xam.AfterImport;
import org.netbeans.modules.bpel.model.xam.AfterSources;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.w3c.dom.Element;

/**
 * @author ads
 */
public class CorrelationSetContainerImpl extends ExtensibleElementsImpl implements
        CorrelationSetContainer, AfterImport, AfterSources
{

    CorrelationSetContainerImpl( BpelModelImpl model, Element e ) {
        super(model, e);
    }

    CorrelationSetContainerImpl( BpelBuilderImpl builder ) {
        super(builder, BpelElements.CORRELATION_SETS.getName() );
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#getCorrelationSets()
     */
    public CorrelationSet[] getCorrelationSets() {
        readLock();
        try {
            List<CorrelationSet> list = 
                getChildren(CorrelationSet.class);
            return list.toArray(new CorrelationSet[list.size()]);
        }
        finally {
            readUnlock();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#getCorrelationSet(int)
     */
    public CorrelationSet getCorrelationSet( int i ) {
        return getChild(CorrelationSet.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#removeCorrelationSet(int)
     */
    public void removeCorrelationSet( int i ) {
        removeChild(CorrelationSet.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#addCorrelationSet(org.netbeans.modules.soa.model.bpel20.api.CorrelationSet)
     */
    public void addCorrelationSet( CorrelationSet set ) {
        addChild(set, CorrelationSet.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#insertCorrelationSet(org.netbeans.modules.soa.model.bpel20.api.CorrelationSet,
     *      int)
     */
    public void insertCorrelationSet( CorrelationSet set, int i ) {
        insertAtIndex(set, CorrelationSet.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#setCorrelationSets(org.netbeans.modules.soa.model.bpel20.api.CorrelationSet[])
     */
    public void setCorrelationSets( CorrelationSet[] set ) {
        setArrayBefore(set, CorrelationSet.class);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#setCorrelationSet(org.netbeans.modules.soa.model.bpel20.api.CorrelationSet,
     *      int)
     */
    public void setCorrelationSet( CorrelationSet set, int i ) {
        setChildAtIndex(set, CorrelationSet.class, i);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.CorrelationSetContainer#sizeOfCorrelationSet()
     */
    public int sizeOfCorrelationSet() {
        readLock();
        try {
            return getChildren(CorrelationSet.class).size();
        }
        finally {
            readUnlock();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel20.api.BpelEntity#getElementType()
     */
    public Class<? extends BpelEntity> getElementType() {
        return CorrelationSetContainer.class;
    }

    public void accept( BpelModelVisitor visitor ) {
        visitor.visit(this);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel.xdm.impl.BpelContainerImpl#create(org.w3c.dom.Element)
     */
    @Override
    protected BpelEntity create( Element element )
    {
        if ( BpelElements.CORRELATION_SET.getName().equals(element.getLocalName())) {
            return new CorrelationSetImpl(getModel(), element);
        }
        return super.create( element );
    }

}
