/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.impl;

import java.util.concurrent.atomic.AtomicReference;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.BpelModelVisitor;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.model.xam.BpelAttributes;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.w3c.dom.Element;

/**
 * @author ads
 */
public class PartnerLinkImpl extends NamedElementImpl implements PartnerLink {

    PartnerLinkImpl( BpelModelImpl model, Element e ) {
        super(model, e);
    }

    PartnerLinkImpl( BpelBuilderImpl builder ) {
        super(builder, BpelElements.PARTNER_LINK.getName() );
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.netbeans.modules.soa.model.bpel.api.BpelEntity#getElementType()
     */
    public Class<? extends BpelEntity> getElementType() {
        return PartnerLink.class;
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#getInitializePartnerRole()
     */
    public TBoolean getInitializePartnerRole() {
        return getBooleanAttribute( BpelAttributes.INITIALIZE_PARTNER_ROLE );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#setInitializePartnerRole(org.netbeans.modules.soa.model.bpel20.api.support.TBoolean)
     */
    public void setInitializePartnerRole( TBoolean value ) {
        setBpelAttribute( BpelAttributes.INITIALIZE_PARTNER_ROLE , value );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#removeInitializePartnerRole()
     */
    public void removeInitializePartnerRole() {
        removeAttribute( BpelAttributes.INITIALIZE_PARTNER_ROLE );
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#setPartnerLinkType(org.netbeans.modules.soa.model.bpel20.references.WSDLReference)
     */
    public void setPartnerLinkType( WSDLReference<PartnerLinkType> value ) {
        setWSDLReference( BpelAttributes.PARTNER_LINK_TYPE, value  );
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#setMyRole(org.netbeans.modules.soa.model.bpel20.api.support.WSDLReference)
     */
    public void setMyRole( WSDLReference<Role> role ) {
        setWSDLReference( BpelAttributes.MY_ROLE , role );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#setPartnerRole(org.netbeans.modules.soa.model.bpel20.api.support.WSDLReference)
     */
    public void setPartnerRole( WSDLReference<Role> value ) {
        setWSDLReference( BpelAttributes.PARTNER_ROLE , value );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#getMyRole()
     */
    public WSDLReference<Role> getMyRole() {
        return getWSDLReference( BpelAttributes.MY_ROLE , Role.class );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#removeMyRole()
     */
    public void removeMyRole() {
        removeReference( BpelAttributes.MY_ROLE );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#getPartnerLinkType()
     */
    public WSDLReference<PartnerLinkType> getPartnerLinkType() {
        return getWSDLReference( BpelAttributes.PARTNER_LINK_TYPE ,
                PartnerLinkType.class);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#getPartnerRole()
     */
    public WSDLReference<Role> getPartnerRole() {
        return getWSDLReference( BpelAttributes.PARTNER_ROLE , Role.class );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.PartnerLink#removePartnerRole()
     */
    public void removePartnerRole() {
        removeReference( BpelAttributes.PARTNER_ROLE );
    }
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.api.references.ReferenceCollection#getReferences()
     */
    public Reference[] getReferences() {
        return new Reference[] { getPartnerRole() , getMyRole() , 
                getPartnerLinkType()};
    }

    public void accept( BpelModelVisitor visitor ) {
        visitor.visit(this);
    }
    
    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.impl.BpelEntityImpl#getDomainAttributes()
     */
    protected Attribute[] getDomainAttributes() {
        if ( myAttributes.get() == null ){
            Attribute[] attr = super.getDomainAttributes();
            Attribute[] ret = new Attribute[ attr.length + 4];
            System.arraycopy( attr , 0 , ret , 4 , attr.length );
            ret[ 0 ] = BpelAttributes.INITIALIZE_PARTNER_ROLE;
            ret[ 1 ] = BpelAttributes.PARTNER_LINK_TYPE;
            ret[ 2 ] = BpelAttributes.MY_ROLE;
            ret[ 3 ] = BpelAttributes.PARTNER_ROLE;
            myAttributes.compareAndSet( null, ret);
        }
        return myAttributes.get();
    }
    
    private static AtomicReference<Attribute[]> myAttributes = 
        new AtomicReference<Attribute[]>();

}
