/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author apepin
 */
public class XmlEditor extends TextFileBuilder{
    private int currentLine = 0;
    public XmlEditor(File file){
        super(file);
        System.out.println("XmlEditor created");
        load();
        System.out.println(file.getName()+" loaded");
    }
    
    public SourceElement findSourceElement(String elTagName, int fromLine) throws ElementNotFoundException{
        //assume next element is not placed in the same line
        if(elTagName == null)
            elTagName = "";
        SourceElement nextElement = null;
        for(int line = fromLine; line < getLinesNumber(); line++){
            try{
                setLineNumber(line);
                nextElement = new SourceElement(this, elTagName);
                break;
            }catch(ElementNotFoundException e){
                
            }catch(IllegalArgumentException e){
                throw new ElementNotFoundException("No more elements");
            }
        }
        return nextElement;
    }
    
    
    public SourceElement findSourceElement(String elTagName) throws ElementNotFoundException{
        return findSourceElement(elTagName, 0);
    }

    public int getLineNumber() {
        return currentLine;
    }

    public void setLineNumber(int currentLine) {
        this.currentLine = currentLine;
    }
    
}

class TextFileBuilder {
    private File file = null;
    private List<String> text = new LinkedList<String>();
    /** Creates a new instance of TextFileBuilder */
    public TextFileBuilder(File file) {
        this.file = file;
    }

    public void load(){
        if(file != null){
            try {
                Reader reader = new FileReader(file);
                //read file
                read(reader);
                reader.close();
            } catch (FileNotFoundException ex) {
                ex.printStackTrace();
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void save(){
        if(file != null){
//                FileLock lock = null;
            try {
                //System.out.println("start saving to "+file.getName()+"."+file.getExt());
//                    lock = file.lock();
                Writer writer = new FileWriter(file);
                //write file
                write(writer);
//                writer.flush();
                writer.close();
                //System.out.println("finish saving to "+file.getName()+"."+file.getExt());
            } catch (IOException ex) {
                ex.printStackTrace();
            } finally{
//                    if(lock != null && lock.isValid()){
//                        lock.releaseLock();
//                }
            }
        }
    }

    public void reload(){
        text = new LinkedList<String>();
        load();
    }

    private void read(Reader reader){
        read(reader, text);
    }

    private void read(Reader reader, List txt){
        BufferedReader buffReader = new BufferedReader(reader);
        int simbol;
        String line = null;
        try {
//            System.out.println("Start reading");
            while((line=buffReader.readLine()) != null){
//                System.out.println("line: "+line);
                try{
                txt.add(line);
                }catch(Throwable t){
                    t.printStackTrace();
                }
            }
//            System.out.println("finish reading");
            buffReader.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        }

    }

    private void write(Writer writer){
        BufferedWriter buffWriter = new BufferedWriter(writer);
        try {
//            System.out.println("start writing");
            for(String line: text){
//                System.out.println("write line: "+line);
                buffWriter.write(line);
                buffWriter.newLine();
            }
            buffWriter.flush();
            buffWriter.close();
//            System.out.println("finish writing");
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public boolean appendLine(String txt, int line){
        boolean result = false;
        try{
            text.add(line, txt);
            result = true;
        } catch(Exception e){}
        return result;
    }

    public boolean appendText(String txt, int line){
        List<String> lines = new ArrayList<String>();
        read(new StringReader(txt), lines);
        //System.out.println("insert text at line "+line);
        return text.addAll(line, lines);
    }

    public boolean appendText(TextFileBuilder builder, int line){
        return text.addAll(line, builder.text);
    }


    public boolean appendLine(String txt){
        return text.add(txt);
    }

    public void removeLine(int line){
        text.remove(line);
    }

    public boolean replaceLine(int line, String newText){
        text.remove(line);
        return appendLine(newText, line);
    }
    
    public void insertTextIntoLine(String txt, int line, int column){
        if(txt.indexOf('\n')>=0)
            throw new IllegalArgumentException("multiline text");
        String oldLine = getLine(line);
        String newLine = oldLine.substring(0, column) + txt +
                oldLine.subSequence(column, oldLine.length());
        replaceLine(line, newLine);
    }
    
    public void deleteTextFromLine(int line, int columnFrom, int columnTo){
        String oldLine = getLine(line);
        String newLine = oldLine.substring(0, columnFrom) +
                oldLine.subSequence(columnTo, oldLine.length());
        replaceLine(line, newLine);
        
    }

    public int findLineStartsWith(String prefix){
        int index = 0;
        boolean res = false;
        for(String line: text){
//            System.out.println("line "+index+" :"+line);
            if(res = line.trim().startsWith(prefix))
                break;
            index++;
        }
        return res ? index: -1;
    }

    public int findLineStartsWith(String prefix, int fromLine){
        int index = 0;
        boolean res = false;
        for(String line: text){
//            System.out.println("line "+index+" :"+line);
            if(index>=fromLine){
                if(res = line.trim().startsWith(prefix))
                    break;
            }
            index++;
        }
        return res ? index: -1;
    }

    public String getLine(int line){
        return text.get(line);
    }
    
    public int getLinesNumber(){
        return text.size();
    }
    
    public void dump(){
        for(String line: text){
            System.out.println(line);
        }
    }
}

class ElementNotFoundException extends Exception{
    public ElementNotFoundException(){}
    public ElementNotFoundException(String text){
        super(text);
    }
}
