/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.bpel.debugger.test;

import junit.framework.TestCase;
import org.netbeans.modules.bpel.debugger.test.stub.StubTracer;

import org.netbeans.spi.debugger.ContextProvider;

import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.Tracer;
import org.netbeans.modules.bpel.debugger.api.AttachingCookie;
import org.netbeans.modules.bpel.debugger.BpelDebuggerImpl;
import org.netbeans.modules.bpel.debugger.BreakPosition;
import org.netbeans.modules.bpel.debugger.test.stub.SimulationPositionThread;
import org.netbeans.modules.bpel.debugger.test.stub.StubBpelDebuggerPropertyChangeListener;
import org.netbeans.modules.bpel.debugger.test.stub.StubDebugConnector;
import org.netbeans.modules.bpel.debugger.test.stub.StubLookup;


public class BpelDebuggerImpl_Test extends TestCase {
    
    
    /**
     * Test basic attaching and detaching.
     * The debugger state and its listeners are verified for correctness.
     */
    public void testAttachDetach() {
        ContextProvider lookup = new StubLookup();
        StubDebugConnector goodConnector = new StubDebugConnector(true);
        BpelDebuggerImpl debugger = new BpelDebuggerImplForTest(lookup, goodConnector);
        
        StubBpelDebuggerPropertyChangeListener listener = new StubBpelDebuggerPropertyChangeListener();
        debugger.addPropertyChangeListener(listener);
        assertTrue(debugger.canStartNewSession());
        assertNull(debugger.getCurrentPosition());
        assertEquals(0, debugger.getBreakpoints().length);
        assertNull(debugger.getCurrentProcessInstance());
        assertEquals(ProcessInstance.STATE_UNKNOWN, debugger.getCurrentProcessInstanceState());
        assertNull(debugger.getException());
        assertNull(debugger.getProcessInstancesModel());
        assertEquals(BpelDebugger.STATE_DISCONNECTED, debugger.getState());
        assertNull(debugger.getVariableNames());
        
        // Basic attach, detach.
        
        debugger.setStarting();
        assertEquals(BpelDebugger.STATE_STARTING, debugger.getState());
        assertEquals(BpelDebugger.STATE_STARTING, listener.getCurrentState());
        assertFalse(debugger.canStartNewSession());
        
        debugger.setRunning((AttachingCookie) debugger.getLookupProvider().lookupFirst(null, AttachingCookie.class));
        assertEquals(BpelDebugger.STATE_RUNNING, debugger.getState());
        assertEquals(BpelDebugger.STATE_RUNNING, listener.getCurrentState());
        assertFalse(debugger.canStartNewSession());
        
        debugger.finish();
        assertEquals(BpelDebugger.STATE_DISCONNECTED, debugger.getState());
        assertEquals(BpelDebugger.STATE_DISCONNECTED, listener.getCurrentState());
        assertTrue(debugger.canStartNewSession());
        
        // Attach again, this time detach after we start but before we run.
        
        debugger.setStarting();
        assertEquals(BpelDebugger.STATE_STARTING, debugger.getState());
        assertEquals(BpelDebugger.STATE_STARTING, listener.getCurrentState());
        assertFalse(debugger.canStartNewSession());
        
        debugger.finish();
        assertEquals(BpelDebugger.STATE_DISCONNECTED, debugger.getState());
        assertEquals(BpelDebugger.STATE_DISCONNECTED, listener.getCurrentState());
        assertTrue(debugger.canStartNewSession());

        debugger.setStarting();
        assertEquals(BpelDebugger.STATE_STARTING, debugger.getState());
        assertEquals(BpelDebugger.STATE_STARTING, listener.getCurrentState());
        assertFalse(debugger.canStartNewSession());

        debugger.setRunning((AttachingCookie) debugger.getLookupProvider().lookupFirst(null, AttachingCookie.class));
        assertEquals(BpelDebugger.STATE_RUNNING, debugger.getState());
        assertEquals(BpelDebugger.STATE_RUNNING, listener.getCurrentState());
        assertFalse(debugger.canStartNewSession());
        
        debugger.finish();
        assertEquals(BpelDebugger.STATE_DISCONNECTED, debugger.getState());
        assertEquals(BpelDebugger.STATE_DISCONNECTED, listener.getCurrentState());
        assertTrue(debugger.canStartNewSession());
    }
    
    
    /**
     * Ensure that debugger connections that fail to initialize
     * are registered as not able to start new debugging sessions.
     */
    public void testInitialization() {
        ContextProvider lookup = new StubLookup();
        StubDebugConnector badConnector  = new StubDebugConnector(false);
        StubDebugConnector goodConnector = new StubDebugConnector(true);
        BpelDebuggerImpl debugger1 = new BpelDebuggerImplForTest(lookup, badConnector);
        assertFalse(debugger1.canStartNewSession());
        BpelDebuggerImpl debugger2 = new BpelDebuggerImplForTest(lookup, goodConnector);
        assertTrue(debugger2.canStartNewSession());
    }
    
    
    /**
     * Tests the position handling of the debugger.
     * While multiple threads may attempt to set the position at the same time,
     * only one will be able to successfully do so.
     */
    public void testPositioning() {
        ContextProvider lookup = new StubLookup();
        StubDebugConnector goodConnector = new StubDebugConnector(true);
        BpelDebuggerImpl debugger = new BpelDebuggerImplForTest(lookup, goodConnector);

        StubBpelDebuggerPropertyChangeListener listener = new StubBpelDebuggerPropertyChangeListener();
        debugger.addPropertyChangeListener(listener);
        debugger.setStarting();
        debugger.setRunning((AttachingCookie) debugger.getLookupProvider().lookupFirst(null, AttachingCookie.class));
        
        SimulationPositionThread[] threads = SimulationPositionThread.createSimulationThreads(this, debugger);
        SimulationPositionThread.startThreads(this, threads);
        
        // ensure only one of the threads was able to set the position
        assertEquals(1, listener.getPositionChangeCount());
        assertNotNull(debugger.getCurrentPosition());
        assertNotNull(debugger.getCurrentProcessInstance());
        
        debugger.finish();
    }
    
    
    // Overrides the class under test to insert stub classes where needed.
    private class BpelDebuggerImplForTest extends BpelDebuggerImpl {
        private StubDebugConnector mConnector;
        public BpelDebuggerImplForTest(ContextProvider lookupProvider, StubDebugConnector connector) {
            super(lookupProvider);
            mConnector = connector;
        }
        public void setActivePosition(final BreakPosition newPosition) {
            System.out.println("setActivePosition entered: " + newPosition.getProcessQName().getLocalPart());
            super.setActivePosition(newPosition);
        }
        public Tracer getTracer() {
            return new StubTracer();
        }
    }
}
