/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.bpel.debugger.test.stub;

import junit.framework.TestCase;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.BPELDebugger;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.DebugFrame;


public class SimulationBreakpointThread extends Thread {

    public static final String FILE_HOTELS = "hotels.bpel";
    public static final String FILE_AIR    = "air.bpel";
    public static final String FILE_TRAIN  = "train.bpel";

    public static final String URL_SERVER_HOTELS = "http://www.stcvegas.com/hotels";
    public static final String URL_SERVER_AIR    = "http://www.stcdelta.com/air";
    public static final String URL_SERVER_TRAIN  = "http://www.stcamtrak.com/train";
    
    public static final String URL_NB_HOTELS     = "C:/foo1/foo2/hotels.bpel";
    public static final String URL_NB_AIR        = "C:/air.bpel";

    public static final int LINE_BREAK_HOTELS =   5;
    public static final int LINE_BREAK_AIR1   = 125;
    public static final int LINE_BREAK_AIR2   = 164;

    private TestCase mTestCase;
    private BPELDebugger mController;
    private String mBpelFile;
    private int mLineStart;
    private int mLineEnd;
    private String mURI;
    private DebugFrame mFrame;
    
    
    public SimulationBreakpointThread(TestCase testCase,
                            BPELDebugger controller, 
                            String file, 
                            int start, 
                            int end, 
                            String uri) {
        super(file);
        mTestCase = testCase;
        mController = controller;
        mBpelFile = file;
        mLineStart = start;
        mLineEnd = end;
        mURI = uri;
    }
    
    
    public static SimulationBreakpointThread[] createSimulationThreads(TestCase testCase, BPELDebugger controller) {
        SimulationBreakpointThread threadHotels1 = new SimulationBreakpointThread(testCase, controller, 
                FILE_HOTELS,   0,  10, URL_SERVER_HOTELS);
        SimulationBreakpointThread threadAir     = new SimulationBreakpointThread(testCase, controller, 
                FILE_AIR,    122, 165, URL_SERVER_AIR);
        SimulationBreakpointThread threadHotels2 = new SimulationBreakpointThread(testCase, controller, 
                FILE_HOTELS,   0,  10, URL_SERVER_HOTELS);
        SimulationBreakpointThread threadTrain   = new SimulationBreakpointThread(testCase, controller, 
                FILE_TRAIN,   30,  50, URL_SERVER_TRAIN);
        return new SimulationBreakpointThread[] { threadHotels1, threadAir, threadHotels2, threadTrain };
    }
    
    
    public static void startThreads(TestCase testCase, 
                                    SimulationBreakpointThread[] threads) {
        // start all threads, wait until all are either suspended or complete
        for (int i=0; i < threads.length; i++) {
            threads[i].start();
        }
        try {
            Thread.sleep(2000);
        } catch (Exception e) {
            testCase.assertNull(e);
        }
    }

    
    public static void startThreads(TestCase testCase, 
                                    SimulationBreakpointThread[] threads, 
                                    SimulationBreakpointThread firstThread) {
        // start the first thread, ensure it starts up completely
        firstThread.start();
        try {
            Thread.sleep(1000);
        } catch (Exception e) {
            testCase.assertNull(e);
        }

        // start remaining threads, wait until all are either suspended or complete
        for (int i=0; i < threads.length; i++) {
            if (threads[i] != firstThread) {
                threads[i].start();
            }
        }
        try {
            Thread.sleep(2000);
        } catch (Exception e) {
            testCase.assertNull(e);
        }
    }
    
    
    public void run() {
        yield();
        delay(500);
        yield();
        mFrame = mController.enterFrame(null, mBpelFile, mURI);
        for (int i=mLineStart; i < mLineEnd; i++) {
            mFrame.onLineChange(mBpelFile, mURI, i, null);
        }
        mFrame.onExit(mBpelFile, mURI);
    }
    
    private void delay(int ms) {
        try {
            sleep(ms);
        } catch (Exception e) {
            mTestCase.assertNull(e);
        }
    }
    
    public DebugFrame getFrame() {
        return mFrame;
    }
}
