/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.process;

import org.netbeans.modules.bpel.debugger.ui.util.HtmlUtil;
import org.openide.util.NbBundle;

import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;

/**
 * @author Vladimir Yaroslavskiy
 * @version 2005.10.24
 */
public class BpelProcessView implements NodeModel, TableModel {
    
    /**{@inheritDoc}*/
    public BpelProcessView(ContextProvider contextProvider) {
        myDebugger =
            (BpelDebugger) contextProvider.lookupFirst(null, BpelDebugger.class);
    }
    
    // NodeModel ----------------------------------------------------
    
    /**{@inheritDoc}*/
    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return NbBundle.getMessage(
                BpelProcessView.class, "CTL_Process_Column_Name"); // NOI18N
        }
        if ( !(object instanceof ProcessInstance)) {
            throw new UnknownTypeException(object);
        }
        ProcessInstance process = (ProcessInstance) object;
        String name = process.getName();
        return isProcessInstanceCurrent(process) ?
            HtmlUtil.toBold(name) : name;
    }
    
    /**{@inheritDoc}*/
    public String getShortDescription(Object object) throws UnknownTypeException {
        return getDisplayName(object);
    }
    
    /**{@inheritDoc}*/
    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return CURRENT_PROCESS_IMAGE;
        }
        if ( !(object instanceof ProcessInstance)) {
            throw new UnknownTypeException(object);
        }
        ProcessInstance process = (ProcessInstance) object;
        
        if (isProcessInstanceCurrent(process)) {
            return CURRENT_PROCESS_IMAGE;
        }
        int state = process.getState();
        
        if (state == ProcessInstance.STATE_SUSPENDED) {
            return SUSPENDED_PROCESS_IMAGE;
        }
        //to do a
        return RUNNING_PROCESS_IMAGE;
    }
    
    // --------------------------------------------------------------
    
    /**{@inheritDoc}*/
    public void addModelListener(ModelListener listener) {}

    /**{@inheritDoc}*/
    public void removeModelListener(ModelListener listener) {}
    
    // TableModel ---------------------------------------------------
    
    /**{@inheritDoc}*/
    public Object getValueAt(Object object, String column)
        throws UnknownTypeException
    {
        if ( !(object instanceof ProcessInstance)) {
            throw new UnknownTypeException(object);
        }
        ProcessInstance process = (ProcessInstance) object;
        
        if (column.equals(BpelProcessColumn.PROCESS_STATE_COLUMN_ID)) {
            switch (process.getState()) {
                case ProcessInstance.STATE_UNKNOWN:
                    return NbBundle.getMessage(
                      BpelProcessView.class,
                      "CTL_Process_State_Unknown"); // NOI18N
                case ProcessInstance.STATE_RUNNING:
                    return NbBundle.getMessage(
                      BpelProcessView.class,
                      "CTL_Process_State_Running"); // NOI18N
                case ProcessInstance.STATE_COMPLETED:
                    return NbBundle.getMessage(
                      BpelProcessView.class,
                      "CTL_Process_State_Completed"); // NOI18N
                case ProcessInstance.STATE_FAILED:
                    return NbBundle.getMessage(
                      BpelProcessView.class,
                      "CTL_Process_State_Failed"); // NOI18N
                case ProcessInstance.STATE_SUSPENDED:
                    return NbBundle.getMessage(
                      BpelProcessView.class,
                      "CTL_Process_State_Suspended"); // NOI18N
                case ProcessInstance.STATE_TERMINATED:
                    return NbBundle.getMessage(
                      BpelProcessView.class,
                      "CTL_Process_State_Terminated"); // NOI18N
                default:
                    throw new UnknownTypeException(object);
            }
        }
        if (column.equals(BpelProcessColumn.PROCESS_SUSPENDED_COLUMN_ID)) {
            return Boolean.valueOf(
                process.getState() == ProcessInstance.STATE_SUSPENDED);
        }
        throw new UnknownTypeException(object);
    }
    
    /**{@inheritDoc}*/
    public void setValueAt(Object object, String column, Object value)
        throws UnknownTypeException
    {
        if ( !(object instanceof ProcessInstance)) {
            throw new UnknownTypeException(object);
        }
    }
    
    /**{@inheritDoc}*/
    public boolean isReadOnly(Object object, String column)
        throws UnknownTypeException
    {
        if ( !(object instanceof ProcessInstance)) {
            throw new UnknownTypeException(object);
        }
        if (column.equals(BpelProcessColumn.PROCESS_STATE_COLUMN_ID)) {
            return true;
        }
        if (column.equals(BpelProcessColumn.PROCESS_SUSPENDED_COLUMN_ID)) {
            return true;
        }
        throw new UnknownTypeException(object);
    }
    
    private boolean isProcessInstanceCurrent(ProcessInstance process) {
        return process == myDebugger.getCurrentProcessInstance();
    }
    
    private BpelDebugger myDebugger;
    private static final String BASE =
        "org/netbeans/modules/bpel/debugger/ui/resources/image/"; // NOI18N
    private static final String CURRENT_PROCESS_IMAGE =
        BASE + "current"; // NOI18N
    private static final String RUNNING_PROCESS_IMAGE =
        BASE + "running"; // NOI18N
    private static final String SUSPENDED_PROCESS_IMAGE =
        BASE + "suspended"; // NOI18N
}
