/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes.impl;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bpel.model.api.BpelEntity;

import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.xpath.model.node.visitor.LocalVariableFinderVisitor;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.CatchNode;
import org.netbeans.modules.bpel.xpath.model.nodes.ForEachNode;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeFactory;
import org.netbeans.modules.bpel.xpath.model.nodes.ScopeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;

/**
 *
 * @author radval
 *
 */
public class VariablesNodeImpl extends AbstractTreeNode implements VariablesNode {
    
    private static final Logger LOGGER = Logger.getLogger(VariablesRootNodeImpl.class.getName());

    private VariableContainer mVariables;
    private TreeNode mLocalVariables;
    private BpelEntity mContextActivity;

    
    public VariablesNodeImpl(VariableContainer variables) {
        super(variables);
        this.mVariables = variables;
    }
    
    
    public List getGlobalVariables() {
        if (mLocalVariables != null) {
            return mChildren.subList(0, mChildren.indexOf(mLocalVariables));
        }
        return mChildren;
    }
    
    public VariableNode getVariableNode(String variableName) {
        if (variableName == null) {
            return null;
        }
        
        VariableNode variableNode = null;
        List children = getChildren();
        Iterator it = children.iterator();
        Object tmpNode = null;
        for (Iterator iter = children.iterator(); iter.hasNext();) {
            tmpNode = iter.next();
            VariableNode iterNode = null;
            if (tmpNode instanceof ScopeNode) {
                iterNode = ((ScopeNode) tmpNode).getVariableNode(variableName);
            } else if (tmpNode instanceof VariableNode) {
                iterNode = (VariableNode) tmpNode;
            } else if (tmpNode instanceof ForEachNode) {
                iterNode = ((ForEachNode) tmpNode).getVariableNode(variableName);
            } else if (tmpNode instanceof CatchNode) {
                iterNode = ((CatchNode) tmpNode).getVariableNode(variableName);
            }

            if (iterNode != null) {
                String name = iterNode.getName();
                if (variableName.equals(name)) {
                    variableNode = iterNode;
                    break;
                }
            }
        }
        return variableNode;
    }
    
    protected void lazyLoadChildren() {
        Variable[] variables = this.mVariables.getVariables();
        if (variables != null) {
            for(int i = 0; i < variables.length; i++) {
                Variable variable = variables[i];
                TreeNode node = (TreeNode) NodeFactory.getInstance().createNode(variable);
                if(node != null) {
                    this.addChild(node);
                }
            }
        }
    }
    
    public void setContextActivity(BpelEntity entity) {
        // detect for and add local variables
        if (mLocalVariables != null) {
            this.removeChild(mLocalVariables);
            mLocalVariables = null;
        }
        mContextActivity = entity;
        generateLocals();
    }
    
    private void generateLocals() {
        LocalVariableFinderVisitor finder = new LocalVariableFinderVisitor();
        try {
            mContextActivity.accept(finder);
            TreeNode localVariableNodeRoot = finder.getLocalVariableNodes();
            if (localVariableNodeRoot != null) {
                mLocalVariables = localVariableNodeRoot;
                this.addChild(localVariableNodeRoot);
            }
        } catch (IllegalStateException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
    }
    
    public boolean hasLocalVariables() {
        return mLocalVariables != null;
    }

    public String getXPath() {
        // TODO Auto-generated method stub
        return null;
    }
    
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
    
    public boolean isMappable() {
        return false;
    }
}
