/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression.impl;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;

/**
 * 
 * @author radval
 *
 */
public class TargetTreeHelper extends MapperTreeHelper {

	protected static final Logger LOGGER = Logger.getLogger(TargetTreeHelper.class.getName());
	
	private HashMap mExpandedMapperDestTreeNodes = new HashMap();
	
	private TreeModel mTreeModel;
	
	public TargetTreeHelper(BpelMapper mapper ) {
		super(mapper);
		this.mTreeModel = mapper.getMapperViewManager().getDestView().getTree().getModel();
	}
	
	public TreeModel getTreeModel() {
		return this.mTreeModel;
	}
	
	/*
	class TargetTreeExpansionListener implements TreeExpansionListener {
		
	    public void treeCollapsed(TreeExpansionEvent event) {

	        XMLNode selection = getSelectedElement();
	        
	        if (selection == null) {
	            LOGGER.severe(" Selected Link Cannot be null while a "
	                         + "tree is being modified");

	            return;
	        }
	        Set s = null;
	        
            s = (Set) mExpandedMapperDestTreeNodes.get(selection);
	        
	        if (s == null) {
	            return;
	        }

	        TreePath tp = event.getPath();
	        Object lastPath = tp.getLastPathComponent();
	        for (Iterator itr = s.iterator(); itr.hasNext();) {

	            TreePath obj = (TreePath) itr.next();
	            if (tp.isDescendant((TreePath) obj)
	                && !(tp.equals(obj))) {
	                itr.remove();
	            }
	        }

	        
            mExpandedMapperDestTreeNodes.put(selection, s);
	        
	    }

	    
	    public void treeExpanded(TreeExpansionEvent event) {

	        LOGGER.finer("In Expand TreePath");
	        
	        XMLNode selection = getSelectedElement();
	        
	        if (selection == null) {
	            LOGGER.severe(" Selected Link Cannot be null while a "
	                         + "tree is being modified");
	            return;
	        }
	        Set s = null;
            s = (Set) mExpandedMapperDestTreeNodes.get(selection);
	        
	        if (s == null) {
	            //s = Collections.synchronizedSet(new HashSet());
	            s = new HashSet();
	        }
	        // when someone expands we need to save the state of the next level
	        // so get the first child of the expanded node and use that for the
	        // state.
	        TreePath tp = event.getPath();
	        Object expandedObj = tp.getLastPathComponent();
	        Object child = null;
	        TreeModel tModel = null;
	        {
	            tModel = getTreeModel();
	            if (tModel.getChildCount(expandedObj) > 0) {
	                child = tModel.getChild(expandedObj, 0);
	                s.add(tp.pathByAddingChild(child));
	            } else {
	                s.add(tp);
	            }
	        }
	        
	        
            mExpandedMapperDestTreeNodes.put(selection, s);
	        
	    }

	}
	
	class TargetTreeSelectionListener implements TreeSelectionListener {
	    public void valueChanged(TreeSelectionEvent event) {

	        LOGGER.finer("On tree selection change");
	        XMLNode selection = getSelectedElement();
	        
	        if (selection == null) {
	            LOGGER.severe(" Selected Link Cannot be null while a "
	                         + "tree is being modified");
	            return;
	        }
	        
	        Set s = null;
        
            s = (Set) mExpandedMapperDestTreeNodes.get(selection);
	        
	        if (s == null) {
	            s = new HashSet();
	            // s = Collections.synchronizedSet(new HashSet());
	        }
	        s.add(event.getPath());
	        
	        
            mExpandedMapperDestTreeNodes.put(selection, s);
	        
	    }
	}
	
	class SourceTreeMouseListener extends MouseAdapter {
		    boolean isComponentInFocus = false;

            public void mouseEntered(MouseEvent evt) {
                isComponentInFocus = true;
                super.mouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                isComponentInFocus = false;
                super.mouseEntered(evt);
            }

            public void mousePressed(MouseEvent e) {
                maybeShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (!isComponentInFocus) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    JTree tree = (JTree) e.getComponent();
                    TreePath tp = tree.getSelectionPath();
                    // if selected treepath is null donot show the popup.
                    if (tp == null) {
                        return;
                    }
                    // if selected treepath is not null, then show the popup
                    // only if right click happens on the selected path
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    if (selRow == tree.getRowForPath(tp)) {
                        createPopUpMenu(tree).
                            show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        }
	*/
}
