/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.impl;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.Variable;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.xpath.model.node.visitor.XPathGeneratorVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.CanvasNode;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLiteralNode;
import org.netbeans.modules.bpel.xpath.view.BPELElementXPathExpressionBuilder;
import org.netbeans.modules.bpel.xpath.view.expression.IMappingModeConstants;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.xml.xpath.XPathStringLiteral;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class AssignXPathExpressionBuilder extends BPELElementXPathExpressionBuilder {
    
    private static final Logger LOGGER = Logger.getLogger(AssignXPathExpressionBuilder.class.getName());
    
    public AssignXPathExpressionBuilder(
            BpelEntity element,
            IBasicMapper mapper) {
        super(element,  mapper);
        if (!(element instanceof Assign)) {
            throw new IllegalArgumentException(
                    NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                        "STR_ELEMENT_SHOULD_BE_BPEL_ASSIGN_BUT_FOUND_X", // NOI18N
                        element));
        }
    }
    
    protected void addTreeMapping(IMapperTreeNode source, IMapperTreeNode target, IMapperLink link) {
        String mode = getSelectedMapMode();
        if (mode.compareTo(IMappingModeConstants.CONTAINERS) == 0) {
            processVariableMode(source, target, link);
        }
    }
    
    private void processVariableMode(
            IMapperTreeNode source, 
            IMapperTreeNode target, 
            IMapperLink link) {
        Assign assign = (Assign) getBPELElement();
        
        setSynchronizationListenerEnable(false);
        TreeNode sourceNode = (TreeNode) source.getPath().getLastPathComponent();
        TreeNode targetNode = (TreeNode) target.getPath().getLastPathComponent();
        if (sourceNode != null && targetNode != null) {
            connectTrees(source, target);
        }
        
        Copy c = getBPELDocument().getBuilder().createCopy();
        From f = getBPELDocument().getBuilder().createFrom();
        To t = getBPELDocument().getBuilder().createTo();
        
        if (sourceNode instanceof VariableNode) {
            VariableNode variableNode = (VariableNode) sourceNode;
            VariableDeclaration variableDeclaration = variableNode
                    .getVariableDeclaration();
            f.setVariable(f.createReference(variableDeclaration, 
                    VariableDeclaration.class));
        } else if (sourceNode instanceof PartNode) {
            PartNode partNode = (PartNode) sourceNode;
            Part part = partNode.getPart();
            VariableNode variableNode = (VariableNode) partNode.getParent();
            VariableDeclaration variableDeclaration = variableNode
                    .getVariableDeclaration();
            f.setVariable(f.createReference(variableDeclaration, 
                    VariableDeclaration.class));
            f.setPart(f.createWSDLReference(part, Part.class));
        } else {
            XPathGeneratorVisitor xGenerator = new XPathGeneratorVisitor(getBPELElement());
            sourceNode.accept(xGenerator);
            String expression = xGenerator.getXPath();
            try {
                f.setContent(expression);
                xGenerator.addNewPrefixToProcess();
            } catch (Exception ex) {
                LOGGER.log(Level.SEVERE,
                        NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                            "STR_FAILED_TO_SET_FROM_CONTENT_TO_X", // NOI18N
                            expression), ex);
            }
        }
        
        if (targetNode instanceof VariableNode) {
            VariableNode variableNode = (VariableNode) targetNode;
            VariableDeclaration variable = variableNode
                    .getVariableDeclaration();
            
            t.setVariable(t.createReference(variable, VariableDeclaration.class));
        } else if (targetNode instanceof PartNode) {
            PartNode partNode = (PartNode) targetNode;
            Part part = partNode.getPart();
            VariableNode variableNode = (VariableNode) partNode.getParent();
            VariableDeclaration variableDeclaration = variableNode
                    .getVariableDeclaration();
            t.setVariable(t.createReference(variableDeclaration, 
                    VariableDeclaration.class));
            t.setPart(t.createWSDLReference(part, Part.class));
        } else {
            XPathGeneratorVisitor xGenerator = new XPathGeneratorVisitor(getBPELElement());
            targetNode.accept(xGenerator);
            String expression = xGenerator.getXPath();
            xGenerator.addNewPrefixToProcess();
            try {
                t.setContent(expression);
            } catch (Exception ex) {
                LOGGER.log(Level.SEVERE,
                        NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                            "STR_FAILED_TO_SET_TO_CONTENT_TO_X",    // NOI18N
                            expression), ex);
            }
        }
        
        
        c.setFrom(f);
        c.setTo(t);
        assign.addAssignChild(c);
        link.setLinkObject(c);
        setSynchronizationListenerEnable(true);
    }
    
    protected void addFieldTreeMapping(IFieldNode srcNode, IMapperTreeNode target, IMapperLink link) {
        if (srcNode == null) {
            LOGGER.finer("addFieldTreeMapping - srcNode == NULL");   // NOI18N
            return;
        }
        if (target == null) {
            LOGGER.finer("addFieldTreeMapping - target == NULL");   // NOI18N
            return;
        }
        
        Assign assign = (Assign) getBPELElement();
        
        //CanvasNode sourceModelNode = MapperUtil.getFieldNodeObject(srcNode);
        CanvasNode sourceModelNode = (CanvasNode) srcNode.getNodeObject();
        TreeNode targetModelNode   = (TreeNode) target.getPath().getLastPathComponent();
        
        if (sourceModelNode != null && targetModelNode != null) {
            connectFieldToTree(srcNode, target);
        }
        
        Object ot[] = target.getPath().getPath();
        
        String mode = getSelectedMapMode();
        
        if (mode.compareTo(IMappingModeConstants.CONTAINERS) == 0) {
            setSynchronizationListenerEnable(false);
            Copy c = getBPELDocument().getBuilder().createCopy();
            From f = getBPELDocument().getBuilder().createFrom();
            Literal literal = null;
            Object litObj = sourceModelNode.getDataObject();            
            if ((litObj != null) && (litObj instanceof XPathStringLiteral)) {
                // create the literal tag per Bpel spec
                // <from><literal>hi</literal><from>
                literal = getBPELDocument().getBuilder().createLiteral();
                f.setFromChild(literal);
            }
            To t = getBPELDocument().getBuilder().createTo();
            
            //handle from
            XPathGeneratorVisitor xFromGenerator = new XPathGeneratorVisitor(getBPELElement());
            sourceModelNode.accept(xFromGenerator);
            String expression = xFromGenerator.getXPath();
            try {
                if ((litObj != null) && (litObj instanceof XPathStringLiteral)) {
                    if (literal != null) {
                        setContent(literal, expression);
                    }
                } else {
                    f.setContent(expression);
                } 
                xFromGenerator.addNewPrefixToProcess();
            } catch (Exception ex) {
                LOGGER.log(Level.SEVERE,
                        NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                            "STR_FAILED_TO_SET_FROM_CONTENT_TO_X",  // NOI18N
                            expression), ex);
            }
            
            //handle to
            if (targetModelNode instanceof VariableNode) {
                VariableNode variableNode = (VariableNode) targetModelNode;
                VariableDeclaration variableDeclaration = variableNode
                        .getVariableDeclaration();
                t.setVariable(t.createReference(variableDeclaration, 
                        VariableDeclaration.class));
            } else if (targetModelNode instanceof PartNode) {
                PartNode partNode = (PartNode) targetModelNode;
                Part part = partNode.getPart();
                t.setPart(t.createWSDLReference(part, Part.class));
                
                VariableNode variableNode = (VariableNode) partNode.getParent();
                VariableDeclaration variableDeclaration = variableNode
                        .getVariableDeclaration();
                t.setVariable(t.createReference(variableDeclaration, 
                        VariableDeclaration.class));
            } else {
                XPathGeneratorVisitor xToGenerator = new XPathGeneratorVisitor(getBPELElement());
                targetModelNode.accept(xToGenerator);
                String toExpression =  xToGenerator.getXPath();
                try {
                    t.setContent(toExpression);
                    xToGenerator.addNewPrefixToProcess();
                } catch (Exception ex) {
                    LOGGER.log(Level.SEVERE,
                            NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                                "STR_FAILED_TO_SET_FROM_CONTENT_TO_X",  // NOI18N
                                toExpression), ex);
                }
            }
            
            
            c.setFrom(f);
            c.setTo(t);
            assign.addAssignChild(c);
            link.setLinkObject(c);
            setSynchronizationListenerEnable(true);
        }
    }
    
    public void handleLinkCreationToNonTargetTreeNode(List links) {
        Iterator it = links.iterator();
        while(it.hasNext()) {
            IMapperLink link = (IMapperLink) it.next();
            Copy copy = (Copy) link.getLinkObject();
            if(copy != null && copy.getFrom() != null) {
                IMapperNode startNode = link.getStartNode();
                Node node = (Node) startNode.getNodeObject();
                if(node != null) {
                    XPathGeneratorVisitor xGenerator = new XPathGeneratorVisitor(getBPELElement());
                    node.accept(xGenerator);
                    String sourceExpression = xGenerator.getXPath();
                    From from = copy.getFrom();
                    try {
                        from.setContent(sourceExpression);
                        xGenerator.addNewPrefixToProcess();
                    } catch (Exception ex) {
                        LOGGER.log(Level.SEVERE,
                                NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                                    "STR_FAILED_TO_SET_FROM_CONTENT_TO_X",  // NOI18N
                                    sourceExpression), ex);
                    }
                }
            }
        }
    }
    
    public void handleLinkCreationToTargetTreeNode(
            List links,
            String sourceExpression,
            String targetExpression,
            Node targetTreeNode) {
        Iterator it = links.iterator();
        while(it.hasNext()) {
            IMapperLink link = (IMapperLink) it.next();
            Copy copy = getBPELDocument().getBuilder().createCopy();
            From from = getBPELDocument().getBuilder().createFrom();
            To to = getBPELDocument().getBuilder().createTo();
            try {
                from.setContent(sourceExpression);
                to.setContent(targetExpression);
            } catch (Exception ex) {
                LOGGER.log(Level.SEVERE,
                        NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                            "STR_FAILED_TO_SET_FROM_CONTENT_TO_X",  // NOI18N
                            sourceExpression) + "  "    // NOI18N
                        + NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                            "STR_FAILED_TO_SET_TO_CONTENT_TO_X",    // NOI18N
                            targetExpression), ex);
            }
            copy.setFrom(from);
            copy.setTo(to);
            Assign assign = (Assign) getBPELElement();
            assign.addAssignChild(copy);
            link.setLinkObject(copy);
        }
    }
     
    private void setContent(Literal literal, String content) {
        try {
            if (literal != null) {
                String modContent = removeQuotes(content);
                literal.setContent(modContent);
            }
        } catch (Exception ex) {
            LOGGER.log(Level.SEVERE,
                    NbBundle.getMessage(AssignXPathExpressionBuilder.class,
                        "STR_FAILED_TO_SET_FROM_CONTENT_TO_X", // NOI18N
                        content), ex);
        }        
    }
    
    private String removeQuotes(String expression) {
        String result = expression;
        if (expression != null) {            
            if ((expression.startsWith("'")) && (expression.endsWith("'"))
                    && (expression.length() > 1)) {
                StringBuffer buf = new StringBuffer(expression);
                buf.deleteCharAt(0);
                buf.deleteCharAt(buf.length() - 1);
                result = buf.toString();
            }
        }
        return result;
    }          
}
