/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.output;

import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.bpel.core.BPELDataEditorSupport;
import org.netbeans.modules.bpel.core.BPELDataObject;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * The Mapper Undo Manager, simply delegates to the BPEL Editor Undo Manager.
 * 
 * @author jsandusky
 */
public class MapperUndoRedo implements UndoRedo {
    
    private UndoRedo mDefaultUndoRedo;
    
    
    public MapperUndoRedo(UndoRedo defaultUndoRedo) {
        mDefaultUndoRedo = defaultUndoRedo;
    }
    
    private TopComponent getSelectedEditor() {
        Mode mode = WindowManager.getDefault().findMode(
                CloneableEditorSupport.EDITOR_MODE);
        if (mode != null) {
            return mode.getSelectedTopComponent();
        }
        return null;
    }
    
    public BPELDataEditorSupport getEditorSupport() {
        BpelModel model = ResultWindow.getInstance().getCurrentBpelModel();
        if (model != null) {
            TopComponent tc = getSelectedEditor();
            if (tc != null) {
                DataObject dataObject =
                        (DataObject) tc.getLookup().lookup(DataObject.class);
                if (dataObject instanceof BPELDataObject) {
                    BPELDataObject bpelDataObject = (BPELDataObject) dataObject;
                    return bpelDataObject.getEditorSupport();
                }
            }
        }
        return null;
    }
    
    public UndoRedo getDelegate() {
        UndoRedo delegate = null;
        
        BpelModel model = ResultWindow.getInstance().getCurrentBpelModel();
        if (model != null) {
            BPELDataEditorSupport editorSupport = getEditorSupport();
            if (editorSupport != null) {
                BpelModel iterModel = editorSupport.getBpelModel();
                if (model == iterModel) {
                    // Match, grab the undo manager.
                    delegate = editorSupport.getUndoManager();
                }
            }
        }
        if (delegate == null) {
            delegate = mDefaultUndoRedo;
        }
        
        return delegate;
    }
    
    public void addChangeListener(ChangeListener changeListener) {
        getDelegate().addChangeListener(changeListener);
    }
    
    public boolean canRedo() {
        return getDelegate().canRedo();
    }
    
    public boolean canUndo() {
        return getDelegate().canUndo();
    }
    
    public String getRedoPresentationName() {
        return "";
        // return getDelegate().getRedoPresentationName();
    }
    
    public String getUndoPresentationName() {
        return "";
        // return getDelegate().getUndoPresentationName();
    }
    
    public void redo() throws CannotRedoException {
        getDelegate().redo();
    }
    
    public void removeChangeListener(ChangeListener changeListener) {
        getDelegate().removeChangeListener(changeListener);
    }
    
    public void undo() throws CannotUndoException {
        getDelegate().undo();
    }
    
}
