/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.visitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bpel.model.api.BpelEntity;

import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.view.expression.impl.PredicatesManager;
import org.netbeans.modules.bpel.xpath.view.palette.IPaletteConstants;
import org.netbeans.modules.bpel.xpath.view.palette.XpathPaletteManager;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathLocationPath;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xml.xpath.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.function.extension.GetContainerDataFunction;
import org.netbeans.modules.xml.xpath.function.extension.visitor.AbstractXPathExtensionFunctionVisitor;

import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteItem;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.palette.IPaletteView;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class XPathExtensionFunctionNodeCreatorVisitor extends AbstractXPathExtensionFunctionVisitor {
    
    private static final Logger LOGGER = Logger.getLogger(XPathExtensionFunctionNodeCreatorVisitor.class.getName());
    
    private IMapperTreeView mMapperTreeView;
    private IBasicMapper mMapper;
    private PredicatesManager mPredicateManager;
    private IMapperTreeNode mMapperNode;
    private BpelEntity mHoldingEntity;
    
    public XPathExtensionFunctionNodeCreatorVisitor(IMapperTreeView mapperTreeView,
            IBasicMapper mapper,
            PredicatesManager predicatesManager,
            BpelEntity holdingEntity) {
        this.mMapperTreeView = mapperTreeView;
        this.mMapper = mapper;
        this.mPredicateManager = predicatesManager;
        this.mHoldingEntity = holdingEntity;
    }
    
    
    public IMapperTreeNode getMapperNode() {
        return this.mMapperNode;
    }
    
    public void visit(GetContainerDataFunction function) {
        //as documented above, the number of children should be 3.
        String variableName = null;
        if (function.getChildCount() > 0) {
            variableName = ((XPathStringLiteral) function.getChild(0)).getValue();
        }
        String partName = null;
        if (function.getChildCount() > 1) {
            partName = ((XPathStringLiteral) function.getChild(1)).getValue();
        }
        String query = null;
        if (function.getChildCount() > 2) {
            query = ((XPathStringLiteral) function.getChild(2)).getValue();
        }
        
        VariableNode variableNode = MapperTreeUtility.findVariable(
                variableName, 
                this.mMapperTreeView.getTree().getModel());
        
        if (variableNode != null) {
            
            PartNode partNode = variableNode.getPartNode(partName);
            if (query != null && !query.equals("")) {
                if (partNode == null) {
                    LOGGER.warning(NbBundle.getMessage(
                            XPathExtensionFunctionNodeCreatorVisitor.class,
                            "STR_ERROR_IN_PARSING_THE_QUERY_X_PART_IS_NULL_BUT_QUERY_EXISTS",   // NOI18N
                            query));
                }
                if (query.indexOf('[') >= 0 || query.indexOf(']') >= 0) {
                    LOGGER.finer(NbBundle.getMessage(
                            XPathExtensionFunctionNodeCreatorVisitor.class,
                            "STR_QUERY_BEFORE_REPLACE_EQUALS_X", query));   // NOI18N
                        query = processPredicateQuery(query);
                    LOGGER.finer(NbBundle.getMessage(
                            XPathExtensionFunctionNodeCreatorVisitor.class,
                            "STR_QUERY_AFTER_REPLACE_EQUALS_X", query));    // NOI18N
                }
                XPathModel xp = AbstractXPathModelHelper.getInstance().newXPathModel();
                XPathExpression xpExpr = null;
                try {
                    xpExpr = xp.parseExpression(query);
                } catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    // this means we cannot parse the query
                    return;
                }
                if (!(xpExpr instanceof XPathLocationPath)) {
                    LOGGER.log(Level.WARNING, NbBundle.getMessage(
                            XPathExtensionFunctionNodeCreatorVisitor.class,
                            "STR_ERROR_IN_PARSING_QUERY_X", // NOI18N
                            query));
                        return;
                }

                XPathLocationPath locationPath = (XPathLocationPath) xpExpr;

                FindMapperTreeNodeVisitor fmtnVisitor =
                        new FindMapperTreeNodeVisitor(this.mMapperTreeView,
                        this.mPredicateManager,
                        variableNode,
                        partNode,
                        this.mHoldingEntity);

                locationPath.accept(fmtnVisitor);

                this.mMapperNode = fmtnVisitor.getMapperTreeNode();

                if (this.mMapperNode == null) {
                    LOGGER.finer(NbBundle.getMessage(
                            XPathExtensionFunctionNodeCreatorVisitor.class,
                            "STR_MAPPER_SOURCE_TREE_NODE_DOES_NOT_CONTAIN_EXPRESSION"));    // NOI18N)
                }
            }
        }
    }
    
    private static String processPredicateQuery(String query) {
        StringBuffer sb = new StringBuffer();
        char[] arr = query.toCharArray();
        int i = 0, length = arr.length;
        int count = 0;
        while (i < length) {
            char ch = arr[i];
            if (ch == '[') {
                count++;
            }
            if (ch == ']') {
                count--;
            }
            boolean found = false;
            while (ch == '\'') {
                i++;
                found = true;
                ch = arr[i];
            }
            if (found) {
                for (int j = 0; j < count; j++) {
                    sb.append('\'');
                }
                continue;
            }
            sb.append(ch);
            i++;
        }
        return sb.toString();
    }
    
    private IMapperNode addFromNode(XPathOperationOrFuntion expr) {
        
        // add the functoid. for the bpws:getContainerData() or predicate
        IPaletteView pView = null;
        IMethoid methoid = null;
        IPaletteItem pItem = null;
        IMethoidNode mNode = null;
        pItem = XpathPaletteManager.getDefault().getItemByMethodName(IPaletteConstants.COPY_FROM);
        pView = this.mMapper.getMapperViewManager().getPaletteView();
        
        Object[] childArray = expr.getChildren().toArray();
        //Collection children = xpExpr.getChildren();
        if (childArray.length < 1 || childArray.length > 3) {
            LOGGER.severe(NbBundle.getMessage(
                    XPathExtensionFunctionNodeCreatorVisitor.class,
                    "STR_ILL_FORMED_EXPRESSION"));  // NOI18N
        }
        IMapperNode srcNode = null;
        String containerName = null;
        String partName = null;
        String query = null;
        String name = "";
        
        if (childArray.length > 0) {
            containerName = ((XPathStringLiteral) childArray[0]).getExpressionString();
            containerName = containerName.substring(1, containerName.length() - 1);
            name += containerName;
        }
        if (childArray.length > 1) {
            partName = ((XPathStringLiteral) childArray[1]).getExpressionString();
            partName = partName.substring(1, partName.length() - 1);
            name += "/" + partName;
        }
        if (childArray.length > 2) {
            query = ((XPathStringLiteral) childArray[2]).getExpressionString();
            query = query.substring(1, query.length() - 1);
            name += "/" + query;
        }
        methoid = (IMethoid) pView.findPaletteViewItem(pItem).getTransferableObject();
        mNode = this.mMapper.createMethoidNode(methoid);
        IFieldNode fOutNode = (IFieldNode) mNode.getOutputFieldNodes().get(0);
        fOutNode.setName(name);
        fOutNode.setNodeObject(expr);
        
        return mNode;
    }
    
}
