/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.mashup.db.bootstrap;

import java.util.List;

import org.netbeans.modules.mashup.db.common.FlatfileDBException;
import org.netbeans.modules.mashup.db.model.FlatfileDBTable;


/**
 * Simple interface defining a parser to be used by the Flatfile Database wizard to obtain
 * an initial set of FlatfileField instances to present to the user in the record layout
 * configuration panel.
 * 
 * @author Jonathan Giron
 * @author Ahimanikya Satapathy
 * @version $Revision: 1.2 $
 */
public interface FlatfileBootstrapParser {

    /**
     * Gets List of FlatfileDBColumn instances which are derived from the parse properties
     * of the currently associated ParseConfigurator and the given Flatfile instance.
     * 
     * @param table FlatfileDBTable whose contents will be parsed.
     * @return List of FlatfileDBColumn instances synthesized from the contents of
     *         <code>file</code> and parameters contained in the current FlatfileDBTable
     * @throws FlatfileDBException if error occurs during retrieval
     */
    public List buildFlatfileDBColumns(FlatfileDBTable table) throws FlatfileDBException;

    /**
     * Based on the given file guess the record length and other properties
     * 
     * @param table
     * @throws FlatfileDBException
     */
    public void makeGuess(FlatfileDBTable table) throws FlatfileDBException;

    /**
     * Is this file format acceptable by this parser
     * 
     * @param table
     * @return
     * @throws FlatfileDBException
     */
    public boolean acceptable(FlatfileDBTable table) throws FlatfileDBException;
}
