/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.evaluators.database.base;

import java.util.HashMap;
import java.util.Map;

import org.netbeans.modules.sql.framework.evaluators.database.AbstractDB;
import org.netbeans.modules.sql.framework.evaluators.database.AbstractEvaluatorFactory;
import org.netbeans.modules.sql.framework.model.SQLConstants;


/**
 * @author Ritesh Adval
 * @version $Revision: 1.2 $
 */
public class BaseEvaluatorFactory extends AbstractEvaluatorFactory {

    public BaseEvaluatorFactory(AbstractDB database) {
        super(database);
    }

    public Map initializeObjectToEvaluatorMap() {
        HashMap map = new HashMap();
        map.put(new Integer(SQLConstants.SOURCE_COLUMN), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseColumnEvaluator");
        map.put(new Integer(SQLConstants.TARGET_COLUMN), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseColumnEvaluator");
        map.put(new Integer(SQLConstants.COLUMN_REF), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseConditionColumnEvaluator");
        map.put(new Integer(SQLConstants.SOURCE_TABLE), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseSourceTableEvaluator");
        map.put(new Integer(SQLConstants.TARGET_TABLE), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseTargetTableEvaluator");
        map.put(new Integer(SQLConstants.JOIN), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseJoinEvaluator");
        map.put(new Integer(SQLConstants.VISIBLE_PREDICATE), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseOperatorEvaluator");
        map.put(new Integer(SQLConstants.PREDICATE), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseOperatorEvaluator");
        map.put(new Integer(SQLConstants.VISIBLE_LITERAL), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseLiteralEvaluator");
        map.put(new Integer(SQLConstants.LITERAL), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseLiteralEvaluator");
        map.put(new Integer(SQLConstants.GENERIC_OPERATOR), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseOperatorEvaluator");
        map.put(new Integer(SQLConstants.CUSTOM_OPERATOR), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseOperatorEvaluator");        
        map.put(new Integer(SQLConstants.DATE_ARITHMETIC_OPERATOR), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseOperatorEvaluator");
        map.put(new Integer(SQLConstants.CASE), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseCaseEvaluator");
        map.put(new Integer(SQLConstants.DATE_ADD_OPERATOR), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseDateArithmeticOperatorEvaluator");
        map.put(new Integer(SQLConstants.DATE_DIFF_OPERATOR), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseDateArithmeticOperatorEvaluator");
        map.put(new Integer(SQLConstants.CAST_OPERATOR), "org.netbeans.modules.sql.framework.evaluators.database.base.BaseCastAsOperatorEvaluator");
        return map;
    }
}
