/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.iep.editor.model;

import java.util.ArrayList;
import java.util.List;

import org.netbeans.modules.iep.editor.tcg.model.TcgComponent;
import org.netbeans.modules.iep.editor.tcg.model.TcgComponentType;
import org.netbeans.modules.iep.editor.tcg.model.TcgModelManager;


/**
 * Interface that extends Component
 *
 * @author Bing Lu
 *
 * @since July 8, 2004
 */
class SchemaImpl extends ModelImpl implements Schema {
    /**
     *  Logger.
     */
    private static final java.util.logging.Logger mLog = java.util.logging.Logger.getLogger(SchemaImpl.class.getName());
    
    private final static TcgComponentType mColumnMetadataType = 
        TcgModelManager.getTcgComponentType(COLUMN_METADATA_PATH);
    
    private final static TcgComponentType mSchmeaType = 
        TcgModelManager.getTcgComponentType(SCHEMA_PATH);
    
    SchemaImpl(String name) {
        initialize(mSchmeaType.newTcgComponent(name, mSchmeaType.getTitle()));
    }
    
    protected SchemaImpl(TcgComponent root) {
        initialize(root);
    }

    public int getAttributeCount() throws Exception {
        return mComponent.getComponentCount();
    }
    
    public AttributeMetadata getAttributeMetadata(int i) throws Exception {
        TcgComponent c = mComponent.getComponent(i);
        return new AttributeMetadataImpl(c);
    }

    public List getAttributeMetadataAsList() throws Exception {
        List list = new ArrayList();
        List componentList = mComponent.getComponentList();
        for (int i = 0, I = componentList.size(); i < I; i++) {
            TcgComponent c = (TcgComponent)componentList.get(i);
            list.add(c.getProperty(NAME_KEY).getStringValue());
            list.add(c.getProperty(TYPE_KEY).getStringValue());
            list.add(c.getProperty(SIZE_KEY).getStringValue());
            list.add(c.getProperty(SCALE_KEY).getStringValue());
            list.add(c.getProperty(COMMENT_KEY).getStringValue());
        }
        return list;
    }

    public void setAttributeMetadataAsList(List columns) throws Exception {
        mComponent.clear();
        for (int i = 0, I = columns.size(); i < I; i+=5) {
            String name = (String)columns.get(i);
            TcgComponent c = mColumnMetadataType.newTcgComponent(name, name);
            c.getProperty(NAME_KEY).setStringValue(name);
            
            String type = (String)columns.get(i + 1);
            c.getProperty(TYPE_KEY).setStringValue(type);
            
            String size = (String)columns.get(i + 2);
            if (size != null && !size.equals("")) {
                c.getProperty(SIZE_KEY).setStringValue(size);
            }
            String scale = (String)columns.get(i + 3);
            if (scale != null && !scale.equals("")) {
                c.getProperty(SCALE_KEY).setStringValue(scale);
            }
            String comment = (String)columns.get(i + 4);
            if (comment != null && !comment.equals("")) {
                c.getProperty(COMMENT_KEY).setStringValue(comment);
            }
            mComponent.addComponent(c);
        }
    }
    
    public boolean hasSameAttributeMetadata(List columns) throws Exception {
        List componentList = mComponent.getComponentList();
        if ((5*componentList.size()) != columns.size()) {
            return false;
        }
        for (int i = 0, I = columns.size(),j = 0, J = componentList.size(); 
             i < I && j < J; i+=5, j++) 
        {
            TcgComponent c = (TcgComponent)componentList.get(j);
            String name = (String)columns.get(i);
            if (!c.getProperty(NAME_KEY).getStringValue().equals(name)) {
                return false;
            }

            String type = (String)columns.get(i + 1);
            if (!c.getProperty(TYPE_KEY).getStringValue().equals(type)) {
                return false;
            }

            String size = (String)columns.get(i + 2);
            if (!c.getProperty(SIZE_KEY).getStringValue().equals(size)) {
                return false;
            }

            String scale = (String)columns.get(i + 3);
            if (!c.getProperty(SCALE_KEY).getStringValue().equals(scale)) {
                return false;
            }
            String comment = (String)columns.get(i + 4);
            if (!c.getProperty(COMMENT_KEY).getStringValue().equals(comment)) {
                return false;
            }
        }
        return true;
    }
        
    public Schema duplicateSchema(String name) {
        TcgComponent component = mComponent.duplicate(name);
        component.setTitle(name);
        return new SchemaImpl(component);
    }
    
    
}    
