/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package org.netbeans.modules.aspect.editor.graph;

import org.netbeans.modules.aspect.editor.graph.panels.AddOutputPanel;
import org.netbeans.modules.aspect.editor.graph.panels.ConfigureEndpointFromWSDLPanel;
import org.netbeans.modules.aspect.editor.graph.panels.EditIOPropertiesPanel;
import org.netbeans.modules.aspect.editor.model.Advice;
import org.netbeans.modules.aspect.editor.model.Aspect;
import org.netbeans.modules.aspect.editor.model.Input;
import org.netbeans.modules.aspect.editor.model.Output;
import org.netbeans.modules.aspect.editor.model.Util;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectType;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 *
 * @author karthikeyan s
 */
public class InputPopupProvider implements PopupMenuProvider {
    
    private AspectEditorPane owner;
    /**
     * Creates a new instance of InputPopupProvider
     */
    public InputPopupProvider(AspectEditorPane pane) {
        owner = pane;
    }
    
    public JPopupMenu getPopupMenu(final Widget widget, Point point) {
        JPopupMenu popupMenu = new JPopupMenu("InputPopup");
        JMenuItem edit = new JMenuItem("Edit Input Properties");
        edit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                EditIOPropertiesPanel panel = new EditIOPropertiesPanel();
                //panel.setProperties(owner.getCurrentAspect().getInput()); JAXB
                panel.setProperties(AspectMapBuilder.getAspectMapBuilder().getInput(owner.getCurrentAspect()));
                DialogDescriptor dd = new DialogDescriptor(panel, "Edit Input");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    owner.setInputProperties(panel.getPartnerLink(), panel.getRoleName(),
                            panel.getPortType(), panel.getMessageType(), panel.getOperation());
                }                 
            }
        });
        popupMenu.add(edit);
        
        

        
        JMenuItem inputWsdl = new JMenuItem("Configure from WSDL");
        inputWsdl.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                boolean error = true;
                //Aspect aspect = null; //JAXB
                AspectType aspect = null;
                ConfigureEndpointFromWSDLPanel panel = new ConfigureEndpointFromWSDLPanel(owner.getDataObject().getPrimaryFile().getPath());
                DialogDescriptor dd = new DialogDescriptor(panel, "Configure from WSDL");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    File file = panel.getSelectedFile();
                    try {
                        if(file == null) throw new Exception("No file received");
                        
                        if(!file.exists()) {
                           throw new Exception("No such file exist: " + file.getAbsolutePath());
                            
                        }
                        
                      
                        
                        aspect = setInput(owner.getCurrentAspect(), file);
                        error = false;
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if(error) {
                        DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(
                                "Failed to import wsdl", NotifyDescriptor.INFORMATION_MESSAGE));
                    } else {
                        owner.setCurrentAspect(aspect);
                    }
                }
            }
        });
        
        popupMenu.add(inputWsdl);
        
        return popupMenu;
    }
    
    
    

	//private Aspect setInput(Aspect aspect, File file) { //JAXB\
        private AspectType setInput(AspectType aspect, File file) {
        try {
        	URL u = null;
        	try {
				 u = new URL("file://" + file.getAbsolutePath());
			} catch (MalformedURLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
        	

        	
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            Definition defn = reader.readWSDL(u.getFile());
            
            //get the first message Type.
            Iterator it = defn.getMessages().keySet().iterator();
            String messageType = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                messageType = ((Message) defn.getMessages().get(qName)).getQName().toString();
                break;
            }
            
            // get the first portType
            it = defn.getPortTypes().keySet().iterator();
            String portType = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                portType = ((PortType) defn.getPortTypes().get(qName)).getQName().toString();
                break;
            }
            
            // get the first operation
            it = defn.getBindings().keySet().iterator();
            String operation = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                Binding binding = ((Binding) defn.getBindings().get(qName));
                operation = ((BindingOperation)binding.getBindingOperations().get(0)).
                        getOperation().getName();
                break;
            }
            
            String nmspace = "http://docs.oasis-open.org/wsbpel/2.0/plnktype";
            String nm = null;
            it = defn.getNamespaces().keySet().iterator();
            while(it.hasNext()) {
                String key = (String)it.next();
                if(defn.getNamespace(key).equals(nmspace)) {
                    nm = key;
                    break;
                }
            }
            // get the first service name
            String serviceName = "";
            String roleName = "";
            it = defn.getExtensibilityElements().iterator();
            while(it.hasNext()) {
                UnknownExtensibilityElement extnElem = (UnknownExtensibilityElement)it.next();
                if(extnElem.getElement().getNodeName().equalsIgnoreCase(nm +
                        ":partnerLinkType")) {
                    serviceName = "{"+defn.getTargetNamespace()+"}"+extnElem.getElement().getAttribute("name");
                    NodeList roleNames = extnElem.getElement().getElementsByTagName("*");
                    for(int i = 0; i < roleNames.getLength(); i++) {
                        if(roleNames.item(i).getNodeType() == Element.ELEMENT_NODE) {
                            Element roleNameElem = (Element) roleNames.item(i);
                            if(roleNameElem.getNodeName().equals( nm + ":role")) {
                                roleName = roleNameElem.getAttribute("name");
                                break;
                            }
                        }
                    }
                }
            }
            //Input in = new Input( serviceName, roleName, portType, operation, messageType); JAXB            
            
            //aspect.setInput(in); JAXB
            //Default Input must be deleted before input from the WSDL is Set
            AspectMapBuilder.getAspectMapBuilder().deleteExistingInput(aspect);
            AspectMapBuilder.getAspectMapBuilder().addNewInput(aspect, serviceName, roleName, portType, operation, messageType);
        } catch (WSDLException ex) {
            ex.printStackTrace();
        }
        return aspect;
    }

    
}