/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html
 
 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */
package org.netbeans.modules.aspect.editor.graph;

import org.netbeans.modules.aspect.editor.graph.panels.AddAdvicePanel;
import org.netbeans.modules.aspect.editor.graph.panels.AddAspectPanel;
import org.netbeans.modules.aspect.editor.graph.panels.AddOutputPanel;
import org.netbeans.modules.aspect.editor.graph.panels.EditAspectTypePanel;
import org.netbeans.modules.aspect.editor.graph.panels.EditChainPanel;
import org.netbeans.modules.aspect.editor.model.Advice;
import org.netbeans.modules.aspect.editor.model.Aspect;
import org.netbeans.modules.aspect.editor.model.AspectMap;
import org.netbeans.modules.aspect.editor.model.Output;
import org.netbeans.modules.aspect.editor.model.Util;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;

import java.awt.Dialog;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.netbeans.modules.aspect.editor.jaxbmodel.AdviceType;
import org.netbeans.modules.aspect.editor.jaxbmodel.AspectType;
import org.netbeans.modules.aspect.editor.mapbuilder.AspectMapBuilder;
import org.netbeans.modules.aspect.editor.jaxbutils.Utiltools;
import org.openide.DialogDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
/**
 * PopupMenu provider for the Graph Scene
 * @author karthikeyan s
 */
public class ScenePopupProvider implements PopupMenuProvider {
    
    private AspectEditorPane owner;
    
    public ScenePopupProvider(AspectEditorPane pane) {
        owner = pane;
    }
    
    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        JPopupMenu popupMenu = new JPopupMenu("ScenePopup");
        JMenuItem configure = new JMenuItem("Choose Aspect");
        configure.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                //List<Aspect> aspects = owner.getAspects(); JAXB
                List<AspectType> aspects = owner.getAspects();
                List<String> aspectIDs = new ArrayList<String>();
                Iterator it = aspects.iterator();
                while(it.hasNext()) {
                    //Aspect asp = (Aspect)it.next(); JAXB
                    AspectType asp = (AspectType)it.next();
                    aspectIDs.add(asp.getID());
                }
                Object[] data = aspectIDs.toArray();
                String s = (String)JOptionPane.showInputDialog(
                        null,
                        "Choose an Aspect to display",
                        "Choose an Aspect",
                        JOptionPane.PLAIN_MESSAGE,
                        null,
                        data,
                        data[0]);
                if(s != null && !s.equals("") && !s.equals(owner.getCurrentAspect().getID())) {
                    owner.setAspect(s);
                }
            }
        });
        popupMenu.add(configure);
        
        JMenuItem set = new JMenuItem("Choose Exchange Type");
        set.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                EditAspectTypePanel panel = new EditAspectTypePanel();
                DialogDescriptor dd = new DialogDescriptor(panel, "Choose Exchange Type");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    //owner.getCurrentAspect().setExchangeType(panel.getSelected()); JAXB
                    owner.getCurrentAspect().setExchangeType(Utiltools.getAspectTypes(panel.getSelected()));
                }
            }
        });
        popupMenu.add(set);
        
        JMenuItem addAspect = new JMenuItem("Add Aspect");
        addAspect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AddAspectPanel panel = new AddAspectPanel();
                DialogDescriptor dd = new DialogDescriptor(panel, "Add aspect");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    owner.createNewAspect(panel.getAspectType());
                }
            }
        });
        popupMenu.add(addAspect);
        
        /* This has been supported from the palette
        JMenuItem add = new JMenuItem("Add Advice");
        add.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AddAdvicePanel panel = new AddAdvicePanel();
                //panel.populateComboBox(owner.getCurrentAspect().getAdvices()); JAXB
                panel.populateComboBox(AspectMapBuilder.getAspectMapBuilder().getAdviceList(owner.getCurrentAspect()));
                DialogDescriptor dd = new DialogDescriptor(panel, "Add advice");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    String adviceType = panel.getAdviceType();
                    Object obj = panel.getInsertAfter();
                    //if(obj instanceof Advice) { JAXB
                    if(obj instanceof AdviceType) {
                        //owner.insertAfterAdvice((Advice)obj, adviceType); JAXB
                        owner.insertAfterAdvice((AdviceType)obj, adviceType);
                    } else {
                        owner.insertAfterInput(adviceType);
                    }
                }
            }
        });
        popupMenu.add(add);
        */
        
        JMenuItem addOutput = new JMenuItem("Add Output");
        addOutput.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                boolean error = true;
                //Aspect aspect = null; //JAXB
                AspectType aspect = null;
                AddOutputPanel panel = new AddOutputPanel();
                DialogDescriptor dd = new DialogDescriptor(panel, "Add Output WSDL");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    File file = panel.getSelectedFile();
                    try {
                        if(file == null) throw new Exception("No file received");
                        String dir = owner.getDataObject().getPrimaryFile().getParent().getPath();
                        File newFile = new File(dir, file.getName());
                        if(newFile.exists()) {
                            newFile.delete();
                        }
                        newFile.createNewFile();
                        FileInputStream in  = new FileInputStream(file);
                        FileOutputStream out = new FileOutputStream(newFile);
                        byte[] buf = new byte[1024];
                        int i = 0;
                        while((i=in.read(buf))!=-1) {
                            out.write(buf, 0, i);
                        }
                        in.close();
                        out.close();
                        
                        //aspect = addOutput(owner.getCurrentAspect(), file.getAbsolutePath()); JAXB
                        aspect = addOutput(owner.getCurrentAspect(), file.getAbsolutePath());
                        error = false;
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if(error) {
                        DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(
                                "Failed to import wsdl", NotifyDescriptor.INFORMATION_MESSAGE));
                    } else {
                        owner.setCurrentAspect(aspect);
                    }
                }
            }
        });
        popupMenu.add(addOutput);
        
        JMenuItem chain = new JMenuItem("Edit Advice Chain");
        chain.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                EditChainPanel panel = new EditChainPanel();
                //panel.populateAdviceChain(Util.getSortedAdviceList(owner.getCurrentAspect().getAdvices())); //JAXB
                panel.populateAdviceChain(Utiltools.getSortedAdviceList(AspectMapBuilder.getAspectMapBuilder().getAdviceList(owner.getCurrentAspect())));
                DialogDescriptor dd = new DialogDescriptor(panel, "Edit Advice Chain");
                Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                dlg.setVisible(true);
                if (NotifyDescriptor.OK_OPTION.equals(dd.getValue())) {
                    //List<Advice> list = panel.getAdviceChain(); JAXB
                    List<AdviceType> list = panel.getAdviceChain();
                    //owner.setNewAdviceChain(list); JAXB --Need Basis
                }
            }
        });
        popupMenu.add(chain);
        
        JMenuItem layout = new JMenuItem("Layout Graph");
        layout.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                owner.layoutGraph();
            }
        });
        popupMenu.add(layout);
        return popupMenu;
    }
    
    //private Aspect addOutput(Aspect aspect, String wsdlContent) { //JAXB
    private AspectType addOutput(AspectType aspect, String wsdlContent) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            Definition defn = reader.readWSDL(wsdlContent);
            
            //get the first message Type.
            Iterator it = defn.getMessages().keySet().iterator();
            String messageType = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                messageType = ((Message) defn.getMessages().get(qName)).getQName().toString();
                break;
            }
            
            // get the first portType
            it = defn.getPortTypes().keySet().iterator();
            String portType = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                portType = ((PortType) defn.getPortTypes().get(qName)).getQName().toString();
                break;
            }
            
            // get the first operation
            it = defn.getBindings().keySet().iterator();
            String operation = "";
            while(it.hasNext()) {
                QName qName = (QName)it.next();
                Binding binding = ((Binding) defn.getBindings().get(qName));
                operation = ((BindingOperation)binding.getBindingOperations().get(0)).
                        getOperation().getName();
                break;
            }
            
            String nmspace = "http://docs.oasis-open.org/wsbpel/2.0/plnktype";
            String nm = null;
            it = defn.getNamespaces().keySet().iterator();
            while(it.hasNext()) {
                String key = (String)it.next();
                if(defn.getNamespace(key).equals(nmspace)) {
                    nm = key;
                    break;
                }
            }
            // get the first service name
            String serviceName = "";
            QName serviceName1 = null;
            String roleName = "";
            it = defn.getExtensibilityElements().iterator();
            while(it.hasNext()) {
                UnknownExtensibilityElement extnElem = (UnknownExtensibilityElement)it.next();
                if(extnElem.getElement().getNodeName().equalsIgnoreCase(nm +":partnerLinkType")) {
                    //serviceName = extnElem.getElement().getAttribute("name"); JAXB
                    serviceName = "{" + defn.getNamespace(nm) + "}" + extnElem.getElement().getAttribute("name");
                    NodeList roleNames = extnElem.getElement().getElementsByTagName("*");
                    for(int i = 0; i < roleNames.getLength(); i++) {
                        if(roleNames.item(i).getNodeType() == Element.ELEMENT_NODE) {
                            Element roleNameElem = (Element) roleNames.item(i);
                            if(roleNameElem.getNodeName().equals( nm + ":role")) {
                                roleName = roleNameElem.getAttribute("name");
                                break;
                            }
                        }
                    }
                }
            }
            
            //Output out = new Output(null, null, serviceName, roleName, portType, operation, messageType, "1"); JAXB
            //Util.makeSpaceforDefaultOutput(aspect); JAXB
            Utiltools.makeSpaceforDefaultOutput(aspect);
            //aspect.addOutput(out); - JAXB May not be needed
            AspectMapBuilder.getAspectMapBuilder().createAndAddOutput(aspect, serviceName, roleName, portType, operation, messageType, "1");
        } catch (WSDLException ex) {
            ex.printStackTrace();
        }
        return aspect;
    }
}
