/*
 * AspectMapBuilder.java
 *
 * Created on May 29, 2007, 3:40:53 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.aspect.editor.mapbuilder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.aspect.editor.jaxbmodel.*;
import org.netbeans.modules.aspect.editor.jaxbutils.AspectConstants;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * This is a singleton handler class that constructs the AspectMap data object out of editor actions.
 * It contains methods for adding/editing aspect map tags and structures.
 * @author Manish Bharani
 */
public class AspectMapBuilder {
    
    private static AspectMapBuilder aspectmapbuilder = null;
    private File aspectMapFileObj = null;
    private javax.xml.bind.Unmarshaller unmarshaller = null;
    private javax.xml.bind.Marshaller marshaller = null;
    ObjectFactory aspectRootObjFactory = null;
    private JAXBElement aspectRootType = null;
    private StringBuffer aspectmapstr = new StringBuffer();
    // Temporary, needs to change later
    private Hashtable<String, File> adviceConfigFileTable = new Hashtable<String, File>();
    Properties properties = new Properties();
    // Temporary, needs to change later
    private Hashtable<String, HashMap> advicePropertiesTable = new Hashtable<String, HashMap>();
    // Needed for Working - Previous Design
    HashMap<AspectType, OutputType> currentOutputMap = new HashMap();
    //Env
    static String home = System.getProperty("user.dir");
    static String fs = System.getProperty("file.separator");
    
    private AspectMapBuilder(File aspectmapFromDObj) {
        this.aspectMapFileObj = aspectmapFromDObj;
        this.initMapBuilder();
    }
    
    public static AspectMapBuilder getAspectMapBuilder(File aspectmapFromDObj) {
        if (aspectmapbuilder == null) {
            aspectmapbuilder = new AspectMapBuilder(aspectmapFromDObj);
        }
        return aspectmapbuilder;
    }
    
    public static AspectMapBuilder getAspectMapBuilder() {
        return aspectmapbuilder;
    }
    
    
    private void initMapBuilder(){
        try {
            javax.xml.bind.JAXBContext jc = javax.xml.bind.JAXBContext.newInstance(Class.forName("org.netbeans.modules.aspect.editor.jaxbmodel.ObjectFactory"));
            this.unmarshaller = jc.createUnmarshaller();
            this.marshaller = jc.createMarshaller();
            this.aspectRootObjFactory = new org.netbeans.modules.aspect.editor.jaxbmodel.ObjectFactory();
        }catch (JAXBException ex1) {
            ex1.printStackTrace();
        }catch (ClassNotFoundException ex2){
            ex2.printStackTrace();
        }catch (Exception ex3){
            ex3.printStackTrace();
        }
        
        //Create
        
        // Create Skeleton for the Blank AspectMap
        //createAspectSkeletonObj();
    }
    
    private void createAspectSkeletonObj() {
        try {
            aspectRootObjFactory = new org.netbeans.modules.aspect.editor.jaxbmodel.ObjectFactory();
            AspectmapType aspectmaptype = new org.netbeans.modules.aspect.editor.jaxbmodel.AspectmapType();
            AspectType aspecttype = new org.netbeans.modules.aspect.editor.jaxbmodel.AspectType();
            aspectmaptype.getAspect().add(aspecttype);
            this.aspectRootType = aspectRootObjFactory.createAspectmap(aspectmaptype);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public List<AspectType> getAspectList() {
        return getroot().getAspect();
    }
    
    public List<AdviceType> getAdviceList(AspectType aspecttype) {
        List<AdviceType> adviceTypeList = null;
        List<Serializable> advicelist = aspecttype.getContent();
        if ((advicelist != null) && (advicelist.size()) != 0) {
            adviceTypeList = new ArrayList();
            Iterator it = advicelist.iterator();
            while(it.hasNext()) {
                Object tempObj = it.next();
                if (!(tempObj instanceof java.lang.String)) {
                    JAXBElement listelement = (JAXBElement)tempObj;
                    if ((listelement.getName().getLocalPart().equals("advice"))) {
                        adviceTypeList.add((AdviceType)listelement.getValue());
                    }
                }
            }
        }
        return adviceTypeList;
    }
    
    public int getAdviceListSize(AspectType aspecttype) {
        int adviceTypeListSize = 0;
        List<Serializable> aspectelmlist = aspecttype.getContent();
        if ((aspectelmlist != null) && (aspectelmlist.size()) != 0) {
            Iterator it = aspectelmlist.iterator();
            while(it.hasNext()) {
                Object tempObj = it.next();
                if (!(tempObj instanceof java.lang.String)) {
                    JAXBElement listelement = (JAXBElement)tempObj;
                    if ((listelement.getName().getLocalPart().equals("advice"))) {
                        adviceTypeListSize++;
                    }
                }
            }
        }
        return adviceTypeListSize;
    }    
    
    public void removeAdvice(AspectType aspecttype, AdviceType advicetype) {
        Iterator it = aspecttype.getContent().iterator();
        while(it.hasNext()) {
            JAXBElement element = (JAXBElement)it.next();
            if ((element.getName().getLocalPart().equals("advice"))) {
                if (advicetype.equals((AdviceType)element.getValue())) {
                    it.remove();
                }
            }
        }
    }
    
    public void replaceAdvice(AdviceType advicetype) {
        for (int j=0; j<getroot().getAspect().size(); j++) {
            for (int i=0; i < getroot().getAspect().get(j).getContent().size(); i++) {
                JAXBElement element = (JAXBElement)getroot().getAspect().get(j).getContent().get(i);
                if ((element.getName().getLocalPart().equals("advice"))) {
                    if (advicetype.equals((AdviceType)element.getValue())) {
                        getroot().getAspect().get(j).getContent().remove(i);
                        getroot().getAspect().get(j).getContent().add(i, this.aspectRootObjFactory.createAspectTypeAdvice(advicetype));
                    }
                }
            }
        }
    }
    
    public InputType getInput(AspectType aspecttype) {
        InputType inputtype  = null;
        Iterator it = aspecttype.getContent().iterator();
        while(it.hasNext()) {
            JAXBElement element = (JAXBElement)it.next();
            if ((element.getName().getLocalPart().equals("input"))) {
                inputtype =  (InputType)element.getValue();
                break;
            }
        }
        return inputtype;
    }
    
    private void addNewDefaultInput(AspectType aspecttype) {
        InputType in = new InputType();
        in.setMessageType("{http://com.sun.jbi/aspect/aspect}inputMsg");
        in.setOperation("aspectOperation");
        in.setPortType("{http://com.sun.jbi/aspect/aspect}aspectPortType");
        in.setRoleName("aspectPortTypeRole");
        in.setPartnerLink("{http://com.sun.jbi/aspect/aspect}aspectPartner");
        aspecttype.getContent().add(this.aspectRootObjFactory.createAspectTypeInput(in));
    }
    
    public void addNewInput(AspectType aspecttype, String serviceName, String roleName, String portType, String operation, String messageType) {
        InputType in = new InputType();
        in.setMessageType(messageType);
        in.setOperation(operation);
        in.setPortType(portType);
        in.setRoleName(roleName);
        in.setPartnerLink(serviceName);
        aspecttype.getContent().add(this.aspectRootObjFactory.createAspectTypeInput(in));
    }
    
    public void deleteExistingInput(AspectType aspecttype) {
        InputType inputtype  = null;
        Iterator it = aspecttype.getContent().iterator();
        while(it.hasNext()) {
            JAXBElement element = (JAXBElement)it.next();
            if ((element.getName().getLocalPart().equals("input"))) {
                aspecttype.getContent().remove(element);
                break;
            }
        }
    }
    
    public List<OutputType> getOutputList(AspectType aspecttype) {
        List<OutputType> outputTypeList = new ArrayList();
        
        Iterator it = aspecttype.getContent().iterator();
        while(it.hasNext()) {
            Object tempObj = it.next();
            if (!(tempObj instanceof java.lang.String)) {
                JAXBElement element = (JAXBElement)tempObj;
                if ((element.getName().getLocalPart().equals("output"))) {
                    outputTypeList.add((OutputType)element.getValue());
                }
            }
        }
        
        return outputTypeList;
    }
    
    public OutputType searchOutputType(AspectType aspecttype, String outputindex){
        OutputType ret = null;
        
        Iterator it = aspecttype.getContent().iterator();
        while(it.hasNext()) {
            Object tempObj = it.next();
            if (!(tempObj instanceof java.lang.String)) {
                JAXBElement element = (JAXBElement)tempObj;
                if ((element.getName().getLocalPart().equals("output"))) {
                    if (((OutputType)element.getValue()).getID().equals(outputindex)){
                        ret = (OutputType)element.getValue();
                        break;
                    }
                }
            }
        }
        return ret;
    }
    
    public void createAndAddOutput(AspectType aspecttype, String serviceName, String roleName, String portType, String operation, String messageType, String id) {
        OutputType output = new OutputType();
        output.setServiceName(serviceName);
        output.setPortType(portType);
        output.setOperation(operation);
        //output.setRoleName(roleName);
        
        //Request Type
        RequestType rqst = new RequestType();
        rqst.setMessageType(messageType);
        //Response Type
        ResponseType resp = new ResponseType();
        resp.setMessageType(messageType);
        
        output.setRequest(rqst);
        output.setResponse(resp);
        output.setID(id);
        
        addOutput(aspecttype, output);
    }
    
    public OutputType createOutput(AspectType aspecttype, String serviceName, String roleName, String portType, String operation, String messageType, String id) {
        OutputType output = new OutputType();
        output.setServiceName(serviceName);
        output.setPortType(portType);
        output.setOperation(operation);
        //output.setRoleName(roleName);
        RequestType rqst = new RequestType();
        rqst.setMessageType(messageType);
        ResponseType resp = new ResponseType();
        resp.setMessageType(messageType);
        output.setRequest(rqst);
        output.setResponse(resp);
        output.setID(id);
        
        return output;
    }
    
    public void addOutput(AspectType aspect, OutputType output) {
        aspect.getContent().add(this.aspectRootObjFactory.createAspectTypeOutput(output));
    }
    
    public OutputType getCurrentOutput(AspectType aspect) {
        return this.currentOutputMap.get(aspect);
    }
    
    public void setCurrentOutput(AspectType aspect, OutputType output) {
        if (this.currentOutputMap.containsKey(aspect)) {
            this.currentOutputMap.remove(aspect);
        }
        
        this.currentOutputMap.put(aspect, output);
    }
    
    
    public AspectmapType getAspectMapModel() {
        return this.getroot();
    }
    
    
    public void addAspect(AspectType aspecttype) {
        addNewDefaultInput(aspecttype);
        getroot().getAspect().add(aspecttype);
    }
    
    public AspectType addNewAspect(ExchangeSimpleType aspectExchangeType, String aspectIndex){
        AspectType newaspecttype = new AspectType();
        newaspecttype.setExchangeType(aspectExchangeType);
        newaspecttype.setID(aspectIndex);
        getroot().getAspect().add(newaspecttype);
        addNewDefaultInput(newaspecttype);
        return newaspecttype;
    }
    
    public AdviceType addNewAdvice(AspectType aspecttype, String adviceName, String order) {
        AdviceType newAdvice = new AdviceType();
        newAdvice.setType(adviceName);
        newAdvice.setOrder(Byte.parseByte(order));
        aspecttype.getContent().add(this.aspectRootObjFactory.createAspectTypeAdvice(newAdvice));
        setConfigFile(newAdvice); // This will be changed later, this is a temporary arrangement. config needs to be part of aspectmap.xml
        return newAdvice;
    }
    
    private AspectmapType getroot(){
        return (AspectmapType)this.aspectRootType.getValue();
    }
    
    public AspectmapType unmarshallAspectMap() {
        try {
            this.aspectRootType = (JAXBElement)this.unmarshaller.unmarshal(this.aspectMapFileObj);
        } catch (JAXBException ex) {
            ex.printStackTrace();
        }
        
        return (AspectmapType) this.aspectRootType.getValue();
    }
    
    
    public void marshallMapObj() {
        try {
            this.marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, java.lang.Boolean.TRUE);
            java.lang.String filename = "D:" + fs + "temp" + fs + "jaxbtestfile" + fs + "fromObj.txt";
            java.io.File f = new java.io.File(filename);
            f.delete();
            f.createNewFile();
            this.marshaller.marshal(this.aspectRootType, f);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public String marshallMapObjToStr() {
        StringWriter writer = new StringWriter();
        this.aspectmapstr.delete(0, this.aspectmapstr.length());
        try {
            this.marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, java.lang.Boolean.TRUE);
            this.marshaller.marshal(this.aspectRootType, writer);
            this.aspectmapstr.append(writer.toString());
            writer.close();
        } catch (IOException ex2) {
            ex2.printStackTrace();
        } catch (JAXBException ex1) {
            ex1.printStackTrace();
        }
        
        return this.aspectmapstr.toString();
    }
    
    /* *********************** TEMPORARY IMPLEMENTATIONS ********************** */
    
    private void setConfigFile(AdviceType newadvice) {
        try {
            if (!this.adviceConfigFileTable.containsKey(newadvice.getType())) {
                String configfilename = newadvice.getType() + "_config.xml";
                String filepath = this.aspectMapFileObj.getParent();
                java.io.File configfileObj = new java.io.File(filepath + fs + configfilename);
                configfileObj.createNewFile();
                // Make a reference for use later
                this.adviceConfigFileTable.put(newadvice.getType(), configfileObj);
                // Associate the properties map with the advice
                loadAdvicePropertiesFromFile(newadvice.getType(), configfileObj);
                //Set the file name in the unmarshalled structure
                newadvice.setConfigurationFile(configfilename);
            } else {
                // Config file is already existing, polulate the properties in the hashtable
                
            }
        } catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
    }
    
    private void loadAdvicePropertiesFromFile(String advicename, File adviceConfigFileObj) {
        HashMap<String, String> propertiesTable = null;
        if (this.advicePropertiesTable.containsKey(advicename)) {
            propertiesTable = (HashMap<String,String>)this.advicePropertiesTable.get(advicename);
        } else{
            propertiesTable = new HashMap<String,String>();
            this.advicePropertiesTable.put(advicename, propertiesTable);
        }
        
        Element root = parsePropertiesFromFile(adviceConfigFileObj);
        if (root != null) {
            NodeList properties = root.getElementsByTagName(AspectConstants.PROPERTY_TAG);
            
            for (int i = 0; i < properties.getLength(); i++) {
                Element property = (Element) properties.item(i);
                String key = property
                        .getAttribute(AspectConstants.PROPERTY_ATTR_NAME);
                String value = property
                        .getAttribute(AspectConstants.PROPERTY_ATTR_VALUE);
                if (key == null)
                    continue;
                value = (value == null ? "" : value);
                propertiesTable.put(key, value);
            }
        }
    }
    
    public File getConfigFile(AdviceType advicetype) {
        return this.adviceConfigFileTable.get(advicetype.getType());
    }
    
    public HashMap getAdviceProperties(AdviceType advicetype) {
        HashMap advprops = this.advicePropertiesTable.get(advicetype.getType());
        if (advprops == null) {
            setConfigFile(advicetype);
        }
        return this.advicePropertiesTable.get(advicetype.getType());
    }
    
    public void setAdviceProperties(AdviceType advice, String name, String value) {
        java.util.HashMap advicePropMap = this.advicePropertiesTable.get(advice.getType());
        if (advicePropMap.containsKey(name)) {
            advicePropMap.remove(name);
        }
        advicePropMap.put(name, value);
        
        writePropertiesToFile(advice.getType(),advicePropMap);
    }
    
    public void removeAdviceProperty(AdviceType advice, String property) {
        HashMap advicePropMap = this.advicePropertiesTable.get(advice.getType());
        if (advicePropMap.containsKey(property)) {
            advicePropMap.remove(property);
        }
        writePropertiesToFile(advice.getType(),advicePropMap);
    }
    
    private void writePropertiesToFile(String advicename, HashMap advicePropMap) {
        java.io.BufferedWriter br = null;
        java.lang.StringBuffer sb = null;
        try {
            File adviceConfigFile = this.adviceConfigFileTable.get(advicename);
            sb = new java.lang.StringBuffer();
            java.util.Iterator it = advicePropMap.keySet().iterator();
            sb.append("<" + AspectConstants.CONFIG_TAG + ">\n");
            while (it.hasNext()) {
                java.lang.String key = (java.lang.String) it.next();
                sb.append("<" + AspectConstants.PROPERTY_TAG + " " + AspectConstants.PROPERTY_ATTR_NAME + "=" +  "\"" + key + "\"  " + AspectConstants.PROPERTY_ATTR_VALUE + "=\"" + advicePropMap.get(key) + "\"></" + AspectConstants.PROPERTY_TAG + ">");
                //sb.append(key + "=" + advicePropMap.get(key));
                sb.append("\n");
            }
            sb.append("</" + AspectConstants.CONFIG_TAG + ">");
            br = new java.io.BufferedWriter(new java.io.FileWriter(adviceConfigFile));
            br.write(sb.toString());
        } catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        } finally {
            try {
                br.close();
                sb.delete(0, sb.length());
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
    
    private Element parsePropertiesFromFile(File adviceConfigFileObj) {
        Element root = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(adviceConfigFileObj);
            root = document.getDocumentElement();
        } catch (IOException ex) {
            //ignore
        } catch (ParserConfigurationException ex) {
            //ignore
        } catch (SAXException ex) {
            //ignore
        }
        
        return root;
    }
    
    /* *********************** TEMPORARY IMPLEMENTATIONS ********************** */
    
    /* *********************** TEST METHODS - TO BE REMOVED ********************** */
    
    private void throw_this_object_to_file(Object o) {
        try {
            this.marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, java.lang.Boolean.TRUE);
            java.lang.String filename = "D:" + fs + "temp" + fs + "jaxbtestfile" + fs + "ObjectToFile.txt";
            java.io.File f = new java.io.File(filename);
            f.delete();
            f.createNewFile();
            this.marshaller.marshal(o, f);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public static void throw_this_File_to_disk(File f, String condition) {
        //Reading
        FileWriter fr = null;
        try {
            java.lang.StringBuffer sb = new java.lang.StringBuffer();
            if (f != null) {
                try {
                    BufferedReader in = new BufferedReader(new java.io.FileReader(f));
                    java.lang.String str;
                    while ((str = in.readLine()) != null) {
                        sb.append(str);
                        sb.append("\n");
                    }
                    in.close();
                } catch (java.io.IOException ex) {
                    ex.printStackTrace();
                }
                
            }
            
            sb.append("\n\n...... " + condition +  " .....");
            // Writing
            String filename = "D:" + fs + "temp" + fs + "jaxbtestfile" + fs + "dummy_file.txt";
            File f1 = new java.io.File(filename);
            f1.delete();
            f1.createNewFile();
            fr = new java.io.FileWriter(f1);
            fr.write(sb.toString());
        } catch (IOException ex) {
            ex.printStackTrace();
        } finally {
            try {
                fr.close();
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
    
}
