/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */
package org.netbeans.modules.aspect.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.xpath.XPathExpression;
import javax.xml.transform.dom.DOMSource;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * This routing rule is used for Content Based Routing. If the xpath expression
 * matches the input from the MessageExchange, the invoke specified by this rule
 * would be used for destination
 * 
 * @author Sujit Biswas
 * 
 */

// TODO cleanup the class, a rule has only xpath expression and a list of
// destination
public class Rule {

	private Element rule;

	private String ruleName;

	private XPathExpression xpathExpression;

	private KeyExpression keyExpression;

	private List<String> destinations;

	public Rule(Element ruleElement) {
		rule = ruleElement;
                destinations = new ArrayList<String>();
		init();
	}
        
        public Rule() {
            destinations = new ArrayList<String>();
            keyExpression = new KeyExpression();
        }
        
        public List<String> getDestinations() {
            return destinations;
        }
        
        public void addDestination(String dest) {
            destinations.add(dest);            
        }
        
        public void clearDestinations() {
            destinations.clear();
        }
        
        public void removeDestination(String destination) {
            destinations.remove(destination);
        }
        
        public String getKeyExpression() {
            return keyExpression.getKeyExpression();
        }
        
        public void setKeyExpression(String exp){
            keyExpression.setKeyExpression(exp);
        }

	private void init() {
		if (rule != null) {
			ruleName = rule.getAttribute(AspectConstants.PROPERTY_ATTR_NAME);
			NodeList xpathElements = rule
					.getElementsByTagName(AspectConstants.XPATH_TAG);

			// expecting only one xpath tag with key expression attribute.
			Element xpathElement = (Element) xpathElements.item(0);
			if (xpathElement != null) {
				keyExpression = new KeyExpression(xpathElement);
			}
                        
                        // get list of destinations.
                        NodeList dests = rule.getElementsByTagName(AspectConstants.RULE_TAG_DESTINATION);
                        for(int i = 0; i < dests.getLength(); i++) {
                            Element dest = (Element)dests.item(i);
                            destinations.add(dest.getAttribute(AspectConstants.RULE_TAG_DESTINATION_ATTR));
                        }
		}
	}

	/**
	 * This is the getter method for getting xpathexpression for this rule
	 * object.
	 * 
	 * @return XPathExpression xpathExpression
	 */
	public XPathExpression getXPathExpression() {
		return xpathExpression;
	}

	/**
     * This is the getter method for getting the Rule name.
     * 
     * 
     * 
     * @return String name
     */
	public String getName() {
		return ruleName;
	}

	/**
     * This is the setter method for setting the Rule name.
     * 
     * 
     * 
     * @param String
     *            name
     */
	public void setName(String name) {
		ruleName = name;
	}

	/**
	 * This is the setter method for setting xpath expression for this rule
	 * object.
	 * 
	 * @param XPathExpression
	 *            exp
	 */
	public void setXPathExpression(XPathExpression exp) {
		xpathExpression = exp;
	}

	public String toXMLString() {
		StringBuffer xmlString = new StringBuffer();
		xmlString.append("<" + AspectConstants.RULE_TAG + ">\n");
		if (keyExpression == null) {
			xmlString.append("<" + AspectConstants.XPATH_TAG + "/>");
		} else {
			xmlString.append(keyExpression.toXMLString());
		}
		if (destinations.isEmpty()) {
			xmlString.append("<" + AspectConstants.RULE_TAG_DESTINATION
					+ "/>\n");
		} else {
			Iterator it = destinations.iterator();
			while (it.hasNext()) {
				String destination = (String) it.next();
				xmlString.append("<" + AspectConstants.RULE_TAG_DESTINATION
						+ " " + AspectConstants.RULE_TAG_DESTINATION_ATTR
						+ "=\"" + destination + "\"/>\n");
			}
		}
		xmlString.append("</" + AspectConstants.RULE_TAG + ">\n");
		return xmlString.toString();
	}
}