package it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.impl;

import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaQName;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.spi.ElementFactory;
import org.w3c.dom.Element;

public class CorbaElementFactoryProvider {
    
    public static class BindingFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(CorbaQName.BINDING.getQName());
        }

        public WSDLComponent create(WSDLComponent context, Element element) {
            return new CorbaBindingImpl(context.getModel(), element);
        }
    }

    public static class AddressFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(CorbaQName.ADDRESS.getQName());
        }

        public WSDLComponent create(WSDLComponent context, Element element) {
            return new CorbaAddressImpl(context.getModel(), element);
        }
    }

    public static class OperationFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(CorbaQName.OPERATION.getQName());
        }

        public WSDLComponent create(WSDLComponent context, Element element) {
            return new CorbaOperationImpl(context.getModel(), element);
        }
    }

    public static class MessageFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(CorbaQName.MESSAGE.getQName());
        }

        public WSDLComponent create(WSDLComponent context, Element element) {
            return new CorbaMessageImpl(context.getModel(), element);
        }
    }
}
