package com.sun.jbi.sapbc.sapwsdlgenerator.explorer.util;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

/**
 * A Swing component for selecting files.
 */
class FileSelectorPanel extends javax.swing.JPanel {
    
    /**
     * Creates new form FileSelectorPanel
     */
    public FileSelectorPanel() {
        initComponents();
    }

    public void setInitialTarget(final File target) {
        if (target.isFile()) {
            chooser.setCurrentDirectory(target);
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    filepathTextField.setText(target.getAbsolutePath());
                }
            });
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        filepathTextField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();

        filepathTextField.setEditable(false);

        browseButton.setMnemonic('r');
        browseButton.setText("Browse...");
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(filepathTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 221, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(browseButton)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(browseButton)
                    .add(filepathTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        chooser.setFileFilter(jarFileFilter);
        
        int outcome = chooser.showDialog(this,
            bundle.getString("LibrarySelectorPanel.file_chooser_action_name"));
        
        switch (outcome) {
            case JFileChooser.APPROVE_OPTION:
                File file = chooser.getSelectedFile();
                Object oldFile = selection;
                selection = file;
                filepathTextField.setText(file.getAbsolutePath());
                firePropertyChange(SELECTION_PROP, oldFile, file);
                break;
            default:
        }
    }//GEN-LAST:event_browseButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JTextField filepathTextField;
    // End of variables declaration//GEN-END:variables
    
    public static String SELECTION_PROP = "FileSelectorPanel.SELECTION";

    private Object selection;
    private final JFileChooser chooser = new JFileChooser();
    private final FileFilter jarFileFilter =
        new FileExtensionFilter(
            ".jar",
            bundle.getString("LibrarySelectorPanel.jar_files_description"));
    
    private static ResourceBundle bundle =
        NbBundle.getBundle(FileSelectorPanel.class);
}
