/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.prjwizard.snmp.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.netbeans.modules.prjwizard.snmp.DeviceDBMapConst;

/**
 *
 * @author Raghunadh Teegavarapu
 * @version 1.0
 */
public class Util {
    public static final String FORWARD_SLASH = "/"; // NOI18N
    public static final String UP_REL_FOLDER = "../"; // NOI18N
    public static final String CUR_REL_FOLDER = "./"; // NOI18N
    public static final String WSDL = "wsdl"; // NOI18N
    // TODO m
    public static final String SRC = "src"; // NOI18N

    private Util() {
    }
    
    /**
     * TODO m - looks like general utility method for all modules
     */
    public static FileObject getRelativeFO(FileObject startPoint
            , String relLocation) {
        if (startPoint == null || relLocation == null) {
            return null;
        }
        
        if (!startPoint.isFolder()) {
            startPoint = startPoint.getParent();
        }
        
        if (relLocation.startsWith(UP_REL_FOLDER)) {
            int upRelLength = UP_REL_FOLDER.length();
            while (relLocation.startsWith(UP_REL_FOLDER)) {
                startPoint = startPoint.getParent();
                relLocation = relLocation.substring(upRelLength);
            }
            
        } else if (relLocation.startsWith(CUR_REL_FOLDER)) {
            relLocation = relLocation.substring(CUR_REL_FOLDER.length());
        }
        return startPoint.getFileObject(relLocation);
    }
    
    /**
     * TODO m - looks like general utility method for all modules
     */
    public static String getRelativePath(FileObject fromFo, FileObject toFo) {
        String relativePath = FileUtil.getRelativePath(fromFo, toFo);
        if (relativePath != null) {
            return relativePath;
        }
        
        if (!fromFo.isFolder()) {
            fromFo = fromFo.getParent();
        }
        
        StringTokenizer fromPath = new StringTokenizer(fromFo.getPath()
                , FORWARD_SLASH);
        StringTokenizer toPath = new StringTokenizer(toFo.getPath()
                , FORWARD_SLASH);
        String tmpFromFolder = null;
        String tmpToFolder = null;
        while (fromPath.hasMoreTokens()) {
            tmpFromFolder = fromPath.nextToken();
            tmpToFolder = toPath.hasMoreTokens() ? toPath.nextToken() : null;
            if (!(tmpFromFolder.equals(tmpToFolder))) {
                break;
            }
        }
        if (tmpToFolder == null) {
            return null;
        }
        
        StringBuffer fromRelativePathPart = new StringBuffer(UP_REL_FOLDER);
        while (fromPath.hasMoreTokens()) {
            fromPath.nextToken();
            fromRelativePathPart.append(UP_REL_FOLDER);
        }
        
        StringBuffer toRelativePathPart = new StringBuffer(tmpToFolder);
        while (toPath.hasMoreTokens()) {
            toRelativePathPart.append(FORWARD_SLASH).append(toPath.nextToken());
        }
        
        return fromRelativePathPart.append(toRelativePathPart).toString();
    }
    
    public static Project getProject(FileObject projectFo) {
        FileObject projectRoot = null;
        return FileOwnerQuery.getOwner(projectFo);
    }

    
    public static FileObject getProjectRoot(FileObject projectFo) {
        FileObject projectRoot = null;
        Project project = FileOwnerQuery.getOwner(projectFo);
        if (project != null) {
            projectRoot = project.getProjectDirectory();
        }
        return projectRoot;
    }
    
    public static WSDLModel[] getAllProjectWsdls(FileObject projectRoot) {
        assert projectRoot != null;
        List<FileObject> fileObjects = new ArrayList<FileObject>();
        Enumeration projectFolders = projectRoot.getFolders(true);
        while(projectFolders.hasMoreElements()) {
            FileObject folder = (FileObject) projectFolders.nextElement();
            FileObject[] childrenFo = folder.getChildren();
            for (FileObject elem : childrenFo) {
                if (! elem.isFolder() && WSDL.equals(elem.getExt())) {
                    fileObjects.add(elem);
                }
            }
        }
        
        WSDLModel[] wsdlModels = null;
        if ( fileObjects != null && fileObjects.size() > 0) {
            wsdlModels = new WSDLModel[fileObjects.size()];
        }
        
        WSDLModelFactory factory = WSDLModelFactory.getDefault();
        for (int i = 0; i < wsdlModels.length; i++) {
            ModelSource wsdlModelSource = Utilities.getModelSource(fileObjects.get(i), true);
            wsdlModels[i] = factory.getModel(wsdlModelSource);
        }
        
        return wsdlModels;
    }
    
    public static FileObject getProjectSource(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("project shouldn't be null");
        }
        FileObject projectRoot = project.getProjectDirectory();
        assert projectRoot != null;
        // TODO m
        return projectRoot.getFileObject("src"); // NOI18N
    }
    
    public static FileObject getScriptMapFo(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("project shouldn't be null");
        }
        FileObject scriptMapFo = null;
        FileObject projectSource = getProjectSource(project);
        assert projectSource != null;
        
        scriptMapFo = projectSource.getFileObject(DeviceDBMapConst.SCRIPTMAP+"."+DeviceDBMapConst.XML);
        return scriptMapFo;
    }

    public static FileObject getScriptMapFo(FileObject scriptFo) {
        FileObject scriptMapFo = null;
        if (scriptFo == null) {
            return null;
        }
//        FileObject projectRoot = getProjectRoot(scriptFo);
//        if (projectRoot != null) {
              scriptMapFo = scriptFo.getParent().getFileObject(DeviceDBMapConst.SCRIPTMAP+"."+DeviceDBMapConst.XML);

//            scriptMapFo = projectRoot.getFileObject(scriptMapObject.scriptMAP+"."+scriptMapObject.XML);
//        }
        return scriptMapFo;
    }
    
    public static FileObject getScriptMapFo(File projectFile) {
        if (projectFile == null) {
            return null;
        }
        
        FileObject projectFo = FileUtil.toFileObject(projectFile);
        Project project = getProject(projectFo);
        
        return project == null ? null : getScriptMapFo(project);
    }


    public static File getScriptMapFile(File projectFile) {
        return FileUtil.toFile(getScriptMapFo(projectFile));
    }
    
    public static Operation getOperation(WSDLModel wsdlModel, String portType, String operation) {
        if (wsdlModel == null || portType == null || operation == null) {
            return null;
        }
        Operation resultOp = null;
        
        Definitions defs = wsdlModel.getDefinitions();
        if (defs == null) {
            return resultOp;
        }

        Collection<PortType> portTypes = defs.getPortTypes();
        PortType modelPortType = null;
        for (PortType tmpPortType : portTypes) {
            NamedComponentReference<PortType> tmpPortTypeRef = tmpPortType.
                            createReferenceTo(tmpPortType, PortType.class);

            QName tmpPortTypeQname = tmpPortTypeRef.getQName();
            String tmpPortTypeNs = tmpPortTypeQname.getNamespaceURI();
            String tmpPortTypeLocalPart = tmpPortTypeQname.getLocalPart();
            
            if (portType.equals("{"+tmpPortTypeNs+"}"+tmpPortTypeLocalPart)) {
                modelPortType = tmpPortType;
                break;
            }
        }
        
        if (modelPortType != null) {
            Collection<Operation> operations = modelPortType.getOperations();
            for (Operation tmpOperation : operations) {
                if (operation.equals(tmpOperation.getName())) {
                    resultOp = tmpOperation;
                    break;
                }
            }
        }

        return resultOp;
    }
    
    /**
     * @param if qnamedElement has structure like this: {namespaceURI}localName
     * @return if localName qnamedElement has structure like this: 
     * {namespaceURI}localName then return localName
     *
     */
    private String getLocalPart(String qnamedElement) {
        
        
        QName qnamedElementQName = QName.valueOf(qnamedElement);
        return qnamedElementQName.getLocalPart();
    }
    
  
    public static String getNamespace(ReferenceableWSDLComponent wsdlComp) {
        if (wsdlComp == null) {
            return null;
        }
        
        String namespace = null;
        
        WSDLModel model = wsdlComp.getModel();
        Definitions defs = null;

        if (model != null) {
            defs = model.getDefinitions();
        }
        
        if (defs != null) {
            namespace = defs.getTargetNamespace();
        }

        return namespace;
    }
    
    
    public static String getMessageType(Operation operation, boolean isInput) {
        if (operation == null) {
            return null;
        }
        
        String messageType = null;
        NamedComponentReference<org.netbeans.modules.xml.wsdl.model.Message> messageRef = null;

        OperationParameter opParam =  isInput 
                ? operation.getInput() : operation.getOutput();

        if (opParam != null) {
            messageRef = opParam.getMessage();
        }

        org.netbeans.modules.xml.wsdl.model.Message message = null;
        if (messageRef != null) {
            message = messageRef.get();
        }

        if (message != null) {
            String namespace = Util.getNamespace(message);
            namespace = namespace != null ? "{"+namespace+"}" : ""; // NOI18N
            messageType = namespace + message.getName();
        }
        
        return messageType;
    }
}
