/*
 * TaskDefinitionPanelFactory.java
 * 
 * Created on May 24, 2007, 3:10:31 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.escalation;

import org.netbeans.modules.wlm.model.api.DeadlineOrDuration;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.wlm.model.api.TExpression;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.worklist.editor.multiview.DeadlineOrDurationPanel;
import org.netbeans.modules.worklist.editor.multiview.EditorConstants;
import org.netbeans.modules.worklist.editor.multiview.PanelKey;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionEvent;
import org.netbeans.modules.worklist.editor.multiview.TaskSelectionListener;
import org.netbeans.modules.worklist.editor.multiview.assignment.AssignmentPanel;
import org.netbeans.modules.worklist.editor.multiview.assignment.GroupsPanel;
import org.netbeans.modules.worklist.editor.multiview.assignment.UsersPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;

/**
 *
 * @author radval
 */
public class EscalationPanelFactory implements org.netbeans.modules.xml.multiview.ui.InnerPanelFactory { 

    
    private WorklistDataObject dObj;
    ToolBarDesignEditor editor;
    
    
    public EscalationPanelFactory(ToolBarDesignEditor editor, WorklistDataObject dObj) {
        this.dObj=dObj;
        this.editor=editor;
    }

    public SectionInnerPanel createInnerPanel(Object key) {
         if(key instanceof PanelKey) {
             PanelKey cKey = (PanelKey) key;
             Object obj = cKey.getObject();
             String stringKey = cKey.getKey();
             
             if(EditorConstants.USERS_PANEL.equals(stringKey) && obj instanceof TEscalation) {
                  UsersPanel usersPanel = new  UsersPanel((SectionView)editor.getContentView(), dObj);
                  TEscalation escalation = (TEscalation) obj;
                  TAssignment assignment = escalation.getAssignment();
                  if(assignment == null) {
                      assignment = dObj.getModel().getFactory().createAssignment(dObj.getModel());
                      dObj.getModel().startTransaction();
                      escalation.setAssignment(assignment);
                      dObj.getModel().endTransaction();
                  }
                  
                  usersPanel.refreshUsers(assignment);
                  
                  
                  return usersPanel;
             } else if(EditorConstants.GROUPS_PANEL.equals(stringKey) && obj instanceof TEscalation) {
                 GroupsPanel groupsPanel = new  GroupsPanel((SectionView)editor.getContentView(), dObj);
                 TEscalation escalation = (TEscalation) obj;
                  TAssignment assignment = escalation.getAssignment();
                  if(assignment != null) {
                      groupsPanel.refreshGroups(assignment);
                  }
                  
                  return groupsPanel;
             } else if(obj instanceof DeadlineOrDuration) {
                 return new  DeadlineOrDurationPanel((SectionView)editor.getContentView(), dObj, (DeadlineOrDuration) obj);
             } 
         }
         
         return null;
    }
   
}
