/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.api;

import org.netbeans.modules.wlm.model.api.TActionType;

/**
 * <p>
 * Java class for actionTypeAttribute.
 * 
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * <p>
 * 
 * <pre>
 * &lt;simpleType name=&quot;actionTypeAttribute&quot;&gt;
 *   &lt;restriction base=&quot;{http://www.w3.org/2001/XMLSchema}string&quot;&gt;
 *     &lt;enumeration value=&quot;onTaskCreated&quot;/&gt;
 *     &lt;enumeration value=&quot;onTaskClaimed&quot;/&gt;
 *     &lt;enumeration value=&quot;onTaskOutputSet&quot;/&gt;
 *     &lt;enumeration value=&quot;onTaskReassigned&quot;/&gt;
 *     &lt;enumeration value=&quot;onTaskRevoked&quot;/&gt;
 *     &lt;enumeration value=&quot;onTaskTimedOut&quot;/&gt;
 *     &lt;enumeration value=&quot;onTaskEscalated&quot;/&gt;
 *     &lt;enumeration value=&quot;onTaskCompleted&quot;/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */

public enum TActionType {

	ON_TASK_CLAIMED("onTaskClaimed"), ON_TASK_COMPLETED("onTaskCompleted"), ON_TASK_CREATED(
			"onTaskCreated"), ON_TASK_ESCALATED("onTaskEscalated"), ON_TASK_OUTPUT_SET(
			"onTaskOutputSet"), ON_TASK_REASSIGNED("onTaskReassigned"), ON_TASK_REVOKED(
			"onTaskRevoked"), ON_TASK_TIMED_OUT("onTaskTimedOut");
	private final String value;

	TActionType(String v) {
		value = v;
	}

	public String value() {
		return value;
	}

	public static TActionType fromValue(String v) {
		for (TActionType c : TActionType.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v.toString());
	}

}
