/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import org.netbeans.modules.wlm.model.api.DeadlineOrDuration;
import org.netbeans.modules.wlm.model.api.Group;
import org.netbeans.modules.wlm.model.api.Role;
import org.netbeans.modules.wlm.model.api.TAction;
import org.netbeans.modules.wlm.model.api.TAddress;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TDeadlineExpr;
import org.netbeans.modules.wlm.model.api.TDurationExpr;
import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TNotification;
import org.netbeans.modules.wlm.model.api.TRecipient;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.wlm.model.api.TTasks;
import org.netbeans.modules.wlm.model.api.TTimeout;
import org.netbeans.modules.wlm.model.api.User;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMVisitor;
import org.netbeans.modules.xml.xam.AbstractComponent;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;

/**
 * Visitor to add or remove a child of a WSDL component.
 * 
 * @author Nam Nguyen
 */
public class ChildComponentUpdateVisitor<T extends WLMComponent> implements
		WLMVisitor, ComponentUpdater<T> {

	private Operation operation;

	private WLMComponent parent;

	private int index;

	private boolean canAdd = false;

	/**
	 * Creates a new instance of ChildComponentUpdateVisitor
	 */
	public ChildComponentUpdateVisitor() {
	}

	public boolean canAdd(WLMComponent target, Component child) {
		if (!(child instanceof WLMComponent))
			return false;
		update(target, (WLMComponent) child, null);
		return canAdd;
	}

	public void update(WLMComponent target, WLMComponent child,
			Operation operation) {
		update(target, child, -1, operation);
	}

	public void update(WLMComponent target, WLMComponent child, int index,
			Operation operation) {
		assert target != null;
		assert child != null;

		this.parent = target;
		this.operation = operation;
		this.index = index;
		child.accept(this);
	}

	@SuppressWarnings("unchecked")
	private void addChild(String eventName, DocumentComponent child) {
		((AbstractComponent) parent).insertAtIndex(eventName, child, index);
	}

	@SuppressWarnings("unchecked")
	private void removeChild(String eventName, DocumentComponent child) {
		((AbstractComponent) parent).removeChild(eventName, child);
	}

	private void checkOperationOnUnmatchedParent() {
		if (operation != null) {
			// note this unmatch should be caught by validation,
			// we don't want the UI view to go blank on invalid but still
			// well-formed document
			// throw new IllegalArgumentException("Unmatched parent-child
			// components"); //NO18N
		} else {
			canAdd = false;
		}
	}

	public void visitAction(TAction action) {
		// TODO Auto-generated method stub
		if (parent instanceof TNotification) {
			TNotification target = (TNotification) parent;
			if (operation == Operation.ADD) {
				target.addAction(action);
			} else if (operation == Operation.REMOVE) {
				target.removeAction(action);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitAddress(TAddress address) {
		// TODO Auto-generated method stub
		if (parent instanceof TRecipient) {
			if (operation == Operation.ADD) {
				addChild(TRecipient.ADDRESS_PROPERTY, address);
			} else if (operation == Operation.REMOVE) {
				removeChild(TRecipient.ADDRESS_PROPERTY, address);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}

	}

	public void visitAssignment(TAssignment assignment) {
		// TODO Auto-generated method stub
		if (parent instanceof TTask) {
			if (operation == Operation.ADD) {
				addChild(TTask.ASSIGNMENT_PROPERTY, assignment);
			} else if (operation == Operation.REMOVE) {
				removeChild(TTask.ASSIGNMENT_PROPERTY, assignment);
			} else if (operation == null) {
				canAdd = true;
			}
		} else if (parent instanceof TEscalation) {
			if (operation == Operation.ADD) {
				addChild(TEscalation.ASSIGNMENT_PROPERTY, assignment);
			} else if (operation == Operation.REMOVE) {
				removeChild(TEscalation.ASSIGNMENT_PROPERTY, assignment);
			} else if (operation == null) {
				canAdd = true;
			} else {
				checkOperationOnUnmatchedParent();
			}
		}
	}

	public void visitEscalation(TEscalation escalation) {
		// TODO Auto-generated method stub
		if (parent instanceof TTask) {
			TTask target = (TTask) parent;
			if (operation == Operation.ADD) {
				target.addEscalation(escalation);
			} else if (operation == Operation.REMOVE) {
				target.removeEscalation(escalation);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitGroup(Group group) {
		// TODO Auto-generated method stub
		if (parent instanceof TAssignment) {
			if (operation == Operation.ADD) {
				addChild(TAssignment.GROUP_PROPERTY, group);
			} else if (operation == Operation.REMOVE) {
				removeChild(TAssignment.GROUP_PROPERTY, group);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitImport(TImport importEl) {
		// TODO Auto-generated method stub
		if (parent instanceof TTasks) {
			TTasks target = (TTasks) parent;
			if (operation == Operation.ADD) {
				target.addImport(importEl);
			} else if (operation == Operation.REMOVE) {
				target.removeImport(importEl);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitNotification(TNotification notification) {
		// TODO Auto-generated method stub
		if (parent instanceof TTask) {
			TTask target = (TTask) parent;
			if (operation == Operation.ADD) {
				target.addNotification(notification);
			} else if (operation == Operation.REMOVE) {
				target.removeNotification(notification);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitRecipient(TRecipient recipient) {
		if (parent instanceof TAction) {
			TAction target = (TAction) parent;
			if (operation == Operation.ADD) {
				target.addRecipient(recipient);
			} else if (operation == Operation.REMOVE) {
				target.removeRecipient(recipient);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitRole(Role role) {
		// TODO Auto-generated method stub
		if (parent instanceof TAssignment) {
			if (operation == Operation.ADD) {
				addChild(TAssignment.ROLE_PROPERTY, role);
			} else if (operation == Operation.REMOVE) {
				removeChild(TAssignment.ROLE_PROPERTY, role);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitTask(TTask task) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		if (parent instanceof TTasks) {
			TTasks target = (TTasks) parent;
			if (operation == Operation.ADD) {
				target.addTask(task);
			} else if (operation == Operation.REMOVE) {
				target.removeTask(task);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitTasks(TTasks tasks) {
		// TODO Auto-generated method stub
		checkOperationOnUnmatchedParent();
	}

	public void visitTimeout(TTimeout timeout) {
		// TODO Auto-generated method stub
		if (parent instanceof TTask) {
			TTask target = (TTask) parent;
			if (operation == Operation.ADD) {
				target.addTimeOut(timeout);
			} else if (operation == Operation.REMOVE) {
				target.removeTimeOut(timeout);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitUser(User user) {
		// TODO Auto-generated method stub
		if (parent instanceof TAssignment) {
			if (operation == Operation.ADD) {
				addChild(TAssignment.USER_PROPERTY, user);
			} else if (operation == Operation.REMOVE) {
				removeChild(TAssignment.USER_PROPERTY, user);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitDeadLine(TDeadlineExpr deadline) {
		// TODO Auto-generated method stub
		if (parent instanceof DeadlineOrDuration) {
			if (operation == Operation.ADD) {
				addChild(DeadlineOrDuration.DEADLINE_PROPERTY, deadline);
			} else if (operation == Operation.REMOVE) {
				removeChild(DeadlineOrDuration.DEADLINE_PROPERTY, deadline);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

	public void visitDuration(TDurationExpr duration) {
		// TODO Auto-generated method stub
		if (parent instanceof DeadlineOrDuration) {
			if (operation == Operation.ADD) {
				addChild(DeadlineOrDuration.DURATION_PROPERTY, duration);
			} else if (operation == Operation.REMOVE) {
				removeChild(DeadlineOrDuration.DURATION_PROPERTY, duration);
			} else if (operation == null) {
				canAdd = true;
			}
		} else {
			checkOperationOnUnmatchedParent();
		}
	}

}
