/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import java.util.ArrayList;
import java.util.Collection;

import org.netbeans.modules.wlm.model.api.Group;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TDeadlineExpr;
import org.netbeans.modules.wlm.model.api.TDurationExpr;
import org.netbeans.modules.wlm.model.api.TEscalation;
import org.netbeans.modules.wlm.model.api.TImport;
import org.netbeans.modules.wlm.model.api.TNotification;
import org.netbeans.modules.wlm.model.api.TTimeout;
import org.netbeans.modules.wlm.model.api.User;
import org.netbeans.modules.wlm.model.api.WLMComponent;

/**
 * 
 * @author nn136682
 */
public enum TypeCollection {
	EMPTY(createEmpty()),
	FOR_ESCALATION_ASSIGNMENT (createEscalationAssignment()),
        FOR_ASSIGNMENT_USER (createAssignmentGroup()),
	FOR_ASSIGNMENT_GROUP (createAssignmentGroup()),
	FOR_ASSIGNMENT_ROLE (createAssignmentRole()),
	FOR_TASK_TIMEOUT (createTaskTimeout()),
	FOR_TASK_ESCALATION (createTaskEscalation()),
	FOR_TASK_NOTIFICATION (createTaskNotification()),
	FOR_TASKS_TASK  (createTasksTask()),
        FOR_TASKS_IMPORT  (createTasksImport());
        
	private Collection<Class<? extends WLMComponent>> types;

	TypeCollection(Collection<Class<? extends WLMComponent>> types) {
		this.types = types;
	}

	public Collection<Class<? extends WLMComponent>> types() {
		return types;
	}

	static Collection<Class<? extends WLMComponent>> createEmpty() {
		Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<? extends WLMComponent>>();
		return c;
	}
	static Collection<Class<? extends WLMComponent>> createTasksTask() {
		Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<? extends WLMComponent>>();
		c.add(TImport.class);
		return c;
	}
	
        static Collection<Class<? extends WLMComponent>> createTasksImport() {
		Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<? extends WLMComponent>>();
		c.add(TImport.class);
		return c;
	}
        
        static Collection<Class<? extends WLMComponent>> createAssignmentUser() {
		Collection<Class<? extends WLMComponent>> c = createEmpty();
		c.add(User.class);		
		return c;
	}
        
	static Collection<Class<? extends WLMComponent>> createAssignmentGroup() {
		Collection<Class<? extends WLMComponent>> c = createEmpty();
		c.add(User.class);		
		return c;
	}
	
	static Collection<Class<? extends WLMComponent>> createAssignmentRole() {
		Collection<Class<? extends WLMComponent>> c = createEmpty();
		c.add(User.class);	
		c.add(Group.class);	
		return c;
	}	

	static Collection<Class<? extends WLMComponent>> createEscalationAssignment() {
		Collection<Class<? extends WLMComponent>> c = createEmpty();
		c.add(TDeadlineExpr.class);
		c.add(TDurationExpr.class);
		return c;
	}

	static Collection<Class<? extends WLMComponent>> createTaskTimeout() {
		Collection<Class<? extends WLMComponent>> c = createEmpty();
                c.add(TAssignment.class);
                c.add(TTimeout.class);
		return c;
	}	
	
	static Collection<Class<? extends WLMComponent>> createTaskEscalation() {
		Collection<Class<? extends WLMComponent>> c = createEmpty();
		c.add(TAssignment.class);
                c.add(TTimeout.class);
                c.add(TEscalation.class);
		return c;
	}
	static Collection<Class<? extends WLMComponent>> createTaskNotification() {
		Collection<Class<? extends WLMComponent>> c = createEmpty();
		c.add(TAssignment.class);
		c.add(TTimeout.class);
                c.add(TEscalation.class);
		c.add(TNotification.class);
		return c;
	}	
	//    
	// static Collection<Class<? extends WLMComponent>> createDocumentation() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// return c;
	// }
	//    
	// static Collection<Class<? extends WLMComponent>> createDocumentationEE()
	// {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(ExtensibilityElement.class);
	// return c;
	// }
	//    
	// static Collection<Class<? extends WLMComponent>> createListForImport() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>> createListForTypes() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(Import.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>> createListForMessage() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(Import.class);
	// c.add(Types.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>> createListForPortType()
	// {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(Import.class);
	// c.add(Types.class);
	// c.add(Message.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>> createListForBinding() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(Import.class);
	// c.add(Types.class);
	// c.add(Message.class);
	// c.add(PortType.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>> createListForService() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(Import.class);
	// c.add(Types.class);
	// c.add(Message.class);
	// c.add(PortType.class);
	// c.add(Binding.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>>
	// createDocumentationOutputList() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(Output.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>>
	// createDocumentationInputList() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(Input.class);
	// return c;
	// }
	//
	// static Collection<Class<? extends WLMComponent>>
	// createListForBindingInput() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(ExtensibilityElement.class);
	// c.add(BindingInput.class);
	// return c;
	// }
	//    
	// static Collection<Class<? extends WLMComponent>>
	// createListForBindingOutput() {
	// Collection<Class<? extends WLMComponent>> c = new ArrayList<Class<?
	// extends WLMComponent>>();
	// c.add(Documentation.class);
	// c.add(ExtensibilityElement.class);
	// c.add(BindingInput.class);
	// c.add(BindingOutput.class);
	// return c;
	// }
}
