/* *************************************************************************
 *
 *          Copyright (c) 2005, SeeBeyond Technology Corporation,
 *          All Rights Reserved
 *
 *          This program, and all the routines referenced herein,
 *          are the proprietary properties and trade secrets of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 *          Except as provided for by license agreement, this
 *          program shall not be duplicated, used, or disclosed
 *          without  written consent signed by an officer of
 *          SEEBEYOND TECHNOLOGY CORPORATION.
 *
 ***************************************************************************/
package org.netbeans.modules.workflow.project.anttasks;

import java.io.File;

import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileUtil;
/**
 * @author sgenipudi
 */
public class WSDLManager {

    private static WSDLManager mInstance = null;
   
    private WSDLManager() {
        
    }

    public static WSDLManager getInstance() {
        if (mInstance == null )  {
            mInstance = new WSDLManager();
        }
        return mInstance;
    }

    public WSDLModel getWSDLModel(File file) {
        ModelSource ms = getModuleSource(file);
        WSDLModelFactory factory = WSDLModelFactory.getDefault();
        WSDLModel model =null;
        try {
          model = factory.getModel(ms);
        }catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error while creating WSDLModel ",ex);
        }
          
        try {
            model.sync();
        }catch (Exception ex) {
            throw new RuntimeException("Error during sync operation"+file.getAbsolutePath());
        }
        return model;
    }
    
    public ModelSource getModuleSource(File file) {
        ModelSource source = null;
        try {
            if (WSDLGenerator.isCommandlineMode()) {
                    source = WorkflowCatalogModel.getDefault().createModelSource(file, true);
            } else {
                    source = org.netbeans.modules.xml.retriever.catalog.Utilities.createModelSource(FileUtil.toFileObject(file),true);
            }
        }catch (Exception ex){
            throw new RuntimeException("Error while creating model source for "+file);
        }

        return source;
    }

    
    
//    public WSDLOperation getOperation() 
    
}
