/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.languages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.modules.languages.parser.Pattern;


/**
 *
 * @author Jan Jancura
 */
public class NBSLanguage {
    
    static final String NBS_MIME_TYPE = "text/x-nbs";
    
    public static int WHITESPACE_ID;
    public static int COMMENT_ID;
    public static int IDENTIFIER_ID;

    
    private static Language nbsLanguage;

    static Language getNBSLanguage () {
        if (nbsLanguage == null) {
            try {
                List<TokenType> tokenTypes = new ArrayList<TokenType> ();
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create (
                        "'ACTION' |" +
                        "'AST' |" +
                        "'BRACE' |" +
                        "'BUNDLE' |" +
                        "'COLOR' |" +
                        "'COMMENT_LINE' |" +
                        "'COMPLETE' |" +
                        "'COMPLETION' |" +
                        "'FOLD' |" +
                        "'FORMAT' |" +
                        "'HYPERLINK' |" +
                        "'IMPORT' |" +
                        "'INDENT' |" +
                        "'MARK' | " +
                        "'NAVIGATOR' |" +
                        "'PARSE' |" +
                        "'PROPERTIES' |" +
                        "'REFORMAT' |" +
                        "'SELECTION' | " +
                        "'SEMANTIC_CONTEXT' | " +
                        "'SEMANTIC_DECLARATION' | " +
                        "'SEMANTIC_USAGE' | " +
                        "'SKIP' |" +
                        "'TOKEN' |" +
                        "'TOOLTIP'"
                    ),
                    "keyword",
                    0,
                    null,
                    0,
                    null
                ));
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create (
                        "['a'-'z' 'A'-'Z'] ['a'-'z' 'A'-'Z' '0'-'9' '_']*"
                    ),
                    "identifier",
                    1,
                    null,
                    1,
                    null
                ));
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create (
                        "':' | '*' | '?' | '+' | '-' | '[' | ']' | '<' | " +
                        "'>' | '^' | '|' | '{' | '}' | '(' | ')' | ',' | " +
                        "'=' | ';' | '.' | '$'"
                    ),
                    "operator",
                    2,
                    null,
                    2,
                    null
                ));
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create (
                        "'\\\"'" +
                        "(" +
                            "[^'\\\"' '\\\\' '\\r' '\\n'] |" +
                            "('\\\\' ['r' 'n' 't' '\\\\' '\\\'' '\\\"']) |" +
                            "('\\\\' 'u' ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'])" +
                        ")*" +
                        "'\\\"'"
                    ),
                    "string",
                    3,
                    null,
                    3,
                    null
                ));
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create (
                        "'\\\''" +
                        "(" +
                            "[^'\\\'' '\\\\' '\\r' '\\n'] |" +
                            "('\\\\' ['r' 'n' 't' '\\\\' '\\\'' '\\\"']) |" +
                            "('\\\\' 'u' ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'] ['0'-'9' 'a'-'f' 'A'-'F'])" +
                        ")*" +
                        "'\\\''"
                    ),
                    "string",
                    3,
                    null,
                    3,
                    null
                ));
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create ("'#' [^'\\n' '\\r']* ['\\n' '\\r']+"),
                    "comment",
                    4,
                    null,
                    4,
                    null
                ));
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create ("'/#' - '#/'"),
                    "comment",
                    4,
                    null,
                    4,
                    null
                ));
                tokenTypes.add (new TokenType (
                    null, 
                    Pattern.create ("['\\n' '\\r' ' ' '\\t']+"),
                    "whitespace",
                    5,
                    null,
                    5,
                    null
                ));
                
                Map<Integer,String> tokensMap = new HashMap<Integer,String> ();
                Iterator<TokenType> it = tokenTypes.iterator ();
                while (it.hasNext ()) {
                    TokenType tokenType = it.next ();
                    tokensMap.put (tokenType.getTypeID (), tokenType.getType ());
                }
                nbsLanguage = Language.create (
                    NBS_MIME_TYPE, 
                    tokensMap, 
                    Collections.<Feature>emptyList (), 
                    Parser.create (tokenTypes)
                );

                int OPERATOR_ID = nbsLanguage.getTokenID ("operator");
                ASTToken COLON = ASTToken.create (nbsLanguage, OPERATOR_ID, ":", 0);
                ASTToken PARENTHESIS = ASTToken.create (nbsLanguage, OPERATOR_ID, "(", 0);
                ASTToken PARENTHESIS2 = ASTToken.create (nbsLanguage, OPERATOR_ID, ")", 0);
                ASTToken BRACE = ASTToken.create (nbsLanguage, OPERATOR_ID, "{", 0);
                ASTToken BRACE2 = ASTToken.create (nbsLanguage, OPERATOR_ID, "}", 0);
                ASTToken LT = ASTToken.create (nbsLanguage, OPERATOR_ID, "<", 0);
                ASTToken GT = ASTToken.create (nbsLanguage, OPERATOR_ID, ">", 0);
                ASTToken DOT = ASTToken.create (nbsLanguage, OPERATOR_ID, ".", 0);
                ASTToken PLUS = ASTToken.create (nbsLanguage, OPERATOR_ID, "+", 0);
                ASTToken QUESTION = ASTToken.create (nbsLanguage, OPERATOR_ID, "?", 0);
                ASTToken MULTIPLY = ASTToken.create (nbsLanguage, OPERATOR_ID, "*", 0);
                ASTToken OR = ASTToken.create (nbsLanguage, OPERATOR_ID, "|", 0);
                ASTToken MINUS = ASTToken.create (nbsLanguage, OPERATOR_ID, "-", 0);
                ASTToken BRACKET = ASTToken.create (nbsLanguage, OPERATOR_ID, "[", 0);
                ASTToken BRACKET2 = ASTToken.create (nbsLanguage, OPERATOR_ID, "]", 0);
                ASTToken UPP = ASTToken.create (nbsLanguage, OPERATOR_ID, "^", 0);
                ASTToken EQUAL = ASTToken.create (nbsLanguage, OPERATOR_ID, "=", 0);
                ASTToken SEMICOLON = ASTToken.create (nbsLanguage, OPERATOR_ID, ";", 0);
                ASTToken COMMA = ASTToken.create (nbsLanguage, OPERATOR_ID, ",", 0);
                int KEYWORD_ID = nbsLanguage.getTokenID ("keyword");
                ASTToken KEYWORD = ASTToken.create (nbsLanguage, KEYWORD_ID, null, 0);
                ASTToken KEYWORD_TOKEN = ASTToken.create (nbsLanguage, KEYWORD_ID, "TOKEN", 0);
                IDENTIFIER_ID = nbsLanguage.getTokenID ("identifier");
                ASTToken IDENTIFIER = ASTToken.create (nbsLanguage, IDENTIFIER_ID, null, 0);
                ASTToken IDENTIFIER_I = ASTToken.create (nbsLanguage, IDENTIFIER_ID, "i", 0);
                int STRING_ID = nbsLanguage.getTokenID ("string");
                ASTToken STRING = ASTToken.create (nbsLanguage, STRING_ID, null, 0);
                WHITESPACE_ID = nbsLanguage.getTokenID ("whitespace");
                COMMENT_ID = nbsLanguage.getTokenID ("comment");

                List<Rule> rules = new ArrayList<Rule> ();
                rules.add (rule ("S", new Object[] {"token", "S"}));
                rules.add (rule ("S", new Object[] {"tokenState", "S"}));
                rules.add (rule ("S", new Object[] {"grammarRule", "S"}));
                rules.add (rule ("S", new Object[] {"command", "S"}));
                rules.add (rule ("S", new Object[] {}));

                rules.add (rule ("tokenState", new Object[] {"state", "tokenState1"}));
                rules.add (rule ("tokenState1", new Object[] {COLON, "token"}));
                rules.add (rule ("tokenState1", new Object[] {BRACE, "tokenGroup"}));
                rules.add (rule ("token", new Object[] {KEYWORD_TOKEN, COLON, IDENTIFIER, COLON, "token2"}));
                rules.add (rule ("token2", new Object[] {PARENTHESIS, "regularExpression", PARENTHESIS2, "token3"}));
                rules.add (rule ("token2", new Object[] {BRACE, "properties", BRACE2}));
                rules.add (rule ("token3", new Object[] {COLON, "state"}));
                rules.add (rule ("token3", new Object[] {}));
                rules.add (rule ("state", new Object[] {LT, IDENTIFIER, GT}));
                rules.add (rule ("tokenGroup", new Object[] {"tokensInGroup", BRACE2}));
                rules.add (rule ("tokensInGroup", new Object[] {"token", "tokensInGroup"}));
                rules.add (rule ("tokensInGroup", new Object[] {}));

                rules.add (rule ("regularExpression", new Object[] {"reChoice", "regularExpression1"}));
                rules.add (rule ("regularExpression1", new Object[] {OR, "reChoice", "regularExpression1"}));
                rules.add (rule ("regularExpression1", new Object[] {}));
                rules.add (rule ("reChoice", new Object[] {"rePart", "reChoice1"}));
                rules.add (rule ("reChoice1", new Object[] {"rePart", "reChoice1"}));
                rules.add (rule ("reChoice1", new Object[] {}));
                rules.add (rule ("rePart", new Object[] {STRING, "rePartOperatorOrMinus"}));
                rules.add (rule ("rePart", new Object[] {STRING, IDENTIFIER_I, "rePartOperatorOrMinus"}));
                rules.add (rule ("rePart", new Object[] {DOT, "rePartOperator"}));
                rules.add (rule ("rePart", new Object[] {"reClass", "rePartOperator"}));
                rules.add (rule ("rePart", new Object[] {PARENTHESIS, "regularExpression", PARENTHESIS2, "rePartOperator"}));
                rules.add (rule ("rePartOperator", new Object[] {}));
                rules.add (rule ("rePartOperator", new Object[] {PLUS}));
                rules.add (rule ("rePartOperator", new Object[] {QUESTION}));
                rules.add (rule ("rePartOperator", new Object[] {MULTIPLY}));
                rules.add (rule ("rePartOperatorOrMinus", new Object[] {MINUS, STRING}));
                rules.add (rule ("rePartOperatorOrMinus", new Object[] {"rePartOperator"}));
                rules.add (rule ("reClass", new Object[] {BRACKET, "reInClassNegation", "reInClass", BRACKET2}));
                rules.add (rule ("reInClassNegation", new Object[] {UPP}));
                rules.add (rule ("reInClassNegation", new Object[] {}));
                rules.add (rule ("reInClass", new Object[] {STRING, "reInClassMinus", "reInClass1"}));
                rules.add (rule ("reInClass1", new Object[] {STRING, "reInClassMinus", "reInClass1"}));
                rules.add (rule ("reInClass1", new Object[] {}));
                rules.add (rule ("reInClassMinus", new Object[] {MINUS, STRING}));
                rules.add (rule ("reInClassMinus", new Object[] {}));

                rules.add (rule ("grammarRule", new Object[] {IDENTIFIER, EQUAL, "grRightSide", SEMICOLON}));
                rules.add (rule ("grRightSide", new Object[] {"grChoice", "grRightSide1"}));
                rules.add (rule ("grRightSide1", new Object[] {OR, "grChoice", "grRightSide1"}));
                rules.add (rule ("grRightSide1", new Object[] {}));
                rules.add (rule ("grChoice", new Object[] {"grPart", "grChoice"}));
                rules.add (rule ("grChoice", new Object[] {}));
                rules.add (rule ("grPart", new Object[] {IDENTIFIER, "grOperator"}));
                rules.add (rule ("grPart", new Object[] {"tokenDef", "grOperator"}));
                rules.add (rule ("grPart", new Object[] {STRING, "grOperator"}));
                rules.add (rule ("grPart", new Object[] {BRACKET, "grRightSide", BRACKET2}));
                rules.add (rule ("grPart", new Object[] {PARENTHESIS, "grRightSide", PARENTHESIS2, "grOperator"}));
                rules.add (rule ("grOperator", new Object[] {PLUS}));
                rules.add (rule ("grOperator", new Object[] {MULTIPLY}));
                rules.add (rule ("grOperator", new Object[] {QUESTION}));
                rules.add (rule ("grOperator", new Object[] {}));
                rules.add (rule ("tokenDef", new Object[] {LT, IDENTIFIER, "tokenDef1", GT}));
                rules.add (rule ("tokenDef1", new Object[] {COMMA, STRING}));
                rules.add (rule ("tokenDef1", new Object[] {}));

                rules.add (rule ("command", new Object[] {KEYWORD, "command0"}));
                rules.add (rule ("command0", new Object[] {COLON, "selector", "command1"}));
                rules.add (rule ("command0", new Object[] {"value"}));
                rules.add (rule ("command1", new Object[] {COLON, "value"}));
                rules.add (rule ("command1", new Object[] {}));
                rules.add (rule ("value", new Object[] {"class"}));
                rules.add (rule ("value", new Object[] {STRING}));
                rules.add (rule ("value", new Object[] {BRACE, "properties", BRACE2}));
                rules.add (rule ("value", new Object[] {PARENTHESIS, "regularExpression", PARENTHESIS2}));
                rules.add (rule ("properties", new Object[] {"property", "properties"}));
                rules.add (rule ("properties", new Object[] {}));
                rules.add (rule ("property", new Object[] {IDENTIFIER, COLON, "propertyValue", SEMICOLON}));
                rules.add (rule ("propertyValue", new Object[] {STRING}));
                rules.add (rule ("propertyValue", new Object[] {"class"}));
                rules.add (rule ("propertyValue", new Object[] {PARENTHESIS, "regularExpression", PARENTHESIS2}));
                rules.add (rule ("selector", new Object[] {"class", "selector1"}));
                rules.add (rule ("selector1", new Object[] {COMMA, "class", "selector1"}));
                rules.add (rule ("selector1", new Object[] {}));
                rules.add (rule ("class", new Object[] {IDENTIFIER, "class1"}));
                rules.add (rule ("class1", new Object[] {DOT, IDENTIFIER, "class1"}));
                rules.add (rule ("class1", new Object[] {}));
                
                Set<Integer> skipTokenIDs = new HashSet<Integer> ();
                skipTokenIDs.add (nbsLanguage.getTokenID ("whitespace"));
                skipTokenIDs.add (nbsLanguage.getTokenID ("comment"));
                
                nbsLanguage.setAnalyser (LLSyntaxAnalyser.create (
                    nbsLanguage, rules, skipTokenIDs
                ));
            } catch (ParseException ex) {
                Utils.message (ex.getMessage ());
            }
        }
        return nbsLanguage;
    }

    
    private static Rule rule (String nt, Object[] right) {
        return Rule.create (
            nt, 
            Arrays.asList (right)
        );
    }
}
