/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.languages.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser.T;


/**
 *
 * @author Jan Jancura
 */
public class Petra {

    
    public static Map<String,Map> first2 (List rules, Language language) throws ParseException {
        Map<String,List<Integer>> ntToIndexes = new HashMap<String,List<Integer>> ();
        int i, k = rules.size ();
        for (i = 0; i < k; i++) {
            Rule cr = (Rule) rules.get (i);
            List<Integer> l = (List<Integer>) ntToIndexes.get (cr.getNT ());
            if (l == null) {
                l = new ArrayList ();
                ntToIndexes.put (cr.getNT (), l);
            }
            l.add (new Integer (i));
        }
        Map<String,Map> first = new HashMap<String,Map> ();
        Iterator<String> it = ntToIndexes.keySet ().iterator ();
        while (it.hasNext ()) {
            String nt = it.next ();
            Map firstForNT = new HashMap ();
            first.put (nt, firstForNT);
            List<Integer> indexes = ntToIndexes.get (nt);
            for (int depth = 1; depth < 4; depth++) {
//                    if (nt.equals ("SourceElement") && i == 4) throw new Error ();
                boolean changed = false;
                Iterator<Integer> it3 = indexes.iterator ();
                while (it3.hasNext ()) {
                    Integer index = it3.next ();
//                        System.out.println("f2 " + nt + " " + i);
                    Stack path = new Stack ();
                    path.push (nt);
                    Set pathSet = new HashSet ();
                    pathSet.add (nt);
                    try {
                        changed |= f2 (
                            ((Rule) rules.get (index.intValue ())).getRight (), 
                            0, 
                            index, 
                            depth, 
                            firstForNT, 
                            rules, 
                            ntToIndexes, 
                            new Stack (), 
                            pathSet,
                            path
                        );
                    } catch (ParseException ex) {
                        AnalyserAnalyser.printRules (rules, null);
                        AnalyserAnalyser.printF (first, null, language);
                        throw ex;
                    }
                }
                if (!changed) break;
            }
            //AnalyserAnalyser.printF (f, null);
        }
        it = first.keySet ().iterator ();
        while (it.hasNext ()) {
            String nt = (String) it.next ();
            first.put (nt, s ((Map) first.get (nt)));
        }
        return first;
    }
    
    private static boolean f2 (
        List    rightSide, 
        int     indexInRightSide, 
        Integer index, 
        int     depthLimit, 
        Map     inFirst, 
        List    rules, 
        Map     ntToIndexes, 
        Stack   hr, 
        Set     pathSet,
        
        Stack   path
    ) throws ParseException {
        Set s = (Set) inFirst.get ("&");
        if (s == null) {
            s = new HashSet ();
            inFirst.put ("&", s);
        }
        s.add (index);
        
        if (rightSide.size () <= indexInRightSide) {
            if (hr.empty ()) {
                s = (Set) inFirst.get ("#");
                if (s == null) {
                    s = new HashSet ();
                    inFirst.put ("#", s);
                }
                s.add (index);
                return false;
            }
            List nl = (List) hr.pop ();
            String nt = (String) path.pop ();
            pathSet.remove (nt);
            boolean r = f2 (nl, 0, index, depthLimit, inFirst, rules, ntToIndexes, hr, pathSet, path);
            path.push (nt);
            pathSet.add (nt);
            return r;
        }
        if (depthLimit < 1)
            return s.size () > 1;
        
        Object e = rightSide.get (indexInRightSide);
        if (e instanceof ASTToken) {
            T t = new T ((ASTToken) e);
            Map newInFirst = (Map) inFirst.get (t);
            if (newInFirst == null) {
                newInFirst = new HashMap ();
                inFirst.put (t, newInFirst);
            }
            return f2 (rightSide, indexInRightSide + 1, index, depthLimit - 1, newInFirst, rules, ntToIndexes, hr, new HashSet (), path);
        } else {
            String nnt = (String) e;
            List rns = (List) ntToIndexes.get (nnt);
            if (rns == null)
                throw new ParseException (nnt + " grammar rule not defined!");
            hr.push (rightSide.subList (indexInRightSide + 1, rightSide.size ()));
            if (pathSet.contains (nnt))
                return s.size () > 1;
            path.push (nnt);
            pathSet.add (nnt);
            boolean r = false;
            Iterator it = rns.iterator ();
            while (it.hasNext ()) {
                Integer rn = (Integer) it.next ();
                List rs = ((Rule) rules.get (rn.intValue ())).getRight ();
                Stack nhr = new Stack ();
                nhr.addAll (hr);
                r |= f2 (rs, 0, index, depthLimit, inFirst, rules, ntToIndexes, nhr, pathSet, path);
            }
            path.pop ();
            pathSet.remove (nnt);
            return r;
        }
    }

    
    
    // 88888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888
    public static Map<String,Map> first (List<Rule> rules) {
        Set set = new HashSet ();
        Map<String,Map> result = new HashMap<String,Map> ();
        int[] c = new int [] {0};
        boolean changed;
        int in = 0;
        do {
            changed = false;
            int i, k = rules.size ();
            for (i = 0; i < k; i++) {
                Rule r = rules.get (i);
                Map m1 = result.get (r.getNT ());
                if (m1 == null) {
                    m1 = new HashMap ();
                    result.put (r.getNT (), m1);
                }
                Set s = (Set) m1.get ("&");
                if (s == null) {
                    s = new HashSet ();
                    m1.put ("&", s);
                }
                int d = 1;
                if (m1.containsKey ("*"))
                    d = ((Integer) m1.get ("*")).intValue ();
                Integer ii = new Integer (i);
                s.add (ii);
                List path = new ArrayList ();
                path.add (r.getNT ());
                changed |= f (r.getRight (), 0, ii, result, m1, d, m1, path, set, c, r.getNT ());
            }
            in++;
        } while (changed && c[0] < 100000);
        System.out.println("steps " + in + " " + c [0]);
        if (c[0] >= 100000)
            System.out.println("too many steps!!!");
//        Iterator it = result.keySet ().iterator ();
//        while (it.hasNext ()) {
//            String mt = (String) it.next ();
//            Map m = (Map) result.get (mt);
//            Iterator it2 = m.keySet ().iterator ();
//            while (it2.hasNext ()) {
//                String nt = (String) it2.next ();
//                m.put (nt, s ((Map) m.get (nt)));
//            }
//        }
        return result;
    }
    
    private static Map s (Map m) {
        if (((Set) m.get ("&")).size () < 2) {
            Map r = new HashMap ();
            r.put ("&", m.get ("&"));
            return r;
        }
        Iterator it = m.keySet ().iterator ();
        while (it.hasNext ()) {
            Object e = it.next ();
            if (e instanceof T)
                m.put (e, s ((Map) m.get (e)));
        }
        return m;
    }
    
    private static boolean f (List l, int p, Integer i, Map m/*all nts*/, Map m1/*current p*/, int d, Map m3/*this nt*/, List path, Set set, int[] c, String nt) {
        Set s = (Set) m1.get ("&");
        if (s == null) {
            s = new HashSet ();
            m1.put ("&", s);
        }
        s.add (i);
        if (l.size () <= p) {
            s = (Set) m1.get ("#");
            if (s == null) {
                s = new HashSet ();
                m1.put ("#", s);
            }
            s.add (i);
            return false;
        }
        if (d < 1) {
            if (s.size () > 1) {
                int dd = 1;
                if (m3.containsKey ("*"))
                    dd = ((Integer) m3.get ("*")).intValue ();
                if (dd > 2) {
                    return false;
                }
                m3.put ("*", new Integer (++dd));
                return true;
            }
            return false;
        }
        Object e = l.get (p);
        if (e instanceof ASTToken) {
            T t = new T ((ASTToken) e);
            List path2 = new ArrayList (path);
//            path2.add (ll);
            Map m2 = (Map) m1.get (t);
            if (m2 == null) {
                //print (path2, i, set, m);
                //check (path2, m, false);
                m2 = new HashMap ();
                m1.put (t, m2);
                //check (path2, m, true);
                c[0]++;
                f (l, p + 1, i, m, m2, d - 1, m3, path2, set, c, nt);
                return true;
            } else {
                return f (l, p + 1, i, m, m2, d - 1, m3, path2, set, c, nt);
            }
        } else {
            String ss = (String) e;
            Map m2 = (Map) m.get (ss);
            if (m2 == null) return false;
            int dd = 1;
            if (m2.containsKey ("*"))
                dd = ((Integer) m2.get ("*")).intValue ();
            if (dd < d) {
                m2.put ("*", new Integer (d));
                f1 (l, p + 1, i, m, m2, m1, d, m3, path, set, c, nt);
                return true;
            }
            return f1 (l, p + 1, i, m, m2, m1, d, m3, path, set, c, nt);
        }
    }
    
    private static boolean f1 (List l, int p, Integer i, Map m/*all nts*/, Map m1/*source*/, Map m2/*current p*/, int d, Map m4/*this nt*/, List path, Set set, int[] c, String nt) {
        Set s = (Set) m2.get ("&");
        if (s == null) {
            s = new HashSet ();
            m2.put ("&", s);
        }
        boolean changed = !s.contains (i);
        //if (changed) printChanged (path, i);
        s.add (i);
        if (d < 1) {
            if (s.size () > 1) {
                int dd = 1;
                if (m4.containsKey ("*"))
                    dd = ((Integer) m4.get ("*")).intValue ();
                if (dd > 2) {
                    return false;
                }
                m4.put ("*", new Integer (++dd));
                return true;
            }
            return changed;
        }
        Iterator it = m1.keySet ().iterator ();
        while (it.hasNext ()) {
            Object o = it.next ();
            if ("#".equals (o))
                changed |= f (l, p, i, m, m2, d, m4, path, set, c, nt);
            else
            if ("&".equals (o)) continue;
            else
            if ("*".equals (o)) continue;
            else {
                T t = (T) o;
                List p2 = new ArrayList (path);
//                p2.add (ll);
                Map m3 = (Map) m2.get (t);
                if (m3 == null) {
                    //print (p2, i, set, m);
                    //check (p2, m, false);
                    m3 = new HashMap ();
                    m2.put (t, m3);
                    //check (p2, m, true);
                    changed = true;
                    c[0]++;
                }
                changed |= f1 (l, p, i, m, (Map) m1.get (t), m3, d - 1, m4, p2, set, c, nt);
            }
        }
        return changed;
    }
    
    private static void print (List l, Integer i, Set s, Map m, Language language) {
        if (s.size () == 100000)
            AnalyserAnalyser.printF (m, null, language);
        //System.out.println(l + ":" + i + " - " + s.size ());
//        Iterator it = l.iterator ();
//        while (it.hasNext ()) {
//            Object o = it.next ();
//            if (o instanceof List) {
//                List ll = (List) o;
//                if (ll.get (0) == null && ll.get (1) == null)
//                    System.out.println("null!");
//                if (!ll.toString ().endsWith ("]"))
//                    System.out.println("Bad end!");
//            }
//        }
        if (s.contains (l))
            System.out.println("Already added!!!");
        s.add (l);
    }
    
    private static void check (List l, Map m, boolean ch) {
        Iterator it = l.iterator ();
        Map mm = m;
        while (it.hasNext () && mm != null) {
            Object e = it.next ();
            mm = (Map) mm.get (e);
        }
        if ((mm == null) == ch)
            System.out.println("?!?!?!");
    }
    
    private static void printChanged (List l, Integer i) {
        System.out.println("Changed! " + l + ":" + i);
    }
}
