SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE METHOD(
    ID INT PRIMARY KEY, 
    NAME VARCHAR(100)
) ENGINE=INNODB;

CREATE INDEX METHODINDEX ON METHOD( NAME );

CREATE TABLE NBUSER(
    ID INT PRIMARY KEY,
    NAME VARCHAR(30)
    -- EMAIL VARCHAR(30)   - SHOULD BE KNOWN ..NBUSERNAME@NETBEANS.ORG
) ENGINE=INNODB;

CREATE INDEX NBUSERINDEX ON NBUSER( NAME );


CREATE TABLE EXCEPTIONS(
    ID INT PRIMARY KEY,
    SUMMARY VARCHAR(200),           -- EXCEPTION SUMMARY
    COMPONENT VARCHAR(50),
    SUBCOMPONENT VARCHAR(50),
    STACKTRACE INT UNIQUE,
    LOGGERNAME VARCHAR(255),
    VM VARCHAR(50),                 -- JDK VERSION 
    PRODUCTVERSION VARCHAR(255),     -- NETBEANS VERSION 
    OPERATINGSYSTEM VARCHAR(50),
    STATUS INT,
    ISSUEZILLAID INT,
    DUPLICATEOF INT,
    REPORTDATE TIMESTAMP,
    NBUSER_ID INT,
    BUILD DECIMAL(14,0),
    LOGFILE_ID INT,
    FOREIGN KEY (NBUSER_ID) REFERENCES NBUSER(ID),
    FOREIGN KEY (STACKTRACE) REFERENCES STACKTRACE(ID),
    FOREIGN KEY (DUPLICATEOF) REFERENCES EXCEPTIONS(ID),
    FOREIGN KEY (ISSUEZILLAID) REFERENCES ISSUE(ISSUE_ID),
    FOREIGN KEY (LOGFILE_ID) REFERENCES LOGFILE(ID)
) ENGINE=INNODB;

CREATE TABLE STACKTRACE(    -- REPREZENTS THROWN EXCEPTION
    ID INT PRIMARY KEY,  
    MESSAGE VARCHAR(1024),   -- ERROR MESSAGE
    CLASS VARCHAR(1024),     -- EXCEPTION CLASS (EX. :JAVA.LANG.NULLPOINTEREXCEPTION)
    ANNOTATION INT UNIQUE,   -- NULL REPREZENTS NO ANNOTATIONS, MORE ANNOTATIONS ARE ADDED RECURSIVELY
    FOREIGN KEY (ANNOTATION) REFERENCES STACKTRACE(ID)
) ENGINE=INNODB;

CREATE TABLE COMMENT(
    ID INT,     -- COMMENT NUMBER FOR GIVEN EXCEPTION
    EXCEPTION_ID INT,
    NBUSER_ID INT,
    COMMENT VARCHAR(1000),
    COMMENT_DATE TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (ID),
    FOREIGN KEY (EXCEPTION_ID) REFERENCES EXCEPTIONS(ID),
    FOREIGN KEY (NBUSER_ID) REFERENCES NBUSER(ID)
) ENGINE=INNODB;

CREATE TABLE JARFILE(
    ID INT PRIMARY KEY,
    NAME VARCHAR(200)
) ENGINE=INNODB;

CREATE TABLE LINE(          -- REPREZENTS ONE LINE OF STACKTRACE
    STACKTRACE_ID INT,      -- STACKTRACEID
    METHOD_ID INT,
    LINENUMBER INT, 
    LINE_ORDER INT,         -- GIVE US A SEQUENCE NUMBER IN STACK_TRACE. ONE LINE CAN BE FOR FEW TIMES IN ONE STACKTRACE
    JARFILE_ID INT,
    LINE_HASHCODE INT,
    GENERATECOMPONENT INT DEFAULT NULL,
    PRIMARY KEY (STACKTRACE_ID, LINENUMBER, METHOD_ID, LINE_ORDER),
    FOREIGN KEY (STACKTRACE_ID) REFERENCES STACKTRACE(ID),
    FOREIGN KEY (METHOD_ID) REFERENCES METHOD(ID),
    FOREIGN KEY (JARFILE_ID) REFERENCES JARFILE(ID)
) ENGINE=INNODB;

CREATE TABLE HASHCODES(
    CODE INT,
    EXCEPTIONID INT PRIMARY KEY,
    FOREIGN KEY (EXCEPTIONID) REFERENCES EXCEPTIONS(ID)
) ENGINE=INNODB;

CREATE TABLE `ISSUE` (
  `ISSUE_ID` INT NOT NULL,
  `ISSUE_STATUS` VARCHAR(100),
  `PRIORITY` CHAR(2),
  `RESOLUTION` VARCHAR(100),
  `COMPONENT` VARCHAR(100),
  `VERSION` VARCHAR(100),
  `REP_PLATFORM` VARCHAR(100),
  `ASSIGNED_TO` VARCHAR(100),
  `DELTA_TS` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `SUBCOMPONENT` VARCHAR(100),
  `REPORTER` VARCHAR(100),
  `TARGET_MILESTONE` VARCHAR(100),
  `ISSUE_TYPE` VARCHAR(100),
  `CREATION_TS` TIMESTAMP,
  `QA_CONTACT` VARCHAR(100),
  `STATUS_WHITEBOARD` VARCHAR(100),
  `VOTES` INT,
  `OP_SYS` VARCHAR(100),
  `SHORT_DESC` VARCHAR(2000),
  `KEYWORD` VARCHAR(100),
  `ISSUE_FILE_LOC` VARCHAR(200) NULL,
  PRIMARY KEY  (`ISSUE_ID`)
) ENGINE=INNODB;

CREATE TABLE NBVERSION (
    ID INT PRIMARY KEY,
    VERSION VARCHAR(32)
) ENGINE=INNODB;

CREATE TABLE PRODUCT_VERSION (
    ID INT PRIMARY KEY,
    NBVERSION_ID INT,
    PRODUCT_VERSION VARCHAR(255),
    FOREIGN KEY (NBVERSION_ID) REFERENCES NBVERSION(ID)
) ENGINE=INNODB;

CREATE TABLE LOGFILE (
    ID INT PRIMARY KEY,
    NBUSER_ID INT,
    PRODUCT_VERSION_ID INT,
    IP DECIMAL(12),
    BUILDNUMBER DECIMAL(14),    -- IT IS A PIECE OF PRODUCT VERSION
    USERDIR VARCHAR(255),
    UPLOAD_NUMBER INT,
    DATE_CREATED TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (NBUSER_ID) REFERENCES NBUSER(ID),
    FOREIGN KEY (PRODUCT_VERSION_ID) REFERENCES PRODUCT_VERSION(ID)
) ENGINE=INNODB;

CREATE INDEX GET_LOG_INFO ON LOGFILE (USERDIR, UPLOAD_NUMBER); -- USED ALSO IN PREPARE PAGE CONTEXT

CREATE TABLE LOGFILEPARSED (
    ID INT PRIMARY KEY,
    STATISTIC VARCHAR(64),
    LOGFILE_ID INT,
    REVISION INT,
    FOREIGN KEY (LOGFILE_ID) REFERENCES LOGFILE(ID)
) ENGINE=INNODB;

CREATE TABLE PREFERENCES (
    ID INT PRIMARY KEY,
    STATISTIC VARCHAR(64),
    LOGFILE_ID INT,
    PREFIX VARCHAR(1024),
    NAME VARCHAR(80),
    VALUE VARCHAR(8192),
    FOREIGN KEY (LOGFILE_ID) REFERENCES LOGFILE(ID)
) ENGINE=INNODB;

CREATE INDEX GET_PREFERENCES ON PREFERENCES(STATISTIC, PREFIX);

CREATE TABLE MAPPING(
    OLD_COMPONENT VARCHAR(50),
    OLD_SUBCOMPONENT VARCHAR(50),
    NEW_COMPONENT VARCHAR(50),
    NEW_SUBCOMPONENT VARCHAR(50),
    PRIMARY KEY(OLD_COMPONENT, OLD_SUBCOMPONENT)
) ENGINE=INNODB;

CREATE TABLE DIRECTUSER(
    NAME VARCHAR(30) PRIMARY KEY
) ENGINE=INNODB;

CREATE TABLE SEQUENCE(/* sequence table for autogenerated keys */
   SEQ_NAME VARCHAR(50) PRIMARY KEY,
   SEQ_COUNT DECIMAL
) ENGINE=INNODB;

INSERT INTO SEQUENCE(SEQ_NAME, SEQ_COUNT) values ('SEQ_GEN', 1);

SET FOREIGN_KEY_CHECKS = 1;
