/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.vmd.game.editor.grid;

import javax.swing.JScrollPane;
import org.netbeans.modules.vmd.game.model.Editable.ImageResourceInfo;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.openide.util.NbBundle;

/**
 *
 * @author  kherink
 */
public class ResourceImageEditor extends javax.swing.JPanel {
	
	private ResourceImageList resourceComponent;
	
	/** Creates new form ResourceImageEditor */
	public ResourceImageEditor() {
		initComponents();

		this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceImageEditor.class, "ResourceImageEditor.accessible.name"));
		this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceImageEditor.class, "ResourceImageEditor.accessible.description"));
		
		this.textFieldImage.setBackground(this.textFieldImage.getParent().getBackground());
		this.textFieldNumTiles.setBackground(this.textFieldNumTiles.getParent().getBackground());
		this.textFieldSize.setBackground(this.textFieldSize.getParent().getBackground());

		this.resourceComponent = new ResourceImageList();
		this.panelResourceList.add(new JScrollPane(this.resourceComponent));
	}
	
	public void setImageResourceInfo(ImageResourceInfo imageResourceInfo) {
		ImageResource imageResource = imageResourceInfo.getImageResource();
		int tileWidth = imageResourceInfo.getTileWidth();
		int tileHeight = imageResourceInfo.getTileHeight();
		boolean zeroBasedIndex = imageResourceInfo.isZeroBasedIndex();
		
		this.textFieldImage.setText(imageResource.getRelativeResourcePath());
		this.textFieldNumTiles.setText(Integer.toString(imageResource.getStaticTileCount(tileWidth, tileHeight)));
		this.textFieldSize.setText(org.openide.util.NbBundle.getMessage(ResourceImageEditor.class, "ResourceImageEditor.labelImage.txt", tileWidth, tileHeight));
		this.resourceComponent.setImageResource(imageResource, tileWidth, tileHeight, zeroBasedIndex);
		this.resourceComponent.setSelectedIndex(0);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        textFieldImage = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        textFieldNumTiles = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        textFieldSize = new javax.swing.JTextField();
        panelResourceList = new javax.swing.JPanel();

        jLabel1.setLabelFor(textFieldImage);
        jLabel1.setText(org.openide.util.NbBundle.getMessage(ResourceImageEditor.class, "ResourceImageEditor.labelImage.txt")); // NOI18N

        textFieldImage.setEditable(false);
        textFieldImage.setBorder(null);

        jLabel2.setLabelFor(textFieldNumTiles);
        jLabel2.setText(org.openide.util.NbBundle.getMessage(ResourceImageEditor.class, "ResourceImageEditor.labelCount.txt")); // NOI18N

        textFieldNumTiles.setEditable(false);
        textFieldNumTiles.setBorder(null);

        jLabel3.setLabelFor(textFieldSize);
        jLabel3.setText(org.openide.util.NbBundle.getMessage(ResourceImageEditor.class, "ResourceImageEditor.labelSize.txt")); // NOI18N

        textFieldSize.setEditable(false);
        textFieldSize.setBorder(null);

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(textFieldImage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 254, Short.MAX_VALUE)
                .add(24, 24, 24)
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(textFieldNumTiles, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(textFieldSize, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, textFieldSize, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, textFieldImage, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, textFieldNumTiles, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel3)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel2)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel1)
        );

        panelResourceList.setBackground(new java.awt.Color(255, 255, 255));
        panelResourceList.setLayout(new java.awt.BorderLayout());

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(panelResourceList, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 487, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(panelResourceList, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel panelResourceList;
    private javax.swing.JTextField textFieldImage;
    private javax.swing.JTextField textFieldNumTiles;
    private javax.swing.JTextField textFieldSize;
    // End of variables declaration//GEN-END:variables
	
}
