/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 

package org.netbeans.microedition.testme.svg.tests;

import javax.microedition.lcdui.Canvas;
import javax.microedition.m2g.SVGAnimator;
import javax.microedition.m2g.SVGImage;
import org.netbeans.microedition.testme.TestMIDlet;
import org.netbeans.microedition.testme.svg.support.SVGUtils;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class BoundingBoxTests extends TestMIDlet {
    
    private static final String TRANSFORM_TRAIT_NAME = "transform";

    private SVGImage _svgImage;
    private SVGAnimator _svgAnimator;
    
    public BoundingBoxTests() {
        super("xx",9);
    }
    
    /**
     * setup method (executed before each test)
     */
    protected void setUp() {
        getDisplay().setCurrent(getSVGCanvas());
        getSVGAnimator().play();
        getSVGImage().setViewportWidth(getSVGCanvas().getWidth());
        getSVGImage().setViewportHeight(getSVGCanvas().getHeight());  
    }
    
    /**
     * tear down method executed after each test
     */
    protected void tearDown() {
        getSVGAnimator().stop();
        clearImage();
    }
    
    
    
    
    
    private void testBBoxEquality(Document doc, String elementName, SVGRect expectedBBox) {
        SVGLocatableElement element = (SVGLocatableElement)doc.getElementById(elementName);
         SVGRect obtainedBBox = element.getBBox();
        log(elementName+": expected bbox = " + SVGUtils.toString(expectedBBox) + ", obtained bbox: " + SVGUtils.toString(obtainedBBox));        
        assertTrue(SVGUtils.equals(expectedBBox,obtainedBBox), elementName + " returns wrong bbox");
    }
    
    
    
    
    /**
     * core for testing BBOx
     */
    private void bboxTestCore(Document doc, SVGSVGElement svgsvg) {
        testBBoxEquality(doc,"item_1",SVGUtils.createSVGRect(svgsvg, -20f, -20f, 40f, 40f));
        testBBoxEquality(doc,"item_2",SVGUtils.createSVGRect(svgsvg, 20f, 20f, 40f, 40f));
        testBBoxEquality(doc,"item_3",SVGUtils.createSVGRect(svgsvg, 20f, 20f, 40f, 40f));
    }
    
    

    
    /**
     * test base BBox functionality in default viewbox
     */
    public void testBBox() {        
        Document doc = getSVGImage().getDocument();
        SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        bboxTestCore(doc,svgsvg);
    }
    
    /**
     * test base BBox functionality in modified viewbox
     */
    public void testBBox2() throws InterruptedException {        
        Document doc = getSVGImage().getDocument();
        final SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        log("Changing viewbox (zooming out)");
        SVGUtils.resizeViewbox(getSVGAnimator(),svgsvg,-500f,-500f,1000f,1000f);
        bboxTestCore(doc,svgsvg);
    }    
    
    
    public void testBBoxFromJSR1() {
        Document doc = getSVGImage().getDocument();
        SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        
        testBBoxEquality(doc, "group1", SVGUtils.createSVGRect(svgsvg, -70f, -60f, 230f, 200f));
        testBBoxEquality(doc, "rect1", SVGUtils.createSVGRect(svgsvg, 10f, 10f, 50f, 50f));
        testBBoxEquality(doc, "rect2", SVGUtils.createSVGRect(svgsvg, 10f, 10f, 100f, 100f));
        testBBoxEquality(doc, "group2", SVGUtils.createSVGRect(svgsvg, -80f, -80f, 230f, 200f));
        testBBoxEquality(doc, "rect3", SVGUtils.createSVGRect(svgsvg, 0f, 10f, 150f, 50f));
        testBBoxEquality(doc, "circle1", SVGUtils.createSVGRect(svgsvg, -80f, -80f, 200f, 200f));
    }
    
    
    /**
     * core test method to screen BBox
     */
    private void screenBBoxTestCore(Document doc, SVGSVGElement svgsvg, int viewportWidth, int viewportHeight) {
        
        SVGRect viewBox = svgsvg.getRectTrait("viewBox");                
        log("current viewBox = "+SVGUtils.toString(viewBox)+", viewportWidth="+viewportWidth+", viewportHeight="+viewportHeight);
        
        
        
        SVGLocatableElement item1 = (SVGLocatableElement)doc.getElementById("item_1");
        //SVGLocatableElement item2 = (SVGLocatableElement)doc.getElementById("item_2");
        //SVGLocatableElement item3 = (SVGLocatableElement)doc.getElementById("item_3");          
        
        SVGRect bbox1 = svgsvg.createSVGRect();
        bbox1.setX(-20f);
        bbox1.setY(-20f);
        bbox1.setWidth(40f);
        bbox1.setHeight(40f);              
        
        SVGRect obtainedSBBox1 = item1.getScreenBBox();
        SVGMatrix ctMatrix = item1.getScreenCTM();
        /*
        SVGRect convertedSBBox1 = SVGUtils.convertToUserUnits(svgsvg,obtainedSBBox1,viewBox,viewportWidth,viewportHeight);
        log("Item1: req bbox = " + SVGUtils.toString(bbox1) + ", obtained SBox: "
                +SVGUtils.toString(obtainedSBBox1)+", converted to bbox: " + SVGUtils.toString(convertedSBBox1));        
        log("Item1: ctMatrix1: "+SVGUtils.toString(ctMatrix));
        assertTrue(SVGUtils.equals(bbox1,convertedSBBox1),"item1");
         */
        
        SVGRect convertedSBBox1 = SVGUtils.transformUsingMX(svgsvg,bbox1,ctMatrix);
        log("Item1: req bbox = " + SVGUtils.toString(bbox1) + ", obtained SBox: "
                +SVGUtils.toString(obtainedSBBox1)+", bbox to sbbox: " + SVGUtils.toString(convertedSBBox1));        
        log("Item1: ctMatrix: "+SVGUtils.toString(ctMatrix));
        assertTrue(SVGUtils.equals(obtainedSBBox1,convertedSBBox1),"item1 returns wrong SBox");
        
    }    
    
    
    /***
     * Test for Screen BBox with default view box.
     */
    public void testScreenBBox() {
        Document doc = getSVGImage().getDocument();
        
        SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();     
        screenBBoxTestCore(doc,svgsvg,getSVGImage().getViewportWidth(),getSVGImage().getViewportHeight());      
        //screenBBoxTestCore(doc,svgsvg,getSVGCanvas().getWidth(),getSVGCanvas().getHeight());      
    }
    
    
    /**
     * Test for ScreenBBox for with modified view box
     */
    public void testScreenBBox2() throws InterruptedException {
        Document doc = getSVGImage().getDocument();
        final SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        log("Changing viewbox (zooming in)");
        SVGUtils.resizeViewbox(getSVGAnimator(),svgsvg,-10f,-10f,30f,30f);        
        screenBBoxTestCore(doc,svgsvg,getSVGImage().getViewportWidth(),getSVGImage().getViewportHeight());      
        //screenBBoxTestCore(doc,svgsvg,getSVGCanvas().getWidth(),getSVGCanvas().getHeight());      
    }    
    
    
    /**
     * Another test for ScreenBBox for modified view box
     */
    public void testScreenBBox3() throws InterruptedException {
        Document doc = getSVGImage().getDocument();
        final SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        
        log("Changing viewbox (zooming out)");
        SVGUtils.resizeViewbox(getSVGAnimator(),svgsvg,-500f,-500f,1000f,1000f);        
        
        screenBBoxTestCore(doc,svgsvg,getSVGImage().getViewportWidth(),getSVGImage().getViewportHeight());      
        //screenBBoxTestCore(doc,svgsvg,getSVGCanvas().getWidth(),getSVGCanvas().getHeight());      
    }    
    
    
    /**
     * Test for computing coordinate transformation matrix (from user to screen coordinates)
     */
    private void testCTMatrix() throws InterruptedException {
        Document doc = getSVGImage().getDocument();
        final SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        //log("prescale SVG: BBox="+SVGUtils.toString(svgsvg.getBBox())+", SBBox="+SVGUtils.toString(svgsvg.getScreenBBox()));
        
        SVGUtils.resizeViewbox(getSVGAnimator(),svgsvg,-10f, -10f, 10f, 10f);
        
        SVGMatrix computedCTM = SVGUtils.computeCTMatrixFromView(svgsvg,getSVGImage().getViewportWidth(),getSVGImage().getViewportHeight());        
        
        // now get the supplied ScreenCTM
        SVGMatrix obtainedCTM = svgsvg.getScreenCTM();
        log("SVG: obtainedCTM="+SVGUtils.toString(obtainedCTM)+", computedCTM="+SVGUtils.toString(computedCTM));
        assertTrue(SVGUtils.equals(computedCTM,obtainedCTM),"CT matrices differ");
        
    }    

    
    /**
     * core method for identity matrix test
     */
    private void identityMatrixTestCore(SVGSVGElement svgsvg, SVGLocatableElement item, String itemName) {
        SVGMatrix identityMatrix = svgsvg.createSVGMatrixComponents(1f,0f,0f,1f,0f,0f);
        SVGMatrix obtainedMatrix1 = item.getMatrixTrait(TRANSFORM_TRAIT_NAME);
        log(""+itemName+": identity mx = " + SVGUtils.toString(identityMatrix) + ", obtained mx: " 
                + SVGUtils.toString(obtainedMatrix1));        
        assertTrue(SVGUtils.equals(identityMatrix,obtainedMatrix1),""+itemName+" does not return identity matrix");        
    }
    
    
    /**
     * Identity matrix test on various element with default viewbox
     */
    public void testIdentityMatrix1() {
        Document doc = getSVGImage().getDocument();
        SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        SVGLocatableElement item1 = (SVGLocatableElement)doc.getElementById("item_1");
        //SVGLocatableElement item2 = (SVGLocatableElement)doc.getElementById("item_2");
        SVGLocatableElement item3 = (SVGLocatableElement)doc.getElementById("item_3");  
        
        // this should return identity matrix
        identityMatrixTestCore(svgsvg,item1,"item_1");
        identityMatrixTestCore(svgsvg,item3,"item_3");
    }

    /**
     * Identity matrix test on various element with modified viewbox
     */
    public void testIdentityMatrix2() throws InterruptedException {
        Document doc = getSVGImage().getDocument();
        SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();        
        
        SVGUtils.resizeViewbox(getSVGAnimator(),svgsvg, -10f, -10f, 20f, 20f);
        // rerun the test
        testIdentityMatrix1();
    }    
    

    /**
     * main test method
     */
    protected void runTest(int testNumber) throws Throwable {
        switch(testNumber) {
            case 1: testBBox(); break;
            case 2: testBBox2(); break;
            case 3: testBBoxFromJSR1(); break;
            case 4: testScreenBBox(); break;
            case 5: testScreenBBox2(); break;
            case 6: testScreenBBox3(); break;
            case 7: testCTMatrix(); break;
            case 8: testIdentityMatrix1(); break;
            case 9: testIdentityMatrix2(); break;
            default: break;
        }
    }
    
    
    // utility methods
    private SVGImage getSVGImage() {
        if (_svgImage == null) {                       
            try {                        
                _svgImage = (javax.microedition.m2g.SVGImage) javax.microedition.m2g.SVGImage.createImage(BoundingBoxTests.class.getResourceAsStream("/res/bboxtests.svg"), null);
            } catch (java.io.IOException exception) {
                exception.printStackTrace();
            }                      
        }                       
        return _svgImage;
    }               
    
    
    private SVGAnimator getSVGAnimator() {
        if (_svgAnimator == null) {
            _svgAnimator = SVGAnimator.createAnimator(getSVGImage());
        }
        return _svgAnimator;
    }
    
    private Canvas getSVGCanvas() {
        return (Canvas)getSVGAnimator().getTargetComponent();
    }

    private void clearImage() {
        _svgAnimator = null;
        _svgImage = null;
    }
    
    
}
