/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */ 

package org.netbeans.microedition.testme.svg.tests;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Image;
import org.netbeans.microedition.testme.svg.support.SVGTestMIDlet;
import org.netbeans.microedition.testme.svg.support.SVGUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGLocatableElement;

/**
 * The J2ME test suite for known issue related to the change of text element through
 * SVG DOM. If the text element uses custom/embedded font first change succeeds, but
 * all subsequent changes produces strange square boxes instead of the correct text.
 * @author  PavelBenes
 * @version
 */
public class EmbeddedFontTests extends SVGTestMIDlet {

    public EmbeddedFontTests() throws Exception {
        super("Embedded font unit test(s)", 1, "embeddedFont.svg", true);
    }
    
    protected void runTest(int testNumber) throws Throwable {
        switch(testNumber) {
            case 1: testEmdeddedFontTextChange(); break;
        }
    }    
    
    
    /**
     * This test verifies that two changes to the text element using embedded/custom
     * font produces correct result.
     */
    protected void testEmdeddedFontTextChange() {
        // change the text for the first time and take a screenshot
        log("Changing the text");
        changeText();
        final Image firstChange = takeScreenshot();

        // after one second change the text once more and take another screenshot
        new Timer().schedule( new TimerTask() {
            public void run() {
                log("Changing the text");
                changeText();
            }
        }, 1000);

        // after two seconds (to give the user some time to see the result) compare
        // the screenshots and end the test
        new Timer().schedule( new TimerTask() {
            public void run() {
                asynchronousTestCompleted(SVGUtils.imagesAreEqual(firstChange,
                        takeScreenshot()), "Images should be the same");
            }
        }, 2000);
    }

    private void changeText() {
        try {
            getSVGAnimator().invokeAndWait( new Runnable() {
                public void run() {
                    Document doc = getSVGImage().getDocument();
                    SVGLocatableElement element = (SVGLocatableElement)doc.getElementById("textElement");
                    element.setTrait("#text", "1");
                }
                
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        } 
    }    
}
